/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;

@GenerateUncached
public abstract class TypeCheckNode
extends EspressoNode {
    protected static final int LIMIT = 4;

    public abstract boolean executeTypeCheck(Klass var1, Klass var2);

    @Specialization(guards={"typeToCheck == k"})
    protected boolean typeCheckEquals(Klass typeToCheck, Klass k) {
        return true;
    }

    @Specialization(guards={"isJLObject(getContext(), typeToCheck)"})
    protected boolean typeCheckJLObject(Klass typeToCheck, Klass k) {
        return !k.isPrimitive();
    }

    @Specialization(guards={"isFinal(typeToCheck)"})
    protected boolean typeCheckFinal(ObjectKlass typeToCheck, Klass k) {
        return typeToCheck == k;
    }

    @Specialization(guards={"typeToCheck == cachedTTC", "k == cachedKlass"}, assumptions={"redefineAssumption"}, limit="LIMIT")
    protected boolean typeCheckCached(Klass typeToCheck, Klass k, @Cached(value="typeToCheck") Klass cachedTTC, @Cached(value="k") Klass cachedKlass, @Cached(value="k.getRedefineAssumption()") Assumption redefineAssumption, @Cached(value="doTypeCheck(typeToCheck, k)") boolean result) {
        return result;
    }

    @Specialization(replaces={"typeCheckCached"}, guards={"arrayBiggerDim(typeToCheck, k)"})
    protected boolean typeCheckArrayBiggerDim(ArrayKlass typeToCheck, ArrayKlass k) {
        return false;
    }

    @Specialization(replaces={"typeCheckCached"}, guards={"arrayBiggerDim(k, typeToCheck)"})
    protected boolean typeCheckArrayLowerDim(ArrayKlass typeToCheck, ArrayKlass k) {
        Meta meta = this.getMeta();
        Klass elem = typeToCheck.getElementalType();
        return elem == meta.java_lang_Object || elem == meta.java_io_Serializable || elem == meta.java_lang_Cloneable;
    }

    @Specialization(replaces={"typeCheckCached"}, guards={"typeToCheck != k", "arraySameDim(typeToCheck, k)"})
    protected boolean typeCheckArraySameDim(ArrayKlass typeToCheck, ArrayKlass k, @Cached TypeCheckNode tcn) {
        return tcn.executeTypeCheck(typeToCheck.getElementalType(), k.getElementalType());
    }

    @Specialization(replaces={"typeCheckCached"}, guards={"!k.isArray()"})
    protected boolean typeCheckArrayFalse(ArrayKlass typeToCheck, Klass k) {
        return false;
    }

    @Specialization(replaces={"typeCheckCached"}, guards={"typeToCheck != k", "isInterface(typeToCheck)"})
    protected boolean typeCheckInterface(Klass typeToCheck, Klass k) {
        return typeToCheck.checkInterfaceSubclassing(k);
    }

    @Specialization(replaces={"typeCheckCached"}, guards={"typeToCheck != k", "!isInterface(typeToCheck)", "!typeToCheck.isArray()"})
    protected boolean typeCheckRegular(Klass typeToCheck, Klass k) {
        return typeToCheck.checkOrdinaryClassSubclassing(k);
    }

    protected static boolean isJLObject(EspressoContext context, Klass k) {
        return k == context.getMeta().java_lang_Object;
    }

    protected static boolean isFinal(Klass k) {
        return k.isFinalFlagSet();
    }

    protected static boolean isPrimitive(Klass k) {
        return k.isPrimitive();
    }

    protected static boolean doTypeCheck(Klass typeToCheck, Klass k) {
        return typeToCheck.isAssignableFrom(k);
    }

    protected static boolean arraySameDim(ArrayKlass k1, ArrayKlass k2) {
        return k1.getDimension() == k2.getDimension();
    }

    protected static boolean arrayBiggerDim(ArrayKlass k1, ArrayKlass k2) {
        return k1.getDimension() > k2.getDimension();
    }

    protected static boolean isInterface(Klass k) {
        return k.isInterface();
    }
}

