/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.helper;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.BytecodeNode;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.helper.BooleanSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.ByteSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.CharSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.DoubleSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.FloatSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.IntSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.LongSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.ObjectSetFieldNodeGen;
import com.oracle.truffle.espresso.nodes.helper.ShortSetFieldNodeGen;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public abstract class AbstractSetFieldNode
extends EspressoNode {
    final Field field;
    final String fieldName;
    static final int CACHED_LIBRARY_LIMIT = 3;

    AbstractSetFieldNode(Field field) {
        this.field = field;
        this.fieldName = field.getNameAsString();
    }

    public abstract void setField(VirtualFrame var1, BytecodeNode var2, StaticObject var3, int var4, int var5);

    public static AbstractSetFieldNode create(Field f) {
        switch (f.getKind()) {
            case Boolean: {
                return BooleanSetFieldNodeGen.create(f);
            }
            case Byte: {
                return ByteSetFieldNodeGen.create(f);
            }
            case Short: {
                return ShortSetFieldNodeGen.create(f);
            }
            case Char: {
                return CharSetFieldNodeGen.create(f);
            }
            case Int: {
                return IntSetFieldNodeGen.create(f);
            }
            case Float: {
                return FloatSetFieldNodeGen.create(f);
            }
            case Long: {
                return LongSetFieldNodeGen.create(f);
            }
            case Double: {
                return DoubleSetFieldNodeGen.create(f);
            }
            case Object: {
                return ObjectSetFieldNodeGen.create(f);
            }
        }
        throw EspressoError.shouldNotReachHere();
    }

    protected void setForeignField(StaticObject receiver, Object fieldValue, InteropLibrary interopLibrary, EspressoLanguage language, EspressoContext context, BranchProfile error) {
        assert (this.field.getDeclaringKlass().isAssignableFrom(receiver.getKlass()));
        assert (receiver.isForeignObject());
        assert (!(fieldValue instanceof StaticObject) || !((StaticObject)fieldValue).isForeignObject());
        try {
            interopLibrary.writeMember(receiver.rawForeignObject(language), this.fieldName, fieldValue);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            error.enter();
            Meta meta = context.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_NoSuchFieldError, "Foreign object has no writable field %s", this.fieldName);
        }
        catch (UnsupportedTypeException e) {
            error.enter();
            Meta meta = context.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_ClassCastException, "Could not cast the value to the actual type of the foreign field %s", this.fieldName);
        }
    }
}

