/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.analysis.hierarchy.AssumptionGuardedValue;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.NullCheck;
import com.oracle.truffle.espresso.nodes.bytecodes.Utils;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@NodeInfo(shortName="INVOKEINTERFACE")
public abstract class InvokeInterface
extends EspressoNode {
    final Method resolutionSeed;

    InvokeInterface(Method resolutionSeed) {
        this.resolutionSeed = resolutionSeed;
    }

    public abstract Object execute(Object[] var1);

    @Specialization
    Object doWithNullCheck(Object[] args, @Cached NullCheck nullCheck, @Cached(value="create(resolutionSeed)") WithoutNullCheck invokeInterface) {
        StaticObject receiver = (StaticObject)args[0];
        nullCheck.execute(receiver);
        return invokeInterface.execute(args);
    }

    static StaticObject getReceiver(Object[] args) {
        return (StaticObject)args[0];
    }

    static Method.MethodVersion methodLookup(Method resolutionSeed, Klass receiverKlass) {
        assert (!receiverKlass.isArray());
        if (resolutionSeed.isRemovedByRedefinition()) {
            return resolutionSeed.getContext().getClassRedefinition().handleRemovedMethod(resolutionSeed, receiverKlass).getMethodVersion();
        }
        int iTableIndex = resolutionSeed.getITableIndex();
        Method method = ((ObjectKlass)receiverKlass).itableLookup(resolutionSeed.getDeclaringKlass(), iTableIndex);
        if (!method.isPublic()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Meta meta = receiverKlass.getMeta();
            throw meta.throwException(meta.java_lang_IllegalAccessError);
        }
        return method.getMethodVersion();
    }

    @NodeInfo(shortName="INVOKEINTERFACE !nullcheck")
    @ImportStatic(value={InvokeInterface.class, Utils.class})
    public static abstract class WithoutNullCheck
    extends EspressoNode {
        protected static final int LIMIT = 8;
        final Method resolutionSeed;

        WithoutNullCheck(Method resolutionSeed) {
            this.resolutionSeed = resolutionSeed;
        }

        public abstract Object execute(Object[] var1);

        protected ClassHierarchyAssumption getNoImplementorsAssumption() {
            return this.getContext().getClassHierarchyOracle().hasNoImplementors(this.resolutionSeed.getDeclaringKlass());
        }

        protected AssumptionGuardedValue<ObjectKlass> readSingleImplementor() {
            return this.getContext().getClassHierarchyOracle().readSingleImplementor(this.resolutionSeed.getDeclaringKlass());
        }

        @CompilerDirectives.TruffleBoundary
        EspressoException reportNotAnImplementor(Klass receiverKlass) {
            ObjectKlass interfaceKlass = this.resolutionSeed.getDeclaringKlass();
            assert (!interfaceKlass.checkInterfaceSubclassing(receiverKlass));
            Meta meta = receiverKlass.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, "Class %s does not implement interface %s", receiverKlass.getName(), interfaceKlass.getName());
        }

        @Specialization(assumptions={"maybeSingleImplementor.hasValue()", "resolvedMethod.getRedefineAssumption()"}, guards={"implementor != null"})
        Object callSingleImplementor(Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="readSingleImplementor()") AssumptionGuardedValue<ObjectKlass> maybeSingleImplementor, @Cached(value="maybeSingleImplementor.get()") ObjectKlass implementor, @Cached(value="methodLookup(resolutionSeed, implementor)") Method.MethodVersion resolvedMethod, @Cached(value="createAndMaybeForceInline(resolvedMethod)") DirectCallNode directCallNode, @Cached BranchProfile notAnImplementorProfile) {
            assert (args[0] == receiver);
            assert (!StaticObject.isNull(receiver));
            if (receiver.getKlass() != implementor) {
                notAnImplementorProfile.enter();
                throw this.reportNotAnImplementor(receiver.getKlass());
            }
            return directCallNode.call(args);
        }

        @Specialization(limit="LIMIT", guards={"receiver.getKlass() == cachedKlass"}, assumptions={"resolvedMethod.getRedefineAssumption()"})
        Object callDirect(Object[] args, @Bind(value="getReceiver(args)") StaticObject receiver, @Cached(value="receiver.getKlass()") Klass cachedKlass, @Cached(value="methodLookup(resolutionSeed, cachedKlass)") Method.MethodVersion resolvedMethod, @Cached(value="createAndMaybeForceInline(resolvedMethod)") DirectCallNode directCallNode) {
            assert (!StaticObject.isNull(receiver));
            return directCallNode.call(args);
        }

        @Specialization
        @ReportPolymorphism.Megamorphic
        Object callIndirect(Object[] args, @Cached IndirectCallNode indirectCallNode) {
            StaticObject receiver = (StaticObject)args[0];
            assert (!StaticObject.isNull(receiver));
            Method.MethodVersion target = InvokeInterface.methodLookup(this.resolutionSeed, receiver.getKlass());
            return indirectCallNode.call(target.getCallTarget(), args);
        }
    }

    @NodeInfo(shortName="INVOKEINTERFACE dynamic")
    @GenerateUncached
    public static abstract class Dynamic
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract Object execute(Method var1, Object[] var2);

        @Specialization
        Object doWithNullCheck(Method resolutionSeed, Object[] args, @Cached NullCheck nullCheck, @Cached WithoutNullCheck invokeInterface) {
            StaticObject receiver = (StaticObject)args[0];
            nullCheck.execute(receiver);
            return invokeInterface.execute(resolutionSeed, args);
        }

        @NodeInfo(shortName="INVOKEINTERFACE dynamic !nullcheck")
        @GenerateUncached
        public static abstract class WithoutNullCheck
        extends EspressoNode {
            protected static final int LIMIT = 4;

            public abstract Object execute(Method var1, Object[] var2);

            @Specialization(limit="LIMIT", guards={"resolutionSeed == cachedResolutionSeed"})
            Object doCached(Method resolutionSeed, Object[] args, @Cached(value="resolutionSeed") Method cachedResolutionSeed, @Cached(value="create(cachedResolutionSeed)") com.oracle.truffle.espresso.nodes.bytecodes.InvokeInterface$WithoutNullCheck invokeInterface) {
                return invokeInterface.execute(args);
            }

            @Specialization(replaces={"doCached"})
            @ReportPolymorphism.Megamorphic
            Object doGeneric(Method resolutionSeed, Object[] args, @Cached IndirectCallNode indirectCallNode) {
                StaticObject receiver = (StaticObject)args[0];
                assert (!StaticObject.isNull(receiver));
                Method.MethodVersion target = InvokeInterface.methodLookup(resolutionSeed, receiver.getKlass());
                return indirectCallNode.call(target.getCallTarget(), args);
            }
        }
    }
}

