/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.analysis.hierarchy.AssumptionGuardedValue;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.nodes.bytecodes.InstanceOfFactory;

@NodeInfo(shortName="INSTANCEOF constant class")
public abstract class InstanceOf
extends EspressoNode {
    public abstract boolean execute(Klass var1);

    public static InstanceOf create(Klass superType, boolean useInlineCache) {
        if (superType.isJavaLangObject()) {
            return ObjectClass.INSTANCE;
        }
        if (superType.isPrimitive()) {
            return new PrimitiveClass((PrimitiveKlass)superType);
        }
        if (!superType.isArray() && superType.isFinalFlagSet()) {
            return new FinalClass(superType);
        }
        if (useInlineCache) {
            return InstanceOfFactory.InlineCacheNodeGen.create(superType);
        }
        if (superType.isInstanceClass()) {
            return InstanceOfFactory.ConstantClassNodeGen.create((ObjectKlass)superType);
        }
        if (superType.isArray()) {
            return InstanceOfFactory.ArrayClassNodeGen.create((ArrayKlass)superType);
        }
        if (superType.isInterface()) {
            return InstanceOfFactory.ConstantInterfaceNodeGen.create((ObjectKlass)superType);
        }
        throw EspressoError.shouldNotReachHere();
    }

    @NodeInfo(shortName="INSTANCEOF Ljava/lang/Object;")
    private static final class ObjectClass
    extends InstanceOf {
        static final InstanceOf INSTANCE = new ObjectClass();

        private ObjectClass() {
        }

        @Override
        public boolean execute(Klass maybeSubtype) {
            return !(maybeSubtype instanceof PrimitiveKlass);
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @NodeInfo(shortName="INSTANCEOF primitive")
    private static final class PrimitiveClass
    extends InstanceOf {
        private final PrimitiveKlass superType;

        PrimitiveClass(PrimitiveKlass superType) {
            this.superType = superType;
        }

        @Override
        public boolean execute(Klass maybeSubtype) {
            return this.superType == maybeSubtype;
        }
    }

    @NodeInfo(shortName="INSTANCEOF final non-array class")
    private static final class FinalClass
    extends InstanceOf {
        private final Klass superType;

        FinalClass(Klass superType) {
            assert (superType.isFinalFlagSet() && !superType.isArray());
            this.superType = superType;
        }

        @Override
        public boolean execute(Klass maybeSubtype) {
            return this.superType == maybeSubtype;
        }
    }

    @NodeInfo(shortName="INSTANCEOF + inline cache")
    static abstract class InlineCache
    extends InstanceOf {
        protected static final int LIMIT = 4;
        protected final Klass superType;

        protected InlineCache(Klass superType) {
            this.superType = superType;
        }

        @Specialization(guards={"superType == maybeSubtype"})
        boolean doSame(Klass maybeSubtype) {
            return true;
        }

        @Specialization(guards={"cachedMaybeSubtype == maybeSubtype"}, limit="LIMIT", assumptions={"redefineAssumption"})
        boolean doCached(Klass maybeSubtype, @Cached(value="maybeSubtype") Klass cachedMaybeSubtype, @Cached(value="maybeSubtype.getRedefineAssumption()") Assumption redefineAssumption, @Cached(value="superType.isAssignableFrom(maybeSubtype)") boolean result) {
            return result;
        }

        @Specialization(replaces={"doCached"})
        public boolean doGeneric(Klass maybeSubtype, @Cached(value="createGeneric(superType)") InstanceOf genericInstanceOf) {
            return genericInstanceOf.execute(maybeSubtype);
        }

        protected static InstanceOf createGeneric(Klass superType) {
            return InstanceOf.create(superType, false);
        }
    }

    @NodeInfo(shortName="INSTANCEOF class")
    static abstract class ConstantClass
    extends InstanceOf {
        private final ObjectKlass superType;

        ConstantClass(ObjectKlass superType) {
            this.superType = superType;
        }

        @NeverDefault
        protected ClassHierarchyAssumption getNoImplementorsAssumption() {
            return this.getContext().getClassHierarchyOracle().hasNoImplementors(this.superType);
        }

        @NeverDefault
        protected AssumptionGuardedValue<ObjectKlass> readSingleImplementor() {
            return this.getContext().getClassHierarchyOracle().readSingleImplementor(this.superType);
        }

        @Specialization(guards={"noImplementors.isValid()"})
        public boolean doNoImplementors(Klass maybeSubtype, @Cached(value="getNoImplementorsAssumption().getAssumption()") Assumption noImplementors) {
            return false;
        }

        @Specialization(assumptions={"maybeSingleImplementor.hasValue()"}, guards={"implementor != null"})
        public boolean doSingleImplementor(ObjectKlass maybeSubtype, @Cached(value="readSingleImplementor()") AssumptionGuardedValue<ObjectKlass> maybeSingleImplementor, @Cached(value="maybeSingleImplementor.get()") ObjectKlass implementor) {
            return maybeSubtype == implementor;
        }

        @Specialization
        public boolean doObjectKlass(ObjectKlass maybeSubtype) {
            return this.superType == maybeSubtype || this.superType.checkOrdinaryClassSubclassing(maybeSubtype);
        }

        @Fallback
        public boolean doFallback(Klass maybeSubtype) {
            return false;
        }
    }

    @NodeInfo(shortName="INSTANCEOF array class")
    static abstract class ArrayClass
    extends InstanceOf {
        private final ArrayKlass superType;
        @Node.Child
        InstanceOf elementalInstanceOf;

        protected ArrayClass(ArrayKlass superType) {
            this.superType = superType;
            this.elementalInstanceOf = InstanceOf.create(superType.getElementalType(), true);
        }

        @Specialization
        boolean doArray(ArrayKlass maybeSubtype, @Cached BranchProfile nonTrivialProfile, @Cached BranchProfile elementalCheckProfile, @Cached BranchProfile simpleSubTypeCheckProfile) {
            if (this.superType == maybeSubtype) {
                return true;
            }
            nonTrivialProfile.enter();
            int comparison = Integer.compare(this.superType.getDimension(), maybeSubtype.getDimension());
            if (comparison == 0) {
                elementalCheckProfile.enter();
                return this.elementalInstanceOf.execute(maybeSubtype.getElementalType());
            }
            if (comparison < 0) {
                simpleSubTypeCheckProfile.enter();
                Klass elemental = this.superType.getElementalType();
                Meta meta = this.getMeta();
                return elemental == meta.java_lang_Object || elemental == meta.java_io_Serializable || elemental == meta.java_lang_Cloneable;
            }
            return false;
        }

        @Fallback
        boolean doFallback(Klass maybeSubtype) {
            assert (!maybeSubtype.isArray());
            return false;
        }
    }

    @NodeInfo(shortName="INSTANCEOF interface")
    static abstract class ConstantInterface
    extends InstanceOf {
        private final ObjectKlass superType;

        ConstantInterface(ObjectKlass superType) {
            this.superType = superType;
            assert (superType.isInterface());
        }

        @NeverDefault
        protected ClassHierarchyAssumption getNoImplementorsAssumption() {
            return this.getContext().getClassHierarchyOracle().hasNoImplementors(this.superType);
        }

        @NeverDefault
        protected AssumptionGuardedValue<ObjectKlass> readSingleImplementor() {
            return this.getContext().getClassHierarchyOracle().readSingleImplementor(this.superType);
        }

        @Specialization(guards={"noImplementors.isValid()"})
        public boolean doNoImplementors(Klass maybeSubtype, @Cached(value="getNoImplementorsAssumption().getAssumption()") Assumption noImplementors) {
            return false;
        }

        @Specialization(assumptions={"maybeSingleImplementor.hasValue()"}, guards={"implementor != null"}, replaces={"doNoImplementors"})
        public boolean doSingleImplementor(ObjectKlass maybeSubtype, @Cached(value="readSingleImplementor()") AssumptionGuardedValue<ObjectKlass> maybeSingleImplementor, @Cached(value="maybeSingleImplementor.get()") ObjectKlass implementor) {
            return maybeSubtype == implementor;
        }

        @Specialization(replaces={"doSingleImplementor"})
        public boolean doObjectKlass(ObjectKlass maybeSubtype) {
            return this.superType.checkInterfaceSubclassing(maybeSubtype);
        }

        @Specialization
        public boolean doArrayKlass(ArrayKlass maybeSubtype) {
            Meta meta = this.getMeta();
            return this.superType == meta.java_lang_Cloneable || this.superType == meta.java_io_Serializable;
        }

        @Fallback
        public boolean doFallback(Klass maybeSubtype) {
            return false;
        }
    }

    @NodeInfo(shortName="INSTANCEOF dynamic check")
    @GenerateUncached
    public static abstract class Dynamic
    extends EspressoNode {
        protected static final int LIMIT = 4;

        public abstract boolean execute(Klass var1, Klass var2);

        protected static InstanceOf createInstanceOf(Klass superType) {
            return InstanceOf.create(superType, true);
        }

        @Specialization(guards={"superType == maybeSubtype"})
        boolean doSame(Klass maybeSubtype, Klass superType) {
            return true;
        }

        @Specialization(guards={"superType == cachedSuperType"}, limit="LIMIT")
        boolean doCached(Klass maybeSubType, Klass superType, @Cached(value="superType") Klass cachedSuperType, @Cached(value="createInstanceOf(cachedSuperType)") InstanceOf instanceOf) {
            return instanceOf.execute(maybeSubType);
        }

        @Specialization(replaces={"doCached"})
        @HostCompilerDirectives.InliningCutoff
        protected boolean doGeneric(Klass maybeSubType, Klass superType) {
            return superType.isAssignableFrom(maybeSubType);
        }
    }
}

