/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.nodes.EspressoNode;

@NodeInfo(shortName="class initcheck")
@GenerateUncached
public abstract class InitCheck
extends EspressoNode {
    protected static final int LIMIT = 1;

    public abstract void execute(ObjectKlass var1);

    @Specialization(limit="LIMIT", guards={"cachedKlass == klass"})
    void doCached(ObjectKlass klass, @Cached(value="klass") ObjectKlass cachedKlass) {
        if (!klass.isInitialized()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            cachedKlass.safeInitialize();
        }
    }

    @Specialization(replaces={"doCached"})
    void doGeneric(ObjectKlass klass) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)klass)) {
            if (!klass.isInitialized()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                klass.safeInitialize();
            }
        } else {
            InitCheck.initCheckBoundary(klass);
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    static void initCheckBoundary(ObjectKlass klass) {
        if (!klass.isInitialized()) {
            klass.safeInitialize();
        }
    }
}

