/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.ffi.nfi.NativeUtils;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

final class NativeMethodNode
extends EspressoInstrumentableRootNodeImpl {
    private final TruffleObject boundNative;
    @Node.Child
    InteropLibrary executeNative;
    @CompilerDirectives.CompilationFinal
    boolean throwsException;
    private static final DebugCounter NATIVE_METHOD_CALLS = DebugCounter.create("Native method calls");

    NativeMethodNode(TruffleObject boundNative, Method.MethodVersion method) {
        super(method);
        this.boundNative = boundNative;
        this.executeNative = (InteropLibrary)InteropLibrary.getFactory().create((Object)boundNative);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object toObjectHandle(JniEnv env, Object arg) {
        assert (arg instanceof StaticObject);
        return (long)env.getHandles().createLocal((StaticObject)arg);
    }

    @ExplodeLoop
    private Object[] preprocessArgs(JniEnv env, Object[] args) {
        Symbol<Symbol.Type>[] parsedSignature = this.getMethodVersion().getMethod().getParsedSignature();
        int paramCount = Signatures.parameterCount(parsedSignature);
        Object[] nativeArgs = new Object[2 + paramCount];
        assert (!InteropLibrary.getUncached().isNull((Object)env.getNativePointer()));
        nativeArgs[0] = env.getNativePointer();
        nativeArgs[1] = this.getMethodVersion().isStatic() ? NativeMethodNode.toObjectHandle(env, this.getMethodVersion().getDeclaringKlass().mirror()) : NativeMethodNode.toObjectHandle(env, args[0]);
        int skipReceiver = this.getMethodVersion().isStatic() ? 0 : 1;
        for (int i = 0; i < paramCount; ++i) {
            Symbol<Symbol.Type> paramType = Signatures.parameterType(parsedSignature, i);
            nativeArgs[i + 2] = Types.isReference(paramType) ? NativeMethodNode.toObjectHandle(env, args[i + skipReceiver]) : args[i + skipReceiver];
        }
        return nativeArgs;
    }

    @Override
    void beforeInstumentation(VirtualFrame frame) {
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JniEnv env = this.getContext().getJNI();
        int nativeFrame = env.getHandles().pushFrame();
        NATIVE_METHOD_CALLS.inc();
        try {
            Object[] nativeArgs = this.preprocessArgs(env, frame.getArguments());
            Object result = this.executeNative.execute((Object)this.boundNative, nativeArgs);
            Object object = this.processResult(env, result);
            return object;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        finally {
            env.getHandles().popFramesIncluding(nativeFrame);
        }
    }

    private void enterThrowsException() {
        if (!this.throwsException) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.throwsException = true;
        }
    }

    private void maybeThrowAndClearPendingException(JniEnv jniEnv) {
        EspressoException ex = jniEnv.getPendingEspressoException();
        if (ex != null) {
            this.enterThrowsException();
            jniEnv.clearPendingException();
            throw ex;
        }
    }

    private Object processResult(JniEnv env, Object result) {
        this.maybeThrowAndClearPendingException(env);
        Symbol<Symbol.Type> returnType = Signatures.returnType(this.getMethodVersion().getMethod().getParsedSignature());
        if (Types.isReference(returnType)) {
            long addr;
            if (result instanceof Long) {
                addr = (Long)result;
            } else {
                assert (result instanceof TruffleObject);
                addr = NativeUtils.interopAsPointer((TruffleObject)result);
            }
            return env.getHandles().get(Math.toIntExact(addr));
        }
        assert (returnType != Symbol.Type._void || result == StaticObject.NULL);
        return result;
    }
}

