/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.nodes;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.EspressoInstrumentableRootNodeImpl;
import com.oracle.truffle.espresso.substitutions.CallableFromNative;

final class IntrinsifiedNativeMethodNode
extends EspressoInstrumentableRootNodeImpl {
    @Node.Child
    private CallableFromNative nativeMethod;
    private final Object env;

    IntrinsifiedNativeMethodNode(Method.MethodVersion methodVersion, CallableFromNative.Factory factory, Object env) {
        super(methodVersion);
        assert (CallableFromNative.validParameterCount(factory, methodVersion));
        this.nativeMethod = (CallableFromNative)this.insert(factory.create());
        this.env = env;
    }

    @Override
    void beforeInstumentation(VirtualFrame frame) {
    }

    @Override
    Object execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        Method method = this.getMethodVersion().getMethod();
        if (method.isStatic()) {
            int parameterCount = method.getParameterCount();
            Object[] newArgs = new Object[parameterCount + 1];
            newArgs[0] = method.getDeclaringKlass().mirror();
            System.arraycopy(args, 0, newArgs, 1, parameterCount);
            args = newArgs;
        }
        return this.nativeMethod.invokeDirect(this.env, args);
    }
}

