/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_Unsafe;

public class StringUtil {
    static final byte LATIN1 = 0;
    static final byte UTF16 = 1;
    private static final int MAX_LENGTH = 0x3FFFFFFF;
    private static final int HI_BYTE_SHIFT;
    private static final int LO_BYTE_SHIFT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static byte[] toBytes(char[] value) {
        return StringUtil.toBytes(value, 0, value.length);
    }

    public static char[] toChars(byte[] value) {
        char[] dst = new char[value.length >> 1];
        StringUtil.getChars(value, 0, dst.length, dst, 0);
        return dst;
    }

    public static byte[] compress(char[] val) {
        int off = 0;
        int len = val.length;
        byte[] ret = new byte[len];
        if (StringUtil.compress(val, off, ret, 0, len) == len) {
            return ret;
        }
        return null;
    }

    private static int compress(char[] src, int srcOffset, byte[] dst, int dstOffset, int len) {
        int dstOff = dstOffset;
        int srcOff = srcOffset;
        for (int i = 0; i < len; ++i) {
            char c = src[srcOff];
            if (c > '\u00ff') {
                return 0;
            }
            dst[dstOff] = (byte)c;
            ++srcOff;
            ++dstOff;
        }
        return len;
    }

    private static byte[] toBytes(char[] value, int offset, int len) {
        int off = offset;
        byte[] val = StringUtil.newBytesFor(len);
        for (int i = 0; i < len; ++i) {
            StringUtil.putChar(val, i, value[off]);
            ++off;
        }
        return val;
    }

    private static void getChars(byte[] value, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int pos = dstBegin;
        if (srcBegin < srcEnd) {
            StringUtil.checkBoundsOffCount(srcBegin, srcEnd - srcBegin, value);
        }
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[pos++] = StringUtil.getChar(value, i);
        }
    }

    private static void checkBoundsOffCount(int offset, int count, byte[] val) {
        StringUtil.checkBoundsOffCount(offset, count, StringUtil.length(val));
    }

    private static void checkBoundsOffCount(int offset, int count, int length) {
        if (offset < 0 || count < 0 || offset > length - count) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", count " + count + ", length " + length);
        }
    }

    private static char getChar(byte[] val, int index) {
        int pos = index;
        if (!($assertionsDisabled || pos >= 0 && pos < StringUtil.length(val))) {
            throw new AssertionError((Object)"Trusted caller missed bounds check");
        }
        pos <<= 1;
        return (char)((val[pos++] & 0xFF) << HI_BYTE_SHIFT | (val[pos] & 0xFF) << LO_BYTE_SHIFT);
    }

    private static byte[] newBytesFor(int len) {
        if (len < 0) {
            throw new NegativeArraySizeException();
        }
        if (len > 0x3FFFFFFF) {
            throw new OutOfMemoryError("UTF16 String size is " + len + ", should be less than 1073741823");
        }
        return new byte[len << 1];
    }

    private static void putChar(byte[] val, int index, int c) {
        int pos = index;
        if (!($assertionsDisabled || pos >= 0 && pos < StringUtil.length(val))) {
            throw new AssertionError((Object)"Trusted caller missed bounds check");
        }
        pos <<= 1;
        val[pos++] = (byte)(c >> HI_BYTE_SHIFT);
        val[pos] = (byte)(c >> LO_BYTE_SHIFT);
    }

    private static int length(byte[] value) {
        return value.length >> 1;
    }

    private static boolean isBigEndian() {
        return Target_sun_misc_Unsafe.isBigEndian0(StaticObject.NULL);
    }

    static {
        boolean bl = $assertionsDisabled = !StringUtil.class.desiredAssertionStatus();
        if (StringUtil.isBigEndian()) {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        } else {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        }
    }
}

