/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.meta;

import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.EspressoOptions;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import sun.misc.Unsafe;

public abstract class StringConversion {
    private static final Unsafe UNSAFE = UnsafeAccess.get();

    public abstract String toHost(StaticObject var1, EspressoLanguage var2, Meta var3);

    public abstract StaticObject toGuest(String var1, Meta var2);

    private StringConversion() {
    }

    static StringConversion select(EspressoContext context) {
        if (context.getJavaVersion().compactStringsEnabled()) {
            if (((Boolean)context.getEnv().getOptions().get(EspressoOptions.StringSharing)).booleanValue()) {
                return CompactToCompact.INSTANCE;
            }
            return CopyingCompactToCompact.INSTANCE;
        }
        return CharGuestCompactHost.INSTANCE;
    }

    private static String allocateHost() {
        try {
            return (String)UNSAFE.allocateInstance(String.class);
        }
        catch (Throwable e) {
            throw EspressoError.shouldNotReachHere();
        }
    }

    private static char[] extractGuestChars8(EspressoLanguage language, Meta meta, StaticObject str) {
        return (char[])meta.java_lang_String_value.getObject(str).unwrap(language);
    }

    private static byte[] extractGuestBytes11(EspressoLanguage language, Meta meta, StaticObject str) {
        return (byte[])meta.java_lang_String_value.getObject(str).unwrap(language);
    }

    private static int extractGuestHash(Meta meta, StaticObject str) {
        return meta.java_lang_String_hash.getInt(str);
    }

    private static byte extractGuestCoder(Meta meta, StaticObject str) {
        return meta.java_lang_String_coder.getByte(str);
    }

    private static byte[] extractHostBytes(String str) {
        return (byte[])UNSAFE.getObject(str, Offsets.hostValueOffset);
    }

    private static int extractHostHash(String str) {
        return UNSAFE.getInt(str, Offsets.hostHashOffset);
    }

    private static byte extractHostCoder(String str) {
        return UNSAFE.getByte(str, Offsets.hostCoderOffset);
    }

    private static StaticObject produceGuestString8(Meta meta, char[] value, int hash) {
        StaticObject guestString = meta.java_lang_String.allocateInstance(meta.getContext());
        meta.java_lang_String_hash.set(guestString, hash);
        meta.java_lang_String_value.setObject(guestString, StaticObject.wrap(value, meta), true);
        return guestString;
    }

    private static StaticObject produceGuestString11(Meta meta, byte[] value, int hash, byte coder) {
        StaticObject guestString = meta.java_lang_String.allocateInstance(meta.getContext());
        meta.java_lang_String_coder.set(guestString, coder);
        meta.java_lang_String_hash.set(guestString, hash);
        meta.java_lang_String_value.setObject(guestString, StaticObject.wrap(value, meta), true);
        return guestString;
    }

    private static String produceHostString(byte[] value, int hash, byte coder) {
        String res = StringConversion.allocateHost();
        UNSAFE.putInt(res, Offsets.hostHashOffset, hash);
        UNSAFE.putByte(res, Offsets.hostCoderOffset, coder);
        UNSAFE.putObjectVolatile(res, Offsets.hostValueOffset, value);
        return res;
    }

    private static final class CompactToCompact
    extends StringConversion {
        private static final StringConversion INSTANCE = new CompactToCompact();

        private CompactToCompact() {
        }

        @Override
        public String toHost(StaticObject str, EspressoLanguage language, Meta meta) {
            return StringConversion.produceHostString(StringConversion.extractGuestBytes11(language, meta, str), StringConversion.extractGuestHash(meta, str), StringConversion.extractGuestCoder(meta, str));
        }

        @Override
        public StaticObject toGuest(String str, Meta meta) {
            return StringConversion.produceGuestString11(meta, StringConversion.extractHostBytes(str), StringConversion.extractHostHash(str), StringConversion.extractHostCoder(str));
        }
    }

    private static final class CopyingCompactToCompact
    extends StringConversion {
        private static final StringConversion INSTANCE = new CopyingCompactToCompact();

        private CopyingCompactToCompact() {
        }

        @Override
        public String toHost(StaticObject str, EspressoLanguage language, Meta meta) {
            return StringConversion.produceHostString((byte[])StringConversion.extractGuestBytes11(language, meta, str).clone(), StringConversion.extractGuestHash(meta, str), StringConversion.extractGuestCoder(meta, str));
        }

        @Override
        public StaticObject toGuest(String str, Meta meta) {
            return StringConversion.produceGuestString11(meta, (byte[])StringConversion.extractHostBytes(str).clone(), StringConversion.extractHostHash(str), StringConversion.extractHostCoder(str));
        }
    }

    private static final class CharGuestCompactHost
    extends StringConversion {
        private static final StringConversion INSTANCE = new CharGuestCompactHost();

        private CharGuestCompactHost() {
        }

        @Override
        public String toHost(StaticObject str, EspressoLanguage language, Meta meta) {
            return new String(StringConversion.extractGuestChars8(language, meta, str));
        }

        @Override
        public StaticObject toGuest(String str, Meta meta) {
            return StringConversion.produceGuestString8(meta, str.toCharArray(), StringConversion.extractHostHash(str));
        }
    }

    private static final class Offsets {
        static final long hostValueOffset;
        static final long hostHashOffset;
        static final long hostCoderOffset;

        private Offsets() {
        }

        private static long getStringFieldOffset(String name) throws NoSuchFieldException {
            return UNSAFE.objectFieldOffset(String.class.getDeclaredField(name));
        }

        static {
            try {
                hostValueOffset = Offsets.getStringFieldOffset("value");
                hostHashOffset = Offsets.getStringFieldOffset("hash");
                hostCoderOffset = Offsets.getStringFieldOffset("coder");
            }
            catch (NoSuchFieldException e) {
                throw EspressoError.shouldNotReachHere(e);
            }
        }
    }
}

