/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ThreadSuspension {
    private Object[] threads = new Object[0];
    private int[] suspensionCount = new int[0];
    private final Set<Object> hardSuspendedThreads = new HashSet<Object>();

    public synchronized void suspendThread(Object thread) {
        for (int i = 0; i < this.threads.length; ++i) {
            if (thread != this.threads[i]) continue;
            int n = i;
            this.suspensionCount[n] = this.suspensionCount[n] + 1;
            return;
        }
        this.expandCapacity(thread);
    }

    @CompilerDirectives.TruffleBoundary
    private void expandCapacity(Object thread) {
        Object[] expanded = Arrays.copyOf(this.threads, this.threads.length + 1);
        expanded[this.threads.length] = thread;
        int[] temp = Arrays.copyOf(this.suspensionCount, this.threads.length + 1);
        temp[this.threads.length] = 1;
        this.threads = expanded;
        this.suspensionCount = temp;
    }

    public synchronized void resumeThread(Object thread) {
        this.removeHardSuspendedThread(thread);
        for (int i = 0; i < this.threads.length; ++i) {
            if (thread != this.threads[i] || this.suspensionCount[i] <= 0) continue;
            int n = i;
            this.suspensionCount[n] = this.suspensionCount[n] - 1;
            return;
        }
    }

    public synchronized int getSuspensionCount(Object thread) {
        if (this.hardSuspendedThreads.contains(thread)) {
            for (int i = 0; i < this.threads.length; ++i) {
                if (thread != this.threads[i]) continue;
                int count = this.suspensionCount[i];
                return count + 1;
            }
            return 1;
        }
        for (int i = 0; i < this.threads.length; ++i) {
            if (thread != this.threads[i]) continue;
            return this.suspensionCount[i];
        }
        return 0;
    }

    public synchronized void addHardSuspendedThread(Object thread) {
        this.suspendThread(thread);
        this.resumeThread(thread);
        this.hardSuspendedThreads.add(thread);
    }

    public synchronized void removeHardSuspendedThread(Object thread) {
        this.hardSuspendedThreads.remove(thread);
    }

    public synchronized boolean isHardSuspended(Object thread) {
        return this.hardSuspendedThreads.contains(thread);
    }
}

