/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.jdwp.api.JDWPContext;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerConnection;
import com.oracle.truffle.espresso.jdwp.impl.DebuggerController;
import com.oracle.truffle.espresso.jdwp.impl.HandshakeController;
import com.oracle.truffle.espresso.jdwp.impl.SocketConnection;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;

@TruffleInstrument.Registration(id="jdwp", name="Java debug wire protocol", services={DebuggerController.class})
public final class JDWPInstrument
extends TruffleInstrument
implements Runnable {
    public static final String ID = "jdwp";
    private DebuggerController controller;
    private TruffleInstrument.Env env;
    private JDWPContext context;
    private DebuggerConnection connection;
    private Collection<Thread> activeThreads = new ArrayList<Thread>();
    private PrintStream err;
    private volatile HandshakeController hsController = null;
    private final Semaphore resetting = new Semaphore(1);

    protected void onCreate(TruffleInstrument.Env instrumentEnv) {
        assert (this.controller == null);
        this.controller = new DebuggerController(this, instrumentEnv.getLogger(ID));
        this.env = instrumentEnv;
        this.env.registerService((Object)this.controller);
        this.env.getInstrumenter().attachContextsListener((ContextsListener)this.controller, false);
        this.err = new PrintStream(this.env.err());
    }

    public void reset(boolean prepareForReconnect) {
        if (!this.resetting.tryAcquire()) {
            return;
        }
        for (Thread activeThread : this.activeThreads) {
            activeThread.interrupt();
        }
        HandshakeController hsc = this.hsController;
        if (hsc != null) {
            hsc.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        boolean stillRunning = true;
        while (stillRunning) {
            stillRunning = false;
            for (Thread activeThread : this.activeThreads) {
                if (!activeThread.isAlive()) continue;
                stillRunning = true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.controller.getGCPrevention().clearAll();
        this.controller.endSession();
        this.controller.resumeAll(true);
        if (prepareForReconnect) {
            this.controller.reInitialize();
            this.resetting.release();
        }
    }

    public boolean isResetting() {
        return this.resetting.availablePermits() == 0;
    }

    public void printStackTrace(Throwable e) {
        e.printStackTrace(this.err);
    }

    public void printError(String message) {
        this.err.println(message);
    }

    @CompilerDirectives.TruffleBoundary
    public void init(JDWPContext jdwpContext) {
        this.context = jdwpContext;
        try {
            if (this.controller.isSuspend()) {
                try {
                    this.doConnect(true, this.controller.isServer());
                }
                catch (ConnectException ex) {
                    this.handleConnectException(ex, false);
                }
            } else {
                Thread handshakeThread = new Thread((Runnable)this, "jdwp-handshake-thread");
                handshakeThread.setDaemon(true);
                handshakeThread.start();
            }
        }
        catch (IOException e) {
            this.printError("Critical failure in establishing jdwp connection: " + e.getLocalizedMessage());
            this.printStackTrace(e);
        }
    }

    private void handleConnectException(ConnectException ex, boolean swallowExitException) {
        block6: {
            System.err.println("ERROR: transport error 202: connect failed: " + ex.getMessage());
            System.err.println("ERROR: JDWP Transport dt_socket failed to initialize, TRANSPORT_INIT(510)");
            System.err.println("JDWP exit error AGENT_ERROR_TRANSPORT_INIT(197): No transports initialized");
            try {
                this.context.abort(197);
            }
            catch (Throwable t) {
                if (swallowExitException) {
                    if (!(t instanceof AbstractTruffleException)) break block6;
                    try {
                        if (InteropLibrary.getUncached().getExceptionType((Object)t) != ExceptionType.EXIT) {
                            throw t;
                        }
                    }
                    catch (UnsupportedMessageException e) {
                        throw t;
                    }
                }
                throw t;
            }
        }
    }

    void doConnect(final boolean suspend, boolean server) throws IOException {
        this.hsController = new HandshakeController();
        SocketConnection socketConnection = this.hsController.createSocketConnection(server, this.controller.getHost(), this.controller.getListeningPort(), this.activeThreads);
        this.hsController.close();
        this.hsController = null;
        this.connection = new DebuggerConnection(socketConnection, this.controller);
        this.controller.getEventListener().setConnection(socketConnection);
        Callable<Void> vmStartedJob = new Callable<Void>(this){
            final /* synthetic */ JDWPInstrument this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void call() {
                this.this$0.controller.getEventListener().vmStarted(suspend);
                return null;
            }
        };
        this.connection.doProcessCommands(suspend, this.activeThreads, vmStartedJob);
    }

    @Override
    public void run() {
        block3: {
            try {
                this.doConnect(false, this.controller.isServer());
            }
            catch (ConnectException ex) {
                this.handleConnectException(ex, true);
            }
            catch (IOException e) {
                if (this.isResetting()) break block3;
                this.printError("Critical failure in establishing jdwp connection: " + e.getLocalizedMessage());
                this.printStackTrace(e);
            }
        }
    }

    public JDWPContext getContext() {
        return this.context;
    }

    boolean isVMThread(Thread thread) {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isDebuggerThread(thread);
    }

    boolean hasConnection() {
        return this.connection != null;
    }
}

