/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.jdwp.impl;

import com.oracle.truffle.espresso.jdwp.impl.RequestFilter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class EventFilters {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private RequestFilter[] requestFilters = new RequestFilter[0];

    public void addFilter(RequestFilter filter) {
        try {
            this.lock.writeLock().lock();
            RequestFilter[] temp = new RequestFilter[this.requestFilters.length + 1];
            System.arraycopy(this.requestFilters, 0, temp, 0, this.requestFilters.length);
            temp[this.requestFilters.length] = filter;
            this.requestFilters = temp;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFilter getRequestFilter(int requestId) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            for (int i = this.requestFilters.length - 1; i > -1; --i) {
                RequestFilter filter = this.requestFilters[i];
                if (filter == null || filter.getRequestId() != requestId) continue;
                RequestFilter requestFilter = filter;
                return requestFilter;
            }
            RequestFilter requestFilter = null;
            return requestFilter;
        }
        finally {
            readLock.unlock();
        }
    }
}

