/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.EntryTable;
import com.oracle.truffle.espresso.impl.ModuleTable;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;

public class PackageTable
extends EntryTable<PackageEntry, ModuleTable.ModuleEntry> {
    public PackageTable(ReadWriteLock lock) {
        super(lock);
    }

    @Override
    protected PackageEntry createEntry(Symbol<Symbol.Name> name, ModuleTable.ModuleEntry appendix) {
        return new PackageEntry(name, appendix);
    }

    public static class PackageEntry
    extends EntryTable.NamedEntry {
        private final ModuleTable.ModuleEntry module;
        private ArrayList<ModuleTable.ModuleEntry> exports = null;
        private boolean isUnqualifiedExported = false;
        private boolean isExportedAllUnnamed = false;

        @Override
        public Symbol<Symbol.Name> getName() {
            return this.name;
        }

        public PackageEntry(Symbol<Symbol.Name> name, ModuleTable.ModuleEntry module) {
            super(name);
            this.module = module;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addExports(ModuleTable.ModuleEntry m) {
            if (this.isUnqualifiedExported()) {
                return;
            }
            PackageEntry packageEntry = this;
            synchronized (packageEntry) {
                if (m == null) {
                    this.setUnqualifiedExports();
                }
                if (this.exports == null) {
                    this.exports = new ArrayList();
                }
                if (!this.contains(m)) {
                    this.exports.add(m);
                }
            }
        }

        public boolean isQualifiedExportTo(ModuleTable.ModuleEntry m) {
            if (this.isExportedAllUnnamed() && !m.isNamed()) {
                return true;
            }
            if (this.isUnqualifiedExported() || this.exports == null) {
                return false;
            }
            return this.contains(m);
        }

        public boolean isUnqualifiedExported() {
            return this.module().isOpen() || this.isUnqualifiedExported;
        }

        public void setUnqualifiedExports() {
            if (this.isUnqualifiedExported()) {
                return;
            }
            this.isUnqualifiedExported = true;
            this.isExportedAllUnnamed = true;
            this.exports = null;
        }

        public boolean isExportedAllUnnamed() {
            return this.module().isOpen() || this.isExportedAllUnnamed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setExportedAllUnnamed() {
            if (this.isExportedAllUnnamed()) {
                return;
            }
            PackageEntry packageEntry = this;
            synchronized (packageEntry) {
                this.isExportedAllUnnamed = true;
            }
        }

        public boolean contains(ModuleTable.ModuleEntry m) {
            return this.exports.contains(m);
        }

        public ModuleTable.ModuleEntry module() {
            return this.module;
        }
    }
}

