/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyAssumption;
import com.oracle.truffle.espresso.analysis.hierarchy.ClassHierarchyOracle;
import com.oracle.truffle.espresso.analysis.hierarchy.SingleImplementor;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.attributes.ConstantValueAttribute;
import com.oracle.truffle.espresso.classfile.attributes.EnclosingMethodAttribute;
import com.oracle.truffle.espresso.classfile.attributes.InnerClassesAttribute;
import com.oracle.truffle.espresso.classfile.attributes.NestHostAttribute;
import com.oracle.truffle.espresso.classfile.attributes.NestMembersAttribute;
import com.oracle.truffle.espresso.classfile.attributes.PermittedSubclassesAttribute;
import com.oracle.truffle.espresso.classfile.attributes.RecordAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SignatureAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SourceDebugExtensionAttribute;
import com.oracle.truffle.espresso.classfile.attributes.SourceFileAttribute;
import com.oracle.truffle.espresso.descriptors.Names;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EnumConstantField;
import com.oracle.truffle.espresso.impl.ExtensionFieldsMetadata;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.HierarchyInfo;
import com.oracle.truffle.espresso.impl.InterfaceTables;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.LinkedField;
import com.oracle.truffle.espresso.impl.LinkedKlass;
import com.oracle.truffle.espresso.impl.LinkedKlassFieldLayout;
import com.oracle.truffle.espresso.impl.LinkedMethod;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ModuleTable;
import com.oracle.truffle.espresso.impl.PackageTable;
import com.oracle.truffle.espresso.impl.ParserField;
import com.oracle.truffle.espresso.impl.ParserKlass;
import com.oracle.truffle.espresso.impl.ParserMethod;
import com.oracle.truffle.espresso.impl.RedefineAddedField;
import com.oracle.truffle.espresso.impl.VirtualTable;
import com.oracle.truffle.espresso.jdwp.api.Ids;
import com.oracle.truffle.espresso.jdwp.api.MethodRef;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.ModifiersProvider;
import com.oracle.truffle.espresso.redefinition.ChangePacket;
import com.oracle.truffle.espresso.redefinition.ClassRedefinition;
import com.oracle.truffle.espresso.redefinition.DetectedChange;
import com.oracle.truffle.espresso.runtime.Attribute;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.verifier.MethodVerifier;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;

public final class ObjectKlass
extends Klass {
    public static final ObjectKlass[] EMPTY_ARRAY = new ObjectKlass[0];
    public static final KlassVersion[] EMPTY_KLASSVERSION_ARRAY = new KlassVersion[0];
    private final EnclosingMethodAttribute enclosingMethod;
    @CompilerDirectives.CompilationFinal
    private StaticObject statics;
    private final Klass hostKlass;
    @CompilerDirectives.CompilationFinal
    private Klass nest;
    @CompilerDirectives.CompilationFinal
    private PackageTable.PackageEntry packageEntry;
    private String genericSignature;
    @CompilerDirectives.CompilationFinal
    private volatile EspressoLock initLock;
    @CompilerDirectives.CompilationFinal
    private volatile int initState = 0;
    @CompilerDirectives.CompilationFinal
    volatile KlassVersion klassVersion;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Field[] fieldTable;
    private final int localFieldTableIndex;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Field[] staticFieldTable;
    @CompilerDirectives.CompilationFinal
    private ExtensionFieldsMetadata extensionFieldsMetadata;
    private volatile ArrayList<WeakReference<ObjectKlass>> subTypes;
    private Source source;
    public static final int LOADED = 0;
    public static final int LINKING = 1;
    public static final int PREPARED = 2;
    public static final int LINKED = 3;
    public static final int ERRONEOUS = 4;
    public static final int INITIALIZING = 5;
    public static final int INITIALIZED = 6;
    private final StaticObject definingClassLoader;
    private final SingleImplementor implementor;
    private final ClassHierarchyAssumption noConcreteSubclassesAssumption;
    @CompilerDirectives.CompilationFinal
    private volatile int verificationStatus = 0;
    @CompilerDirectives.CompilationFinal
    private EspressoException verificationError = null;
    private static final int FAILED_VERIFICATION = -1;
    private static final int UNVERIFIED = 0;
    private static final int VERIFYING = 1;
    private static final int VERIFIED = 2;

    public Attribute getAttribute(Symbol<Symbol.Name> attrName) {
        return this.getLinkedKlass().getAttribute(attrName);
    }

    public ObjectKlass(EspressoContext context, LinkedKlass linkedKlass, ObjectKlass superKlass, ObjectKlass[] superInterfaces, StaticObject classLoader, ClassRegistry.ClassDefinitionInfo info) {
        super(context, linkedKlass.getName(), linkedKlass.getType(), linkedKlass.getFlags(), info.klassID);
        int i;
        this.nest = info.dynamicNest;
        this.hostKlass = info.hostKlass;
        RuntimeConstantPool pool = new RuntimeConstantPool(this.getContext(), linkedKlass.getConstantPool(), classLoader);
        this.definingClassLoader = classLoader;
        this.enclosingMethod = (EnclosingMethodAttribute)linkedKlass.getAttribute(EnclosingMethodAttribute.NAME);
        this.klassVersion = new KlassVersion(pool, linkedKlass, superKlass, superInterfaces);
        Field[] skFieldTable = superKlass != null ? superKlass.getInitialFieldTable() : new Field[]{};
        LinkedField[] lkInstanceFields = linkedKlass.getInstanceFields();
        LinkedField[] lkStaticFields = linkedKlass.getStaticFields();
        this.fieldTable = new Field[skFieldTable.length + lkInstanceFields.length];
        this.staticFieldTable = new Field[lkStaticFields.length];
        assert (this.fieldTable.length == linkedKlass.getFieldTableLength());
        System.arraycopy(skFieldTable, 0, this.fieldTable, 0, skFieldTable.length);
        this.localFieldTableIndex = skFieldTable.length;
        for (i = 0; i < lkInstanceFields.length; ++i) {
            Field instanceField;
            this.fieldTable[this.localFieldTableIndex + i] = instanceField = new Field(this.klassVersion, lkInstanceFields[i], pool);
        }
        for (i = 0; i < lkStaticFields.length; ++i) {
            LinkedField lkField = lkStaticFields[i];
            Field staticField = superKlass == this.getMeta().java_lang_Enum && !ObjectKlass.isEnumValuesField(lkField) && Types.isReference(lkField.getType()) && Modifier.isFinal(lkField.getFlags()) ? new EnumConstantField(this.klassVersion, lkField, pool) : new Field(this.klassVersion, lkField, pool);
            this.staticFieldTable[i] = staticField;
        }
        if (info.protectionDomain != null && !StaticObject.isNull(info.protectionDomain)) {
            this.getMeta().HIDDEN_PROTECTION_DOMAIN.setHiddenObject(this.initializeEspressoClass(), info.protectionDomain);
        }
        if (info.classData != null) {
            this.getMeta().java_lang_Class_classData.setObject(this.initializeEspressoClass(), info.classData);
        }
        if (!info.addedToRegistry()) {
            this.initSelfReferenceInPool();
        }
        this.noConcreteSubclassesAssumption = this.getContext().getClassHierarchyOracle().createAssumptionForNewKlass(this);
        this.implementor = this.getContext().getClassHierarchyOracle().initializeImplementorForNewKlass(this);
        this.getContext().getClassHierarchyOracle().registerNewKlassVersion(this.klassVersion);
        this.initState = 0;
        if (this.getMeta().java_lang_Class != null) {
            this.initializeEspressoClass();
        }
        assert (this.verifyTables());
    }

    private static boolean isEnumValuesField(LinkedField lkStaticFields) {
        return lkStaticFields.getName() == Symbol.Name.$VALUES || lkStaticFields.getName() == Symbol.Name.ENUM$VALUES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubType(ObjectKlass objectKlass) {
        if (this.getContext().getEspressoEnv().JDWPOptions != null) {
            Object object;
            if (this == this.getMeta().java_lang_Object) {
                return;
            }
            if (this.subTypes == null) {
                object = this;
                synchronized (object) {
                    if (this.subTypes == null) {
                        this.subTypes = new ArrayList(1);
                    }
                }
            }
            object = this.subTypes;
            synchronized (object) {
                this.subTypes.add(new WeakReference<ObjectKlass>(objectKlass));
            }
        }
    }

    public void removeAsSubType() {
        if (this.getSuperKlass() != this.getMeta().java_lang_Object) {
            this.getSuperKlass().removeSubType(this);
        }
        for (ObjectKlass superInterface : this.getSuperInterfaces()) {
            superInterface.removeSubType(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubType(ObjectKlass klass) {
        assert (this.subTypes != null);
        ArrayList<WeakReference<ObjectKlass>> arrayList = this.subTypes;
        synchronized (arrayList) {
            boolean removed = false;
            Iterator<WeakReference<ObjectKlass>> it = this.subTypes.iterator();
            while (it.hasNext()) {
                WeakReference<ObjectKlass> next = it.next();
                if (next.get() != klass) continue;
                it.remove();
                removed = true;
                break;
            }
            if (!removed) {
                throw EspressoError.shouldNotReachHere();
            }
        }
    }

    private boolean verifyTables() {
        Method.MethodVersion[][] itable;
        Method.MethodVersion[] vtable = this.getKlassVersion().getVtable();
        if (vtable != null) {
            for (int i = 0; i < vtable.length; ++i) {
                if (!(this.isInterface() ? vtable[i].getITableIndex() != i : vtable[i].getVTableIndex() != i)) continue;
                return false;
            }
        }
        if ((itable = this.getItable()) != null) {
            for (Method.MethodVersion[] table : itable) {
                for (int i = 0; i < table.length; ++i) {
                    if (table[i].getITableIndex() == i) continue;
                    return false;
                }
            }
        }
        return true;
    }

    StaticObject getStaticsImpl() {
        StaticObject result = this.statics;
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            result = this.createStatics();
        }
        return result;
    }

    private synchronized StaticObject createStatics() {
        CompilerAsserts.neverPartOfCompilation();
        StaticObject result = this.statics;
        if (result == null) {
            this.statics = result = this.getAllocator().createStatics(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EspressoLock getInitLock() {
        EspressoLock iLock = this.initLock;
        if (iLock == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ObjectKlass objectKlass = this;
            synchronized (objectKlass) {
                iLock = this.initLock;
                if (iLock == null) {
                    iLock = this.initLock = EspressoLock.create(this.getContext().getBlockingSupport());
                }
            }
        }
        return iLock;
    }

    public int getState() {
        return this.initState;
    }

    private boolean isLinkingOrLinked() {
        return this.initState >= 1;
    }

    boolean isPrepared() {
        return this.initState >= 2;
    }

    private boolean isLinked() {
        return this.initState >= 3;
    }

    boolean isInitializingOrInitializedImpl() {
        return this.initState >= 4;
    }

    boolean isInitializedImpl() {
        return this.initState >= 6;
    }

    private void setErroneousInitialization() {
        this.initState = 4;
    }

    boolean isErroneous() {
        return this.initState == 4;
    }

    private void checkErroneousInitialization() {
        if (this.isErroneous()) {
            throw this.throwNoClassDefFoundError();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private EspressoException throwNoClassDefFoundError() {
        Meta meta = this.getMeta();
        throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, "Erroneous class: " + String.valueOf(this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void actualInit() {
        this.checkErroneousInitialization();
        this.getInitLock().lock();
        try {
            this.checkErroneousInitialization();
            if (this.isInitializingOrInitializedImpl()) {
                return;
            }
            this.initState = 5;
            this.getContext().getLogger().log(Level.FINEST, "Initializing: {0}", (Object)this.getNameAsString());
            try {
                Method clinit;
                if (!this.isInterface()) {
                    if (this.getSuperKlass() != null) {
                        this.getSuperKlass().initialize();
                    }
                    for (ObjectKlass interf : this.getSuperInterfaces()) {
                        if (!interf.hasDefaultMethods()) continue;
                        interf.recursiveInitialize();
                    }
                }
                if ((clinit = this.getClassInitializer()) != null) {
                    clinit.getCallTarget().call(new Object[0]);
                }
            }
            catch (EspressoException e) {
                this.setErroneousInitialization();
                StaticObject cause = e.getGuestException();
                Meta meta = this.getMeta();
                if (!InterpreterToVM.instanceOf(cause, meta.java_lang_Error)) {
                    throw meta.throwExceptionWithCause(meta.java_lang_ExceptionInInitializerError, cause);
                }
                throw e;
            }
            catch (AbstractTruffleException e) {
                this.setErroneousInitialization();
                throw e;
            }
            catch (Throwable e) {
                this.getContext().getLogger().log(Level.WARNING, "Host exception during class initialization: {0}", (Object)this.getNameAsString());
                e.printStackTrace();
                this.setErroneousInitialization();
                throw e;
            }
            this.checkErroneousInitialization();
            this.initState = 6;
            assert (this.isInitialized());
        }
        finally {
            this.getInitLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() {
        this.getInitLock().lock();
        try {
            if (!this.isPrepared()) {
                this.checkLoadingConstraints();
                for (Field f : this.getInitialStaticFields()) {
                    if (f.isRemoved()) continue;
                    this.initField(f);
                }
                this.initState = 2;
                if (this.getContext().isMainThreadCreated() && this.getContext().shouldReportVMEvents()) {
                    this.prepareThread = this.getContext().getCurrentPlatformThread();
                    this.getContext().reportClassPrepared(this, this.prepareThread);
                }
            }
        }
        finally {
            this.getInitLock().unlock();
        }
    }

    void initField(Field f) {
        ConstantValueAttribute a = (ConstantValueAttribute)f.getAttribute(Symbol.Name.ConstantValue);
        if (a == null) {
            return;
        }
        switch (f.getKind()) {
            case Boolean: {
                boolean c = this.getConstantPool().intAt(a.getConstantValueIndex()) != 0;
                f.set(this.getStatics(), c);
                break;
            }
            case Byte: {
                byte c = (byte)this.getConstantPool().intAt(a.getConstantValueIndex());
                f.set(this.getStatics(), c);
                break;
            }
            case Short: {
                short c = (short)this.getConstantPool().intAt(a.getConstantValueIndex());
                f.set(this.getStatics(), c);
                break;
            }
            case Char: {
                char c = (char)this.getConstantPool().intAt(a.getConstantValueIndex());
                f.set(this.getStatics(), Character.valueOf(c));
                break;
            }
            case Int: {
                int c = this.getConstantPool().intAt(a.getConstantValueIndex());
                f.set(this.getStatics(), c);
                break;
            }
            case Float: {
                float c = this.getConstantPool().floatAt(a.getConstantValueIndex());
                f.set(this.getStatics(), Float.valueOf(c));
                break;
            }
            case Long: {
                long c = this.getConstantPool().longAt(a.getConstantValueIndex());
                f.set(this.getStatics(), c);
                break;
            }
            case Double: {
                double c = this.getConstantPool().doubleAt(a.getConstantValueIndex());
                f.set(this.getStatics(), c);
                break;
            }
            case Object: {
                StaticObject c = this.getConstantPool().resolvedStringAt(a.getConstantValueIndex());
                f.set(this.getStatics(), c);
                break;
            }
            default: {
                CompilerAsserts.neverPartOfCompilation();
                throw EspressoError.shouldNotReachHere("invalid constant field kind");
            }
        }
    }

    private void checkLoadingConstraints() {
        if (this.getSuperKlass() != null) {
            Method.MethodVersion[] thisVTable;
            if (!this.isInterface() && (thisVTable = this.getVTable()) != null) {
                Method.MethodVersion[] superVTable = this.getSuperKlass().getVTable();
                for (int i = 0; i < superVTable.length; ++i) {
                    ObjectKlass k1 = thisVTable[i].getDeclaringKlass();
                    ObjectKlass k2 = superVTable[i].getDeclaringKlass();
                    if (k1 != this) continue;
                    thisVTable[i].checkLoadingConstraints(((Klass)k1).getDefiningClassLoader(), ((Klass)k2).getDefiningClassLoader());
                }
            }
            if (this.getItable() != null) {
                Method.MethodVersion[][] itables = this.getItable();
                KlassVersion[] klassTable = this.getiKlassTable();
                for (int i = 0; i < itables.length; ++i) {
                    Method.MethodVersion[] table;
                    KlassVersion interfKlass = klassTable[i];
                    for (Method.MethodVersion m : table = itables[i]) {
                        if (m.getDeclaringKlass() == this) {
                            m.checkLoadingConstraints(this.getDefiningClassLoader(), interfKlass.getKlass().getDefiningClassLoader());
                            continue;
                        }
                        m.checkLoadingConstraints(interfKlass.getKlass().getDefiningClassLoader(), m.getDeclaringKlass().getDefiningClassLoader());
                        m.checkLoadingConstraints(this.getDefiningClassLoader(), m.getDeclaringKlass().getDefiningClassLoader());
                    }
                }
            }
        }
    }

    @Override
    public void ensureLinked() {
        if (!this.isLinked()) {
            this.checkErroneousVerification();
            if (CompilerDirectives.isCompilationConstant((Object)this)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            this.doLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private void doLink() {
        this.getInitLock().lock();
        try {
            if (!this.isLinkingOrLinked()) {
                this.initState = 1;
                if (this.getSuperKlass() != null) {
                    this.getSuperKlass().ensureLinked();
                }
                for (ObjectKlass interf : this.getSuperInterfaces()) {
                    interf.ensureLinked();
                }
                this.prepare();
                this.verify();
                this.initState = 3;
            }
        }
        finally {
            this.getInitLock().unlock();
        }
        this.checkErroneousVerification();
    }

    void initializeImpl() {
        if (!this.isInitializedImpl()) {
            this.doInitialize();
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void doInitialize() {
        this.checkErroneousVerification();
        this.checkErroneousInitialization();
        if (CompilerDirectives.isCompilationConstant((Object)this)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        this.ensureLinked();
        this.actualInit();
    }

    private void recursiveInitialize() {
        for (ObjectKlass interf : this.getSuperInterfaces()) {
            if (!interf.hasDefaultMethods()) continue;
            interf.recursiveInitialize();
        }
        if (this.hasDeclaredDefaultMethods()) {
            this.initializeImpl();
        }
    }

    private void setVerificationStatus(int status) {
        this.verificationStatus = status;
    }

    private boolean isVerifyingOrVerified() {
        return this.verificationStatus >= 1;
    }

    boolean isVerified() {
        return this.verificationStatus >= 2;
    }

    private void checkErroneousVerification() {
        if (this.verificationStatus == -1) {
            throw this.verificationError;
        }
    }

    private void setErroneousVerification(EspressoException e) {
        this.verificationStatus = -1;
        this.verificationError = e;
    }

    private void verify() {
        if (!this.isVerified()) {
            block6: {
                this.checkErroneousVerification();
                this.getInitLock().lock();
                try {
                    if (this.isVerifyingOrVerified()) break block6;
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setVerificationStatus(1);
                    try {
                        this.verifyImpl();
                    }
                    catch (EspressoException e) {
                        this.setErroneousVerification(e);
                        throw e;
                    }
                    this.setVerificationStatus(2);
                }
                finally {
                    this.getInitLock().unlock();
                }
            }
            this.checkErroneousVerification();
        }
    }

    private void verifyImpl() {
        CompilerAsserts.neverPartOfCompilation();
        if (MethodVerifier.needsVerify(this.getLanguage(), this.getDefiningClassLoader())) {
            Meta meta = this.getMeta();
            if (this.getSuperKlass() != null && this.getSuperKlass().isFinalFlagSet()) {
                throw meta.throwException(meta.java_lang_VerifyError);
            }
            if (this.getSuperKlass() != null) {
                this.getSuperKlass().verify();
            }
            for (ObjectKlass objectKlass : this.getSuperInterfaces()) {
                objectKlass.verify();
            }
            if (meta.sun_reflect_MagicAccessorImpl.isAssignableFrom(this)) {
                return;
            }
            for (ModifiersProvider modifiersProvider : this.getDeclaredMethods()) {
                try {
                    MethodVerifier.verify((Method)modifiersProvider);
                }
                catch (MethodVerifier.VerifierError e) {
                    String message = String.format("Verification for class `%s` failed for method `%s` with message `%s`", this.getExternalName(), ((Method)modifiersProvider).getNameAsString(), e.getMessage());
                    switch (e.kind()) {
                        case Verify: {
                            throw meta.throwExceptionWithMessage(meta.java_lang_VerifyError, message);
                        }
                        case ClassFormat: {
                            throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, message);
                        }
                        case NoClassDefFound: {
                            throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, message);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Klass getElementalType() {
        return this;
    }

    @Override
    public @JavaType(value=ClassLoader.class) StaticObject getDefiningClassLoader() {
        return this.definingClassLoader;
    }

    @Override
    public RuntimeConstantPool getConstantPool() {
        return this.getKlassVersion().pool;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    @Override
    public Klass getEnclosingType() {
        return null;
    }

    @Override
    public Method[] getDeclaredConstructors() {
        ArrayList<Method> constructors = new ArrayList<Method>();
        for (Method m : this.getDeclaredMethods()) {
            if (!Symbol.Name._init_.equals(m.getName())) continue;
            constructors.add(m);
        }
        return constructors.toArray(Method.EMPTY_ARRAY);
    }

    Method.MethodVersion[] getMirandaMethods() {
        return this.getKlassVersion().mirandaMethods;
    }

    @Override
    public Method[] getDeclaredMethods() {
        Method.MethodVersion[] declaredMethodVersions = this.getKlassVersion().declaredMethods;
        Method[] methods = new Method[declaredMethodVersions.length];
        for (int i = 0; i < declaredMethodVersions.length; ++i) {
            methods[i] = declaredMethodVersions[i].getMethod();
        }
        return methods;
    }

    @Override
    public MethodRef[] getDeclaredMethodRefs() {
        return this.getDeclaredMethodVersions();
    }

    @Override
    public Method.MethodVersion[] getDeclaredMethodVersions() {
        return this.getKlassVersion().getDeclaredMethodVersions();
    }

    @Override
    public Field[] getDeclaredFields() {
        Field f;
        int i;
        Field[] declaredFields = new Field[this.staticFieldTable.length + this.fieldTable.length - this.localFieldTableIndex];
        int insertionIndex = 0;
        for (i = 0; i < this.staticFieldTable.length; ++i) {
            f = this.staticFieldTable[i];
            if (f.isHidden() || f.isRemoved()) continue;
            declaredFields[insertionIndex++] = f;
        }
        for (i = this.localFieldTableIndex; i < this.fieldTable.length; ++i) {
            f = this.fieldTable[i];
            if (f.isHidden() || f.isRemoved()) continue;
            declaredFields[insertionIndex++] = f;
        }
        Field[] fieldArray = declaredFields = insertionIndex == declaredFields.length ? declaredFields : Arrays.copyOf(declaredFields, insertionIndex);
        if (this.getExtensionFieldsMetadata(false) != null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Field[] extensionFields = this.extensionFieldsMetadata.getDeclaredAddedFields();
            declaredFields = Arrays.copyOf(declaredFields, insertionIndex + extensionFields.length);
            System.arraycopy(extensionFields, 0, declaredFields, insertionIndex, extensionFields.length);
        }
        return declaredFields;
    }

    public EnclosingMethodAttribute getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public InnerClassesAttribute getInnerClasses() {
        return this.getKlassVersion().innerClasses;
    }

    public LinkedKlass getLinkedKlass() {
        return this.getKlassVersion().linkedKlass;
    }

    Klass getHostClassImpl() {
        return this.hostKlass;
    }

    @Override
    public Klass nest() {
        if (this.nest == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NestHostAttribute nestHost = (NestHostAttribute)this.getAttribute(NestHostAttribute.NAME);
            if (nestHost == null) {
                this.nest = this;
            } else {
                RuntimeConstantPool thisPool = this.getConstantPool();
                Klass host = thisPool.resolvedKlassAt(this, nestHost.hostClassIndex);
                if (!host.nestMembersCheck(this)) {
                    Meta meta = this.getMeta();
                    throw meta.throwException(meta.java_lang_IncompatibleClassChangeError);
                }
                this.nest = host;
            }
        }
        return this.nest;
    }

    @Override
    public boolean nestMembersCheck(Klass k) {
        NestMembersAttribute nestMembers = (NestMembersAttribute)this.getAttribute(NestMembersAttribute.NAME);
        if (nestMembers == null) {
            return false;
        }
        if (!this.sameRuntimePackage(k)) {
            return false;
        }
        RuntimeConstantPool pool = this.getConstantPool();
        for (int index : nestMembers.getClasses()) {
            if (!k.getName().equals(pool.classAt(index).getName(pool)) || k != pool.resolvedKlassAt(this, index)) continue;
            return true;
        }
        return false;
    }

    public boolean isSealed() {
        PermittedSubclassesAttribute permittedSubclasses = (PermittedSubclassesAttribute)this.getAttribute(PermittedSubclassesAttribute.NAME);
        return permittedSubclasses != null && permittedSubclasses.getClasses().length > 0;
    }

    public boolean permittedSubclassCheck(ObjectKlass subKlass) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.getContext().getJavaVersion().java17OrLater()) {
            return true;
        }
        PermittedSubclassesAttribute permittedSubclasses = (PermittedSubclassesAttribute)this.getAttribute(PermittedSubclassesAttribute.NAME);
        if (permittedSubclasses == null) {
            return true;
        }
        if (this.module() != subKlass.module()) {
            return false;
        }
        if (!subKlass.isPublic() && !this.sameRuntimePackage(subKlass)) {
            return false;
        }
        RuntimeConstantPool pool = this.getConstantPool();
        for (char index : permittedSubclasses.getClasses()) {
            if (!subKlass.getName().equals(pool.classAt(index).getName(pool))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Klass[] getNestMembers() {
        if (this != this.nest()) {
            return this.nest().getNestMembers();
        }
        NestMembersAttribute nestMembers = (NestMembersAttribute)this.getAttribute(NestMembersAttribute.NAME);
        if (nestMembers == null || nestMembers.getClasses().length == 0) {
            return new Klass[]{this.nest()};
        }
        RuntimeConstantPool pool = this.getConstantPool();
        ArrayList<Klass> klasses = new ArrayList<Klass>(1 + nestMembers.getClasses().length);
        klasses.add(this.nest());
        for (int i = 0; i < nestMembers.getClasses().length; ++i) {
            int index = nestMembers.getClasses()[i];
            try {
                klasses.add(pool.resolvedKlassAt(this, index));
                continue;
            }
            catch (EspressoException espressoException) {
                // empty catch block
            }
        }
        return klasses.toArray(Klass.EMPTY_ARRAY);
    }

    Field lookupFieldTableImpl(int slot) {
        if (slot >= 0) {
            assert (slot < this.fieldTable.length && !this.fieldTable[slot].isHidden());
            return this.fieldTable[slot];
        }
        for (ObjectKlass objectKlass = this; objectKlass != null; objectKlass = objectKlass.getSuperKlass()) {
            Field field;
            if (objectKlass.extensionFieldsMetadata == null || (field = objectKlass.extensionFieldsMetadata.getInstanceFieldAtSlot(slot)) == null) continue;
            return field;
        }
        throw new IndexOutOfBoundsException("Index out of range: " + slot);
    }

    Field lookupStaticFieldTableImpl(int slot) {
        if (slot >= 0) {
            assert (slot < this.staticFieldTable.length);
            return this.staticFieldTable[slot];
        }
        return this.extensionFieldsMetadata.getStaticFieldAtSlot(slot);
    }

    public Field requireHiddenField(Symbol<Symbol.Name> fieldName) {
        Field[] fTable = this.fieldTable;
        for (int i = fTable.length - 1; i >= 0; --i) {
            Field f = fTable[i];
            if (f.getName() != fieldName || !f.isHidden()) continue;
            return f;
        }
        throw EspressoError.shouldNotReachHere("Missing hidden field " + String.valueOf(fieldName) + " in " + String.valueOf(this));
    }

    public Method.MethodVersion[] getVTable() {
        assert (!this.isInterface());
        return this.getKlassVersion().getVtable();
    }

    public Method.MethodVersion[] getInterfaceMethodsTable() {
        assert (this.isInterface());
        return this.getKlassVersion().getVtable();
    }

    public Method.MethodVersion[][] getItable() {
        return this.getKlassVersion().getItable();
    }

    public KlassVersion[] getiKlassTable() {
        return this.getKlassVersion().getiKlassTable();
    }

    Method vtableLookupImpl(int vtableIndex) {
        assert (vtableIndex >= 0) : "Undeclared virtual method";
        return this.getVTable()[vtableIndex].getMethod();
    }

    public Method itableLookup(Klass interfKlass, int methodIndex) {
        assert (methodIndex >= 0) : "Undeclared interface method";
        int itableIndex = ObjectKlass.fastLookup(interfKlass, this.getiKlassTable());
        if (itableIndex < 0) {
            Meta meta = this.getMeta();
            throw meta.throwExceptionWithMessage(meta.java_lang_IncompatibleClassChangeError, "Class %s does not implement interface %s", this.getName(), interfKlass.getName());
        }
        return this.getItable()[itableIndex][methodIndex].getMethod();
    }

    int findVirtualMethodIndex(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, Klass subClass) {
        for (int i = 0; i < this.getVTable().length; ++i) {
            Method.MethodVersion m = this.getVTable()[i];
            if (m.isStatic() || m.isPrivate() || m.getName() != methodName || m.getRawSignature() != signature || !m.isProtected() && !m.isPublic() && !m.getDeclaringKlass().sameRuntimePackage(subClass)) continue;
            return i;
        }
        return -1;
    }

    public void lookupVirtualMethodOverrides(Method current, Klass subKlass, List<Method.MethodVersion> result) {
        Symbol<Symbol.Name> methodName = current.getName();
        Symbol<Symbol.Signature> signature = current.getRawSignature();
        block0: for (Method.MethodVersion m : this.getVTable()) {
            if (m.isStatic() || m.isPrivate() || m.getName() != methodName || m.getRawSignature() != signature) continue;
            if (m.isProtected() || m.isPublic()) {
                result.add(m);
                continue;
            }
            if (m.getMethod().getDeclaringKlass().sameRuntimePackage(subKlass)) {
                result.add(m);
                continue;
            }
            int index = m.getVTableIndex();
            for (ObjectKlass currentKlass = this.getSuperKlass(); currentKlass != null && index < currentKlass.getVTable().length; currentKlass = currentKlass.getSuperKlass()) {
                Method.MethodVersion toExamine = currentKlass.getVTable()[index];
                if (!current.canOverride(toExamine.getMethod())) continue;
                result.add(toExamine);
                continue block0;
            }
        }
    }

    public Method resolveInterfaceMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        assert (this.isInterface());
        for (Method m : this.getDeclaredMethods()) {
            if (methodName != m.getName() || signature != m.getRawSignature()) continue;
            return m;
        }
        assert (this.getSuperKlass().getType() == Symbol.Type.java_lang_Object);
        Method m = this.getSuperKlass().lookupDeclaredMethod(methodName, signature);
        if (m != null && m.isPublic() && !m.isStatic()) {
            return m;
        }
        Method resolved = null;
        for (int i = this.getiKlassTable().length - 1; i >= 0; --i) {
            ObjectKlass superInterf = this.getiKlassTable()[i].getKlass();
            for (Method.MethodVersion superMVersion : superInterf.getInterfaceMethodsTable()) {
                Method superM = superMVersion.getMethod();
                if (methodName != superM.getName() || signature != superM.getRawSignature()) continue;
                if (resolved == null) {
                    resolved = superM;
                    continue;
                }
                if ((resolved = InterfaceTables.resolveMaximallySpecific(resolved, superM).getMethod()).getITableIndex() != -1) continue;
                assert (resolved.identity() == superM.identity());
                resolved.setITableIndex(superM.getITableIndex());
            }
        }
        return resolved;
    }

    @Override
    public Method lookupMethod(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, Klass.LookupMode lookupMode) {
        KLASS_LOOKUP_METHOD_COUNT.inc();
        Method method = this.lookupDeclaredMethod(methodName, signature, lookupMode);
        if (method == null) {
            method = this.lookupMirandas(methodName, signature);
        }
        if (method == null && (this.getType() == Symbol.Type.java_lang_invoke_MethodHandle || this.getType() == Symbol.Type.java_lang_invoke_VarHandle)) {
            method = this.lookupPolysigMethod(methodName, signature, lookupMode);
        }
        if (method == null && this.getSuperKlass() != null) {
            method = this.getSuperKlass().lookupMethod(methodName, signature, lookupMode);
        }
        return method;
    }

    public Field[] getFieldTable() {
        if (!this.getContext().advancedRedefinitionEnabled()) {
            return this.fieldTable;
        }
        ExtensionFieldsMetadata extensionMetadata = this.getExtensionFieldsMetadata(false);
        if (extensionMetadata != null) {
            Field[] addedFields = extensionMetadata.getAddedInstanceFields();
            Field[] allFields = new Field[this.fieldTable.length + addedFields.length];
            System.arraycopy(this.fieldTable, 0, allFields, 0, this.fieldTable.length);
            System.arraycopy(addedFields, 0, allFields, this.fieldTable.length, addedFields.length);
            return allFields;
        }
        return this.fieldTable;
    }

    public Field[] getInitialFieldTable() {
        return this.fieldTable;
    }

    public Field[] getInitialStaticFields() {
        return this.staticFieldTable;
    }

    public Field[] getStaticFieldTable() {
        if (!this.getContext().advancedRedefinitionEnabled()) {
            return this.staticFieldTable;
        }
        ExtensionFieldsMetadata extensionMetadata = this.getExtensionFieldsMetadata(false);
        if (extensionMetadata != null) {
            Field[] addedStaticFields = extensionMetadata.getAddedStaticFields();
            Field[] allStaticFields = new Field[this.staticFieldTable.length + addedStaticFields.length];
            System.arraycopy(this.staticFieldTable, 0, allStaticFields, 0, this.staticFieldTable.length);
            System.arraycopy(addedStaticFields, 0, allStaticFields, this.staticFieldTable.length, addedStaticFields.length);
            return allStaticFields;
        }
        return this.staticFieldTable;
    }

    private Method lookupMirandas(Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature) {
        if (this.getMirandaMethods() == null) {
            return null;
        }
        for (Method.MethodVersion miranda : this.getMirandaMethods()) {
            Method method = miranda.getMethod();
            if (method.getName() != methodName || method.getRawSignature() != signature) continue;
            return method;
        }
        return null;
    }

    void print(PrintStream out) {
        out.println(this.getType());
        for (Method m : this.getDeclaredMethods()) {
            out.println(m);
            m.printBytecodes(out);
            out.println();
        }
    }

    public boolean hasFinalizer(EspressoContext context) {
        return (this.getModifiers(context) & 0x10000) != 0;
    }

    @CompilerDirectives.TruffleBoundary
    public List<Symbol<Symbol.Name>> getNestedTypeNames() {
        ArrayList<Symbol<Symbol.Name>> result = new ArrayList<Symbol<Symbol.Name>>();
        InnerClassesAttribute innerClasses = this.getKlassVersion().innerClasses;
        if (innerClasses != null) {
            for (InnerClassesAttribute.Entry entry : innerClasses.entries()) {
                if (entry.innerClassIndex == 0) continue;
                result.add(this.getConstantPool().classAt(entry.innerClassIndex).getName(this.getConstantPool()));
            }
        }
        return result;
    }

    private void initPackage(@JavaType(value=ClassLoader.class) StaticObject classLoader) {
        if (!Names.isUnnamedPackage(this.getRuntimePackage())) {
            ClassRegistry registry = this.getRegistries().getClassRegistry(classLoader);
            this.packageEntry = (PackageTable.PackageEntry)registry.packages().lookup(this.getRuntimePackage());
            if (this.packageEntry == null) {
                this.packageEntry = !this.getRegistries().javaBaseDefined() ? (PackageTable.PackageEntry)registry.packages().lookupOrCreate(this.getRuntimePackage(), this.getRegistries().getJavaBaseModule()) : (PackageTable.PackageEntry)registry.packages().lookupOrCreate(this.getRuntimePackage(), registry.getUnnamedModule());
            }
        }
    }

    @Override
    public ModuleTable.ModuleEntry module() {
        if (!this.inUnnamedPackage()) {
            return this.packageEntry.module();
        }
        if (this.getHostClass() != null) {
            return this.getRegistries().getClassRegistry(this.getHostClass().getDefiningClassLoader()).getUnnamedModule();
        }
        return this.getRegistries().getClassRegistry(this.getDefiningClassLoader()).getUnnamedModule();
    }

    @Override
    public PackageTable.PackageEntry packageEntry() {
        return this.packageEntry;
    }

    @Override
    public int getClassModifiers() {
        return this.getKlassVersion().getClassModifiers();
    }

    @Override
    public int getRedefinitionAwareModifiers() {
        return this.getKlassVersion().getModifiers();
    }

    @Override
    public Klass[] getSuperTypes() {
        return this.getKlassVersion().getSuperTypes();
    }

    @Override
    protected int getHierarchyDepth() {
        return this.getKlassVersion().getHierarchyDepth();
    }

    @Override
    protected KlassVersion[] getTransitiveInterfacesList() {
        return this.getKlassVersion().getTransitiveInterfacesList();
    }

    private boolean hasDeclaredDefaultMethods() {
        assert (!this.getKlassVersion().hasDeclaredDefaultMethods || this.isInterface());
        return this.getKlassVersion().hasDeclaredDefaultMethods;
    }

    private boolean hasDefaultMethods() {
        assert (!this.getKlassVersion().hasDeclaredDefaultMethods || this.isInterface());
        return this.getKlassVersion().hasDefaultMethods;
    }

    public void initSelfReferenceInPool() {
        this.getConstantPool().setKlassAt(this.getLinkedKlass().getParserKlass().getThisKlassIndex(), this);
    }

    public boolean isRecord() {
        return this.isFinalFlagSet() && this.getSuperKlass() == this.getMeta().java_lang_Record && this.getAttribute(RecordAttribute.NAME) != null;
    }

    @Override
    public String getGenericTypeAsString() {
        if (this.genericSignature == null) {
            SignatureAttribute attr = (SignatureAttribute)this.getLinkedKlass().getAttribute(SignatureAttribute.NAME);
            this.genericSignature = attr == null ? "" : this.getConstantPool().symbolAt(attr.getSignatureIndex()).toString();
        }
        return this.genericSignature;
    }

    @Override
    public int getMajorVersion() {
        return this.getLinkedKlass().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.getLinkedKlass().getMinorVersion();
    }

    @Override
    public String getSourceDebugExtension() {
        SourceDebugExtensionAttribute attribute = (SourceDebugExtensionAttribute)this.getAttribute(SourceDebugExtensionAttribute.NAME);
        return attribute != null ? attribute.getDebugExtension() : null;
    }

    public SingleImplementor getImplementor(ClassHierarchyOracle.ClassHierarchyAccessor accessor) {
        Objects.requireNonNull(accessor);
        return this.getKlassVersion().getImplementor(accessor);
    }

    @Override
    public ObjectKlass getSuperKlass() {
        return this.getKlassVersion().superKlass;
    }

    @Override
    public ObjectKlass[] getSuperInterfaces() {
        return this.getKlassVersion().superInterfaces;
    }

    @Override
    public Assumption getRedefineAssumption() {
        return this.getKlassVersion().getAssumption();
    }

    public KlassVersion getKlassVersion() {
        KlassVersion cache = this.klassVersion;
        if (!cache.assumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            do {
                cache = this.klassVersion;
            } while (!cache.assumption.isValid());
        }
        return cache;
    }

    public void redefineClass(ChangePacket packet, List<ObjectKlass> invalidatedClasses, Ids<Object> ids) {
        DetectedChange change = packet.detectedChange;
        if (change.isChangedSuperClass() && this.getDeclaredFields().length > 0) {
            ExtensionFieldsMetadata extension = this.getExtensionFieldsMetadata(true);
            for (Field declaredField : this.getDeclaredFields()) {
                if (declaredField.isStatic()) continue;
                declaredField.removeByRedefinition();
                int nextFieldSlot = this.getContext().getClassRedefinition().getNextAvailableFieldSlot();
                LinkedField.IdMode mode = LinkedKlassFieldLayout.getIdMode(this.getLinkedKlass().getParserKlass());
                LinkedField linkedField = new LinkedField(declaredField.linkedField.getParserField(), nextFieldSlot, mode);
                RedefineAddedField field = new RedefineAddedField(this.getKlassVersion(), linkedField, this.getConstantPool(), false);
                extension.addNewInstanceField(field);
            }
        }
        if (packet.parserKlass == null) {
            return;
        }
        ParserKlass parserKlass = packet.parserKlass;
        KlassVersion oldVersion = this.klassVersion;
        LinkedKlass oldLinkedKlass = oldVersion.linkedKlass;
        RuntimeConstantPool pool = new RuntimeConstantPool(this.getContext(), parserKlass.getConstantPool(), oldVersion.pool.getClassLoader());
        ObjectKlass[] superInterfaces = change.getSuperInterfaces();
        LinkedKlass[] interfaces = new LinkedKlass[superInterfaces.length];
        for (int i = 0; i < superInterfaces.length; ++i) {
            interfaces[i] = superInterfaces[i].getLinkedKlass();
        }
        LinkedKlass linkedKlass = Modifier.isInterface(change.getSuperKlass().getModifiers()) ? LinkedKlass.redefine(parserKlass, null, interfaces, oldLinkedKlass) : LinkedKlass.redefine(parserKlass, change.getSuperKlass().getLinkedKlass(), interfaces, oldLinkedKlass);
        this.klassVersion = new KlassVersion(oldVersion, pool, linkedKlass, packet, invalidatedClasses, ids);
        if (!change.getAddedStaticFields().isEmpty() || !change.getAddedInstanceFields().isEmpty()) {
            Map<ParserField, Field> compatibleFields = change.getMappedCompatibleFields();
            ExtensionFieldsMetadata extension = this.getExtensionFieldsMetadata(true);
            extension.addNewStaticFields(this.klassVersion, change.getAddedStaticFields(), pool, compatibleFields, this.getContext().getClassRedefinition());
            extension.addNewInstanceFields(this.klassVersion, change.getAddedInstanceFields(), pool, compatibleFields, this.getContext().getClassRedefinition());
            this.markForReResolution(change.getAddedStaticFields(), invalidatedClasses);
            this.markForReResolution(change.getAddedInstanceFields(), invalidatedClasses);
        }
        for (Field removedField : change.getRemovedFields()) {
            removedField.removeByRedefinition();
        }
        this.getContext().getClassHierarchyOracle().registerNewKlassVersion(this.klassVersion);
        this.incrementKlassRedefinitionCount();
        oldVersion.assumption.invalidate();
    }

    private ExtensionFieldsMetadata getExtensionFieldsMetadata(boolean create) {
        ExtensionFieldsMetadata metadata = this.extensionFieldsMetadata;
        if (metadata == null && create) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            metadata = this.createExtensionFieldsMetadata();
        }
        return metadata;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized ExtensionFieldsMetadata createExtensionFieldsMetadata() {
        if (this.extensionFieldsMetadata == null) {
            this.extensionFieldsMetadata = new ExtensionFieldsMetadata();
        }
        return this.extensionFieldsMetadata;
    }

    private void markForReResolution(List<ParserField> addedFields, List<ObjectKlass> invalidatedClasses) {
        for (ParserField addedField : addedFields) {
            for (ObjectKlass superClass = this.getSuperKlass(); superClass != null; superClass = superClass.getSuperKlass()) {
                Field field = superClass.lookupDeclaredField(addedField.getName(), addedField.getType());
                if (field == null) continue;
                invalidatedClasses.add(superClass);
            }
            List<ObjectKlass> klass = this.getSubTypes();
            for (ObjectKlass subType : klass) {
                Field field = subType.lookupDeclaredField(addedField.getName(), addedField.getType());
                if (field == null) continue;
                invalidatedClasses.add(subType);
            }
        }
    }

    public void reRunClinit() {
        this.getClassInitializer().getCallTarget().call(new Object[0]);
    }

    private static void checkCopyMethods(KlassVersion klassVersion, Method method, Method.MethodVersion[][] table, Method.SharedRedefinitionContent content, Ids<Object> ids) {
        for (Method.MethodVersion[] methods : table) {
            ObjectKlass.checkCopyMethods(klassVersion, method, methods, content, ids);
        }
    }

    private static void checkCopyMethods(KlassVersion klassVersion, Method method, Method.MethodVersion[] table, Method.SharedRedefinitionContent content, Ids<Object> ids) {
        for (Method.MethodVersion m : table) {
            Method otherMethod = m.getMethod();
            if (method.identity() != otherMethod.identity() || otherMethod == method) continue;
            otherMethod.redefine(klassVersion, content, ids);
        }
    }

    private void incrementKlassRedefinitionCount() {
        int value = InterpreterToVM.getFieldInt(this.mirror(), this.getMeta().java_lang_Class_classRedefinedCount);
        InterpreterToVM.setFieldInt(++value, this.mirror(), this.getMeta().java_lang_Class_classRedefinedCount);
    }

    private void checkSuperMethods(ObjectKlass superKlass, int flags, Symbol<Symbol.Name> methodName, Symbol<Symbol.Signature> signature, List<ObjectKlass> invalidatedClasses) {
        if (!(Modifier.isStatic(flags) || Modifier.isPrivate(flags) || Symbol.Name._init_.equals(methodName))) {
            ObjectKlass currentKlass = this;
            for (ObjectKlass currentSuper = superKlass; currentSuper != null; currentSuper = currentSuper.getSuperKlass()) {
                int vtableIndex = currentSuper.findVirtualMethodIndex(methodName, signature, currentKlass);
                if (vtableIndex != -1) {
                    invalidatedClasses.add(currentSuper);
                }
                currentKlass = currentSuper;
            }
        }
    }

    public void swapKlassVersion(Ids<Object> ids) {
        KlassVersion oldVersion = this.klassVersion;
        this.klassVersion = oldVersion.replace(ids);
        this.getContext().getClassHierarchyOracle().registerNewKlassVersion(this.klassVersion);
        this.incrementKlassRedefinitionCount();
        oldVersion.assumption.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjectKlass> getSubTypes() {
        if (this.subTypes != null) {
            ArrayList<ObjectKlass> result = new ArrayList<ObjectKlass>();
            ArrayList<WeakReference<ObjectKlass>> arrayList = this.subTypes;
            synchronized (arrayList) {
                for (WeakReference<ObjectKlass> subType : this.subTypes) {
                    ObjectKlass sub = (ObjectKlass)subType.get();
                    if (sub == null) continue;
                    result.add(sub);
                    result.addAll(sub.getSubTypes());
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isVirtual(ParserMethod m) {
        return !Modifier.isStatic(m.getFlags()) && !Modifier.isPrivate(m.getFlags()) && !Symbol.Name._init_.equals(m.getName());
    }

    public void patchClassName(Symbol<Symbol.Name> newName, Symbol<Symbol.Type> newType) {
        this.name = newName;
        this.type = newType;
    }

    public void removeByRedefinition() {
        for (Method declaredMethod : this.getDeclaredMethods()) {
            declaredMethod.removedByRedefinition();
        }
    }

    public ClassHierarchyAssumption getNoConcreteSubclassesAssumption(ClassHierarchyOracle.ClassHierarchyAccessor assumptionAccessor) {
        Objects.requireNonNull(assumptionAccessor);
        return this.getKlassVersion().getNoConcreteSubclassesAssumption(assumptionAccessor);
    }

    Field getRemovedField(Field other) {
        for (Field field : this.getFieldTable()) {
            if (!field.isRemoved() || field.getName() != other.getName() || field.getType() != other.getType()) continue;
            return field;
        }
        return null;
    }

    public String getSourceFile() {
        return this.getKlassVersion().getSourceFile();
    }

    public Source getSource() {
        return this.getKlassVersion().getSource();
    }

    static {
        assert (ObjectKlass.hasFinalInstanceField(StaticObject.class));
    }

    public final class KlassVersion {
        final Assumption assumption = Truffle.getRuntime().createAssumption();
        final RuntimeConstantPool pool;
        final LinkedKlass linkedKlass;
        final ObjectKlass superKlass;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final ObjectKlass[] superInterfaces;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Method.MethodVersion[] vtable;
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private final Method.MethodVersion[][] itable;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final KlassVersion[] iKlassTable;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Method.MethodVersion[] declaredMethods;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Method.MethodVersion[] mirandaMethods;
        private final InnerClassesAttribute innerClasses;
        private final int modifiers;
        @CompilerDirectives.CompilationFinal
        private int computedModifiers = -1;
        @CompilerDirectives.CompilationFinal
        boolean hasDeclaredDefaultMethods;
        @CompilerDirectives.CompilationFinal
        boolean hasDefaultMethods;
        @CompilerDirectives.CompilationFinal
        private HierarchyInfo hierarchyInfo;

        private KlassVersion(RuntimeConstantPool pool, LinkedKlass linkedKlass, ObjectKlass superKlass, ObjectKlass[] superInterfaces) {
            this.superKlass = superKlass;
            this.superInterfaces = superInterfaces;
            this.pool = pool;
            this.linkedKlass = linkedKlass;
            this.modifiers = linkedKlass.getFlags();
            this.innerClasses = (InnerClassesAttribute)linkedKlass.getAttribute(InnerClassesAttribute.NAME);
            LinkedMethod[] linkedMethods = linkedKlass.getLinkedMethods();
            Method.MethodVersion[] methods = new Method.MethodVersion[linkedMethods.length];
            for (int i = 0; i < linkedMethods.length; ++i) {
                methods[i] = new Method(this, linkedMethods[i], pool).getMethodVersion();
            }
            ObjectKlass.this.initPackage(pool.getClassLoader());
            if (this.isInterface()) {
                InterfaceTables.InterfaceCreationResult icr = InterfaceTables.constructInterfaceItable(this, superInterfaces, methods);
                this.vtable = icr.methodtable;
                this.iKlassTable = icr.klassTable;
                this.mirandaMethods = null;
                this.itable = null;
            } else {
                InterfaceTables.CreationResult methodCR = InterfaceTables.create(superKlass, superInterfaces, methods);
                this.iKlassTable = methodCR.klassTable;
                this.mirandaMethods = methodCR.mirandas;
                this.vtable = VirtualTable.create(superKlass, methods, this, this.mirandaMethods, false);
                this.itable = InterfaceTables.fixTables(this, this.vtable, this.mirandaMethods, methods, methodCR.tables, this.iKlassTable);
            }
            if (superKlass != null) {
                superKlass.addSubType(this.getKlass());
            }
            for (ObjectKlass superInterface : superInterfaces) {
                superInterface.addSubType(this.getKlass());
            }
            this.declaredMethods = methods;
        }

        private KlassVersion(KlassVersion oldVersion, RuntimeConstantPool pool, LinkedKlass linkedKlass, ChangePacket packet, List<ObjectKlass> invalidatedClasses, Ids<Object> ids) {
            this.pool = pool;
            this.linkedKlass = linkedKlass;
            this.modifiers = linkedKlass.getFlags();
            this.innerClasses = (InnerClassesAttribute)linkedKlass.getAttribute(InnerClassesAttribute.NAME);
            DetectedChange change = packet.detectedChange;
            this.superKlass = change.getSuperKlass();
            this.superInterfaces = change.getSuperInterfaces();
            Set<Method.MethodVersion> removedMethods = change.getRemovedMethods();
            List<ParserMethod> addedMethods = change.getAddedMethods();
            LinkedList<Method.MethodVersion> newDeclaredMethods = new LinkedList<Method.MethodVersion>(Arrays.asList(oldVersion.declaredMethods));
            newDeclaredMethods.removeAll(removedMethods);
            boolean virtualMethodsModified = false;
            for (Method.MethodVersion removedMethod : removedMethods) {
                virtualMethodsModified |= ObjectKlass.isVirtual(removedMethod.getLinkedMethod().getParserMethod());
                ParserMethod parserMethod = removedMethod.getLinkedMethod().getParserMethod();
                ObjectKlass.this.checkSuperMethods(this.superKlass, parserMethod.getFlags(), parserMethod.getName(), parserMethod.getSignature(), invalidatedClasses);
                removedMethod.getMethod().removedByRedefinition();
                ObjectKlass.this.getContext().getClassRedefinition().getController().fine(() -> "Removed method " + String.valueOf(removedMethod.getMethod().getDeclaringKlass().getName()) + "." + String.valueOf(removedMethod.getLinkedMethod().getName()));
            }
            for (ParserMethod addedMethod : addedMethods) {
                LinkedMethod linkedMethod = new LinkedMethod(addedMethod);
                Method.MethodVersion added = new Method(this, linkedMethod, pool).getMethodVersion();
                newDeclaredMethods.addLast(added);
                virtualMethodsModified |= ObjectKlass.isVirtual(addedMethod);
                ObjectKlass.this.checkSuperMethods(this.superKlass, addedMethod.getFlags(), addedMethod.getName(), addedMethod.getSignature(), invalidatedClasses);
                ObjectKlass.this.getContext().getClassRedefinition().getController().fine(() -> "Added method " + String.valueOf(added.getMethod().getDeclaringKlass().getName()) + "." + String.valueOf(added.getName()));
            }
            if (virtualMethodsModified) {
                invalidatedClasses.addAll(ObjectKlass.this.getSubTypes());
            }
            Method.MethodVersion[] methods = newDeclaredMethods.toArray(new Method.MethodVersion[0]);
            Map<Method, ParserMethod> changedMethodBodies = change.getChangedMethodBodies();
            HashMap<Method, Method.SharedRedefinitionContent> copyCheckMap = new HashMap<Method, Method.SharedRedefinitionContent>();
            for (int i = 0; i < methods.length; ++i) {
                Method declMethod = methods[i].getMethod();
                if (changedMethodBodies.containsKey(declMethod)) {
                    ParserMethod newMethod = changedMethodBodies.get(declMethod);
                    Method.SharedRedefinitionContent redefineContent = declMethod.redefine(this, newMethod, packet.parserKlass, ids);
                    ObjectKlass.this.getContext().getClassRedefinition().getController().fine(() -> "Redefining method " + String.valueOf(declMethod.getDeclaringKlass().getName()) + "." + String.valueOf(declMethod.getName()));
                    methods[i] = redefineContent.getMethodVersion();
                    int flags = newMethod.getFlags();
                    if (!(Modifier.isStatic(flags) || Modifier.isPrivate(flags) || Symbol.Name._init_.equals(newMethod.getName()))) {
                        copyCheckMap.put(declMethod, redefineContent);
                    }
                }
                if (!change.getUnchangedMethods().contains(declMethod)) continue;
                methods[i] = declMethod.swapMethodVersion(this, ids);
            }
            if (this.isInterface()) {
                InterfaceTables.InterfaceCreationResult icr = InterfaceTables.constructInterfaceItable(this, this.superInterfaces, methods);
                this.vtable = icr.methodtable;
                this.iKlassTable = icr.klassTable;
                this.mirandaMethods = null;
                this.itable = null;
            } else {
                InterfaceTables.CreationResult methodCR = InterfaceTables.create(this.superKlass, this.superInterfaces, methods);
                this.iKlassTable = methodCR.klassTable;
                this.mirandaMethods = methodCR.mirandas;
                this.vtable = VirtualTable.create(this.superKlass, methods, this, this.mirandaMethods, true);
                this.itable = InterfaceTables.fixTables(this, this.vtable, this.mirandaMethods, methods, methodCR.tables, this.iKlassTable);
            }
            for (Map.Entry entry : copyCheckMap.entrySet()) {
                Method key = (Method)entry.getKey();
                Method.SharedRedefinitionContent value = (Method.SharedRedefinitionContent)entry.getValue();
                ObjectKlass.checkCopyMethods(this, key, this.itable, value, ids);
                ObjectKlass.checkCopyMethods(this, key, this.vtable, value, ids);
                ObjectKlass.checkCopyMethods(this, key, this.mirandaMethods, value, ids);
            }
            if (packet.classChange == ClassRedefinition.ClassChange.CLASS_HIERARCHY_CHANGED) {
                if (this.superKlass != null) {
                    this.superKlass.addSubType(this.getKlass());
                }
                for (ObjectKlass superInterface : this.superInterfaces) {
                    superInterface.addSubType(this.getKlass());
                }
            }
            this.declaredMethods = methods;
        }

        public KlassVersion replace(Ids<Object> ids) {
            DetectedChange detectedChange = new DetectedChange();
            detectedChange.addSuperKlass(this.superKlass);
            detectedChange.addSuperInterfaces(this.superInterfaces);
            for (Method.MethodVersion declaredMethod : this.declaredMethods) {
                detectedChange.addUnchangedMethod(declaredMethod.getMethod());
            }
            for (Method.MethodVersion mirandaMethod : this.mirandaMethods) {
                detectedChange.addUnchangedMethod(mirandaMethod.getMethod());
            }
            ChangePacket packet = new ChangePacket(null, this.linkedKlass.getParserKlass(), null, detectedChange);
            return new KlassVersion(this, this.pool, this.linkedKlass, packet, Collections.emptyList(), ids);
        }

        public Method.MethodVersion[][] getItable() {
            return this.itable;
        }

        public Method.MethodVersion[] getDeclaredMethodVersions() {
            return this.declaredMethods;
        }

        public KlassVersion[] getiKlassTable() {
            return this.iKlassTable;
        }

        public Assumption getAssumption() {
            return this.assumption;
        }

        public ObjectKlass getKlass() {
            return ObjectKlass.this;
        }

        public ObjectKlass getSuperKlass() {
            return this.superKlass;
        }

        public ObjectKlass[] getSuperInterfaces() {
            return this.superInterfaces;
        }

        public ClassHierarchyAssumption getNoConcreteSubclassesAssumption(ClassHierarchyOracle.ClassHierarchyAccessor assumptionAccessor) {
            Objects.requireNonNull(assumptionAccessor);
            return ObjectKlass.this.noConcreteSubclassesAssumption;
        }

        public SingleImplementor getImplementor(ClassHierarchyOracle.ClassHierarchyAccessor accessor) {
            Objects.requireNonNull(accessor);
            return ObjectKlass.this.implementor;
        }

        Object getAttribute(Symbol<Symbol.Name> attrName) {
            return this.linkedKlass.getAttribute(attrName);
        }

        ConstantPool getConstantPool() {
            return this.pool;
        }

        public boolean isFinalFlagSet() {
            return Modifier.isFinal(this.modifiers);
        }

        @Idempotent
        public boolean isInterface() {
            return Modifier.isInterface(this.modifiers);
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.modifiers);
        }

        public boolean isConcrete() {
            return !this.isAbstract();
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public Method.MethodVersion[] getVtable() {
            return this.vtable;
        }

        @CompilerDirectives.TruffleBoundary
        private int computeModifiers() {
            int flags = this.modifiers;
            if (this.innerClasses != null) {
                for (InnerClassesAttribute.Entry entry : this.innerClasses.entries()) {
                    Symbol<Symbol.Name> innerClassName;
                    if (entry.innerClassIndex == 0 || !(innerClassName = this.getConstantPool().classAt(entry.innerClassIndex).getName(this.getConstantPool())).equals(ObjectKlass.this.getName())) continue;
                    flags = entry.innerClassAccessFlags;
                    break;
                }
            }
            return flags;
        }

        public int getClassModifiers() {
            int flags = this.computedModifiers;
            if (flags == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.computedModifiers = flags = this.computeModifiers();
                assert (flags != -1);
            }
            return flags & 0xFFFFFFDF & Short.MAX_VALUE;
        }

        public Klass[] getSuperTypes() {
            return this.getHierarchyInfo().supertypesWithSelfCache;
        }

        public int getHierarchyDepth() {
            return this.getHierarchyInfo().hierarchyDepth;
        }

        public KlassVersion[] getTransitiveInterfacesList() {
            return this.getHierarchyInfo().transitiveInterfaceCache;
        }

        private HierarchyInfo getHierarchyInfo() {
            HierarchyInfo info = this.hierarchyInfo;
            if (info == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                info = this.hierarchyInfo = this.updateHierarchyInfo();
            }
            return info;
        }

        private HierarchyInfo updateHierarchyInfo() {
            Klass[] supertypes;
            int depth;
            int n = depth = this.superKlass == null ? 0 : this.superKlass.getHierarchyDepth() + 1;
            if (this.superKlass == null) {
                supertypes = new Klass[]{this.getKlass()};
            } else {
                Klass[] superKlassTypes = this.superKlass.getSuperTypes();
                supertypes = new Klass[superKlassTypes.length + 1];
                assert (supertypes.length == depth + 1);
                System.arraycopy(superKlassTypes, 0, supertypes, 0, depth);
                supertypes[depth] = this.getKlass();
            }
            return new HierarchyInfo(supertypes, depth, this.iKlassTable);
        }

        public String getSourceFile() {
            SourceFileAttribute sfa = (SourceFileAttribute)this.getAttribute(Symbol.Name.SourceFile);
            if (sfa == null) {
                return null;
            }
            return this.getConstantPool().utf8At(sfa.getSourceFileIndex()).toString();
        }

        public Source getSource() {
            if (ObjectKlass.this.source == null) {
                ObjectKlass.this.source = ObjectKlass.this.getContext().findOrCreateSource(ObjectKlass.this);
            }
            return ObjectKlass.this.source;
        }

        public String toString() {
            return "KlassVersion<" + String.valueOf(ObjectKlass.this.getType()) + ">";
        }
    }
}

