/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

final class InterfaceTables {
    private static final Comparator<TableData> SORTER = new Comparator<TableData>(){

        @Override
        public int compare(TableData o1, TableData o2) {
            return Long.compare(o1.klass.getKlass().getId(), o2.klass.getKlass().getId());
        }
    };
    private static final Entry[][] EMPTY_ENTRY_DUAL_ARRAY = new Entry[0][];
    private static final Method.MethodVersion[][] EMPTY_METHOD_DUAL_ARRAY = new Method.MethodVersion[0][];
    private final ObjectKlass superKlass;
    private final ObjectKlass[] superInterfaces;
    private final Method.MethodVersion[] declaredMethods;
    private final ArrayList<Entry[]> tmpTables = new ArrayList();
    private final ArrayList<ObjectKlass.KlassVersion> tmpKlassTable = new ArrayList();
    private final ArrayList<Method.MethodVersion> mirandas = new ArrayList();

    private InterfaceTables(ObjectKlass superKlass, ObjectKlass[] superInterfaces, Method.MethodVersion[] declaredMethods) {
        this.superKlass = superKlass;
        this.superInterfaces = superInterfaces;
        this.declaredMethods = declaredMethods;
    }

    public static InterfaceCreationResult constructInterfaceItable(ObjectKlass.KlassVersion thisInterfKlass, ObjectKlass[] superInterfaces, Method.MethodVersion[] declared) {
        assert (thisInterfKlass.isInterface());
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Method.MethodVersion> tmpMethodTable = new ArrayList<Method.MethodVersion>();
        for (Method.MethodVersion method : declared) {
            if (!method.isStatic() && !method.isPrivate()) {
                method.setITableIndex(tmpMethodTable.size());
                tmpMethodTable.add(method);
            }
            if (method.isAbstract() || method.isStatic()) continue;
            thisInterfKlass.hasDeclaredDefaultMethods = true;
        }
        thisInterfKlass.hasDefaultMethods = thisInterfKlass.hasDeclaredDefaultMethods;
        Method.MethodVersion[] methods = tmpMethodTable.toArray(Method.EMPTY_VERSION_ARRAY);
        ArrayList<ObjectKlass.KlassVersion> tmpKlassTable = new ArrayList<ObjectKlass.KlassVersion>();
        tmpKlassTable.add(thisInterfKlass);
        for (ObjectKlass interf : superInterfaces) {
            for (ObjectKlass.KlassVersion supInterf : interf.getiKlassTable()) {
                if (!InterfaceTables.canInsert(supInterf, tmpKlassTable)) continue;
                tmpKlassTable.add(supInterf);
            }
            if (!interf.getKlassVersion().hasDefaultMethods) continue;
            thisInterfKlass.hasDefaultMethods = true;
        }
        ObjectKlass.KlassVersion[] sortedInterfaces = tmpKlassTable.toArray(ObjectKlass.EMPTY_KLASSVERSION_ARRAY);
        Arrays.sort(sortedInterfaces, Klass.KLASS_VERSION_ID_COMPARATOR);
        return new InterfaceCreationResult(sortedInterfaces, methods);
    }

    public static CreationResult create(ObjectKlass superKlass, ObjectKlass[] superInterfaces, Method.MethodVersion[] declaredMethods) {
        return new InterfaceTables(superKlass, superInterfaces, declaredMethods).create();
    }

    public static Method.MethodVersion[][] fixTables(ObjectKlass.KlassVersion self, Method.MethodVersion[] vtable, Method.MethodVersion[] mirandas, Method.MethodVersion[] declaredMethods, Entry[][] tables, ObjectKlass.KlassVersion[] iklassTable) {
        assert (tables.length == iklassTable.length);
        ArrayList<Method.MethodVersion[]> tmpTables = new ArrayList<Method.MethodVersion[]>();
        for (int i = iklassTable.length - 1; i >= 0; --i) {
            InterfaceTables.fixVTable(self, tables[i], vtable, mirandas, declaredMethods, iklassTable[i].getKlass().getInterfaceMethodsTable());
        }
        for (Entry[] entries : tables) {
            Method.MethodVersion[] itable = InterfaceTables.getITable(entries, vtable, mirandas, declaredMethods);
            tmpTables.add(itable);
        }
        return (Method.MethodVersion[][])tmpTables.toArray((T[])EMPTY_METHOD_DUAL_ARRAY);
    }

    private CreationResult create() {
        for (ObjectKlass interf : this.superInterfaces) {
            this.fillMirandas(interf.getKlassVersion());
            for (ObjectKlass.KlassVersion supInterf : interf.getiKlassTable()) {
                this.fillMirandas(supInterf);
            }
        }
        if (this.superKlass != null) {
            for (ObjectKlass.KlassVersion superKlassInterf : this.superKlass.getiKlassTable()) {
                this.fillMirandas(superKlassInterf);
            }
        }
        return new CreationResult((Entry[][])this.tmpTables.toArray((T[])EMPTY_ENTRY_DUAL_ARRAY), this.tmpKlassTable.toArray(ObjectKlass.EMPTY_KLASSVERSION_ARRAY), this.mirandas.toArray(Method.EMPTY_VERSION_ARRAY));
    }

    private void fillMirandas(ObjectKlass.KlassVersion interf) {
        if (InterfaceTables.canInsert(interf, this.tmpKlassTable)) {
            Method.MethodVersion[] interfMethods = interf.getKlass().getInterfaceMethodsTable();
            Entry[] res = new Entry[interfMethods.length];
            for (int i = 0; i < res.length; ++i) {
                Method im = interfMethods[i].getMethod();
                Symbol<Symbol.Name> mname = im.getName();
                Symbol<Symbol.Signature> sig = im.getRawSignature();
                res[i] = this.lookupLocation(im, mname, sig);
            }
            this.tmpTables.add(res);
            this.tmpKlassTable.add(interf);
        }
    }

    private static void fixVTable(ObjectKlass.KlassVersion self, Entry[] table, Method.MethodVersion[] vtable, Method.MethodVersion[] mirandas, Method.MethodVersion[] declared, Method.MethodVersion[] interfMethods) {
        for (int i = 0; i < table.length; ++i) {
            Method.MethodVersion result;
            Method.MethodVersion interfMethod;
            Entry entry = table[i];
            int index = entry.index;
            Method.MethodVersion virtualMethod = switch (entry.loc.ordinal()) {
                case 0 -> vtable[index];
                case 2 -> mirandas[index];
                case 1 -> declared[index];
                default -> {
                    CompilerAsserts.neverPartOfCompilation();
                    throw EspressoError.shouldNotReachHere();
                }
            };
            if (!virtualMethod.getKlassVersion().isInterface() || (interfMethod = interfMethods[i]).getMethod().identity() == virtualMethod.getMethod().identity() || (result = InterfaceTables.resolveMaximallySpecific(virtualMethod.getMethod(), interfMethod.getMethod())).getMethod() == virtualMethod.getMethod()) continue;
            InterfaceTables.updateEntry(self, vtable, mirandas, entry, index, virtualMethod, InterfaceTables.virtualize(result.getMethod(), virtualMethod.getVTableIndex()));
        }
    }

    private static Method.MethodVersion virtualize(Method m, int index) {
        if (m.getVTableIndex() != index) {
            return new Method(m).getMethodVersion();
        }
        return m.getMethodVersion();
    }

    private static void updateEntry(ObjectKlass.KlassVersion self, Method.MethodVersion[] vtable, Method.MethodVersion[] mirandas, Entry entry, int index, Method.MethodVersion virtualMethod, Method.MethodVersion toPut) {
        switch (entry.loc.ordinal()) {
            case 0: {
                vtable[index] = toPut;
                toPut.setVTableIndex(index);
                break;
            }
            case 1: {
                vtable[virtualMethod.getVTableIndex()] = toPut;
                toPut.setVTableIndex(virtualMethod.getVTableIndex());
                break;
            }
            case 2: {
                Method newMiranda = toPut.getMethod().getDeclaringKlass() == self.getKlass() ? new Method(toPut.getMethod()) : new Method(toPut.getMethod());
                int vtableIndex = virtualMethod.getVTableIndex();
                vtable[vtableIndex] = newMiranda.getMethodVersion();
                mirandas[index] = newMiranda.getMethodVersion();
                newMiranda.setVTableIndex(vtableIndex);
                break;
            }
            default: {
                CompilerAsserts.neverPartOfCompilation();
                throw EspressoError.shouldNotReachHere();
            }
        }
    }

    private static Method.MethodVersion[] getITable(Entry[] entries, Method.MethodVersion[] vtable, Method.MethodVersion[] mirandas, Method.MethodVersion[] declared) {
        int pos = 0;
        Method.MethodVersion[] res = new Method.MethodVersion[entries.length];
        for (Entry entry : entries) {
            switch (entry.loc.ordinal()) {
                case 0: {
                    Method.MethodVersion m = vtable[entry.index];
                    res[pos] = new Method(m.getMethod()).getMethodVersion();
                    break;
                }
                case 1: {
                    Method.MethodVersion m = declared[entry.index];
                    res[pos] = new Method(m.getMethod()).getMethodVersion();
                    break;
                }
                case 2: {
                    Method.MethodVersion m = mirandas[entry.index];
                    res[pos] = new Method(m.getMethod()).getMethodVersion();
                }
            }
            res[pos].setITableIndex(pos);
            ++pos;
        }
        return res;
    }

    private Entry lookupLocation(Method im, Symbol<Symbol.Name> mname, Symbol<Symbol.Signature> sig) {
        int index = -1;
        if (this.superKlass != null) {
            index = InterfaceTables.getMethodTableIndex(this.superKlass.getVTable(), im, mname, sig);
        }
        if (index != -1) {
            Method m = this.superKlass.vtableLookup(index);
            assert (index == m.getVTableIndex());
            return new Entry(Location.SUPERVTABLE, index);
        }
        index = InterfaceTables.getMethodTableIndex(this.declaredMethods, im, mname, sig);
        if (index != -1) {
            return new Entry(Location.DECLARED, index);
        }
        index = this.lookupMirandas(im, mname, sig);
        if (index != -1) {
            return new Entry(Location.MIRANDAS, index);
        }
        this.mirandas.add(new Method(im).getMethodVersion());
        return new Entry(Location.MIRANDAS, this.mirandas.size() - 1);
    }

    private static int getMethodTableIndex(Method.MethodVersion[] table, Method interfMethod, Symbol<Symbol.Name> mname, Symbol<Symbol.Signature> sig) {
        for (int i = 0; i < table.length; ++i) {
            Method.MethodVersion m = table[i];
            if (!InterfaceTables.canOverride(m.getMethod(), interfMethod, m.getMethod().getContext()) || mname != m.getName() || sig != m.getRawSignature()) continue;
            return i;
        }
        return -1;
    }

    private int lookupMirandas(Method interfMethod, Symbol<Symbol.Name> mname, Symbol<Symbol.Signature> sig) {
        int pos = 0;
        for (Method.MethodVersion m : this.mirandas) {
            if (m.getMethod().canOverride(interfMethod) && m.getName() == mname && sig == m.getRawSignature()) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private static boolean canOverride(Method m, Method im, EspressoContext context) {
        return !m.isStatic() && (context.getJavaVersion().java8OrEarlier() || m.canOverride(im));
    }

    public static Method.MethodVersion resolveMaximallySpecific(Method m1, Method m2) {
        ObjectKlass k2;
        ObjectKlass k1 = m1.getDeclaringKlass();
        if (k1.isAssignableFrom(k2 = m2.getDeclaringKlass())) {
            return m2.getMethodVersion();
        }
        if (k2.isAssignableFrom(k1)) {
            return m1.getMethodVersion();
        }
        boolean b1 = m1.isAbstract();
        boolean b2 = m2.isAbstract();
        if (b1 && b2) {
            return m1.getMethodVersion();
        }
        if (b1) {
            return m2.getMethodVersion();
        }
        if (b2) {
            return m1.getMethodVersion();
        }
        Method m = new Method(m2);
        m.setPoisonPill();
        return m.getMethodVersion();
    }

    private static boolean canInsert(ObjectKlass.KlassVersion interf, ArrayList<ObjectKlass.KlassVersion> tmpKlassTable) {
        for (ObjectKlass.KlassVersion k : tmpKlassTable) {
            if (k.getKlass() != interf.getKlass()) continue;
            return false;
        }
        return true;
    }

    static class InterfaceCreationResult {
        ObjectKlass.KlassVersion[] klassTable;
        Method.MethodVersion[] methodtable;

        InterfaceCreationResult(ObjectKlass.KlassVersion[] klassTable, Method.MethodVersion[] methodtable) {
            this.klassTable = klassTable;
            this.methodtable = methodtable;
        }
    }

    static class CreationResult {
        Entry[][] tables;
        ObjectKlass.KlassVersion[] klassTable;
        Method.MethodVersion[] mirandas;

        CreationResult(Entry[][] tables, ObjectKlass.KlassVersion[] klassTable, Method.MethodVersion[] mirandas) {
            int i;
            TableData[] data = new TableData[klassTable.length];
            for (i = 0; i < data.length; ++i) {
                data[i] = new TableData(klassTable[i], tables[i]);
            }
            Arrays.sort(data, SORTER);
            for (i = 0; i < data.length; ++i) {
                tables[i] = data[i].table;
                klassTable[i] = data[i].klass;
            }
            this.tables = tables;
            this.klassTable = klassTable;
            this.mirandas = mirandas;
        }
    }

    static final class Entry {
        Location loc;
        int index;

        Entry(Location loc, int index) {
            this.loc = loc;
            this.index = index;
        }
    }

    private static enum Location {
        SUPERVTABLE,
        DECLARED,
        MIRANDAS;

    }

    static class TableData {
        ObjectKlass.KlassVersion klass;
        Entry[] table;

        TableData(ObjectKlass.KlassVersion klass, Entry[] table) {
            this.klass = klass;
            this.table = table;
        }
    }
}

