/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.descriptors.Types;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.impl.ClassRegistries;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;

public final class GuestClassRegistry
extends ClassRegistry {
    static final DebugCounter loadKlassCount = DebugCounter.create("Guest loadKlassCount");
    static final DebugCounter loadKlassCacheHits = DebugCounter.create("Guest loadKlassCacheHits");
    private final StaticObject classLoader;
    private final Method loadClass;
    private final Method addClass;

    @Override
    protected void loadKlassCountInc() {
        loadKlassCount.inc();
    }

    @Override
    protected void loadKlassCacheHitsInc() {
        loadKlassCacheHits.inc();
    }

    public GuestClassRegistry(ClassLoadingEnv env, @JavaType(value=ClassLoader.class) StaticObject classLoader) {
        super(env.getNewLoaderId());
        assert (StaticObject.notNull(classLoader)) : "cannot be the BCL";
        this.classLoader = classLoader;
        this.loadClass = classLoader.getKlass().lookupMethod(Symbol.Name.loadClass, Symbol.Signature.Class_String);
        this.addClass = classLoader.getKlass().lookupMethod(Symbol.Name.addClass, Symbol.Signature._void_Class);
        if (env.getJavaVersion().modulesEnabled()) {
            StaticObject unnamedModule = env.getMeta().java_lang_ClassLoader_unnamedModule.getObject(classLoader);
            this.initUnnamedModule(unnamedModule);
            env.getMeta().HIDDEN_MODULE_ENTRY.setHiddenObject(unnamedModule, this.getUnnamedModule());
        }
    }

    @Override
    public Klass loadKlassImpl(EspressoContext context, Symbol<Symbol.Type> type) {
        assert (StaticObject.notNull(this.classLoader));
        ClassLoadingEnv env = context.getClassLoadingEnv();
        StaticObject guestClass = (StaticObject)this.loadClass.invokeDirect(this.classLoader, env.getMeta().toGuestString(Types.binaryName(type)));
        Klass klass = guestClass.getMirrorKlass();
        context.getRegistries().recordConstraint(type, klass, this.getClassLoader());
        ClassRegistries.RegistryEntry entry = new ClassRegistries.RegistryEntry(klass);
        ClassRegistries.RegistryEntry previous = this.classes.putIfAbsent(type, entry);
        assert (previous == null || previous.klass() == klass);
        return klass;
    }

    @Override
    public @JavaType(value=ClassLoader.class) StaticObject getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ObjectKlass defineKlass(EspressoContext context, Symbol<Symbol.Type> typeOrNull, byte[] bytes, ClassRegistry.ClassDefinitionInfo info) throws EspressoClassLoadingException {
        ObjectKlass klass = super.defineKlass(context, typeOrNull, bytes, info);
        if (info.addedToRegistry()) {
            this.addClass.invokeDirect(this.classLoader, klass.mirror());
        }
        return klass;
    }
}

