/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.LanguageAccess;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.TimerCollection;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.util.concurrent.atomic.AtomicLong;

public class ClassLoadingEnv
implements LanguageAccess {
    private final AtomicLong klassIdProvider = new AtomicLong();
    private final AtomicLong loaderIdProvider = new AtomicLong();
    private final EspressoLanguage language;
    private final TruffleLogger logger;
    private final TimerCollection timers;
    @CompilerDirectives.CompilationFinal
    private Meta meta;

    public ClassLoadingEnv(EspressoLanguage language, TruffleLogger logger, TimerCollection timers) {
        this.language = language;
        this.logger = logger;
        this.timers = timers;
    }

    @Override
    public EspressoLanguage getLanguage() {
        return this.language;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public TruffleLogger getLogger() {
        return this.logger;
    }

    public TimerCollection getTimers() {
        return this.timers;
    }

    private static boolean shouldCacheClass(ClassRegistry.ClassDefinitionInfo info) {
        return !info.isAnonymousClass() && !info.isHidden();
    }

    public boolean shouldCacheClass(ClassRegistry.ClassDefinitionInfo info, StaticObject loader) {
        return ClassLoadingEnv.shouldCacheClass(info) && (this.loaderIsBootOrPlatform(loader) || this.loaderIsAppLoader(loader));
    }

    public boolean loaderIsBootOrPlatform(StaticObject loader) {
        return StaticObject.isNull(loader) || this.language.getJavaVersion().java9OrLater() && this.meta.jdk_internal_loader_ClassLoaders$PlatformClassLoader.isAssignableFrom(loader.getKlass());
    }

    public boolean loaderIsAppLoader(StaticObject loader) {
        return !StaticObject.isNull(loader) && this.meta.jdk_internal_loader_ClassLoaders$AppClassLoader.isAssignableFrom(loader.getKlass());
    }

    public long getNewKlassId() {
        long id = this.klassIdProvider.getAndIncrement();
        if (id < 0L) {
            throw EspressoError.shouldNotReachHere("Exhausted klass IDs");
        }
        return id;
    }

    public long getNewLoaderId() {
        long id = this.loaderIdProvider.getAndIncrement();
        if (id < 0L) {
            throw EspressoError.shouldNotReachHere("Exhausted loader IDs");
        }
        return id;
    }
}

