/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.ffi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class Callback
implements TruffleObject {
    private final int arity;
    private final Function function;

    public Callback(int arity, Function function) {
        this.arity = arity;
        this.function = function;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    public Object execute(Object ... arguments) throws ArityException {
        if (arguments.length == this.arity) {
            Object ret = this.function.call(arguments);
            return ret;
        }
        CompilerDirectives.transferToInterpreter();
        throw ArityException.create((int)this.arity, (int)this.arity, (int)arguments.length);
    }

    public static interface Function {
        public Object call(Object ... var1);
    }
}

