/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.descriptors;

import com.oracle.truffle.espresso.descriptors.ByteSequence;

final class SymbolKey {
    private final int hash;
    protected ByteSequence seq;

    SymbolKey(ByteSequence seq) {
        this.seq = seq;
        this.hash = seq.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        SymbolKey that = (SymbolKey)other;
        ByteSequence thisSeq = this.seq;
        ByteSequence thatSeq = that.seq;
        if (thisSeq == thatSeq) {
            return true;
        }
        if (thisSeq.hashCode != thatSeq.hashCode) {
            return false;
        }
        int len = thisSeq.length();
        if (len != thatSeq.length()) {
            return false;
        }
        byte[] thisBytes = thisSeq.getUnderlyingBytes();
        byte[] thatBytes = thatSeq.getUnderlyingBytes();
        int thisOffset = thisSeq.offset();
        int thatOffset = thatSeq.offset();
        for (int i = 0; i < len; ++i) {
            if (thisBytes[i + thisOffset] == thatBytes[i + thatOffset]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }
}

