/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.constantpool;

import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.RuntimeConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.descriptors.Signatures;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.nio.ByteBuffer;

public interface MethodTypeConstant
extends PoolConstant {
    public static MethodTypeConstant create(int descriptorIndex) {
        return new Index(descriptorIndex);
    }

    @Override
    default public ConstantPool.Tag tag() {
        return ConstantPool.Tag.METHODTYPE;
    }

    public static StaticObject signatureToMethodType(Symbol<Symbol.Type>[] signature, Klass accessingKlass, boolean failWithBME, Meta meta) {
        StaticObject rtype;
        Symbol<Symbol.Type> rt = Signatures.returnType(signature);
        int pcount = Signatures.parameterCount(signature);
        StaticObject[] ptypes = new StaticObject[pcount];
        try {
            for (int i = 0; i < pcount; ++i) {
                Symbol<Symbol.Type> paramType = Signatures.parameterType(signature, i);
                ptypes[i] = meta.resolveSymbolAndAccessCheck(paramType, accessingKlass).mirror();
            }
        }
        catch (EspressoException e) {
            if (meta.java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
                throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, e.getGuestMessage());
            }
            throw e;
        }
        try {
            rtype = meta.resolveSymbolAndAccessCheck(rt, accessingKlass).mirror();
        }
        catch (EspressoException e) {
            EspressoException rethrow = e;
            if (meta.java_lang_ClassNotFoundException.isAssignableFrom(e.getGuestException().getKlass())) {
                rethrow = EspressoException.wrap(Meta.initExceptionWithMessage(meta.java_lang_NoClassDefFoundError, e.getGuestMessage()), meta);
            }
            if (failWithBME) {
                rethrow = EspressoException.wrap(Meta.initExceptionWithCause(meta.java_lang_BootstrapMethodError, rethrow.getGuestException()), meta);
            }
            throw rethrow;
        }
        return (StaticObject)meta.java_lang_invoke_MethodHandleNatives_findMethodHandleType.invokeDirect(null, rtype, StaticObject.createArray(meta.java_lang_Class_array, ptypes, meta.getContext()));
    }

    public Symbol<Symbol.Signature> getSignature(ConstantPool var1);

    @Override
    default public String toString(ConstantPool pool) {
        return this.getSignature(pool).toString();
    }

    public static final class Index
    implements MethodTypeConstant,
    Resolvable {
        private final char descriptorIndex;

        Index(int descriptorIndex) {
            this.descriptorIndex = PoolConstant.u2(descriptorIndex);
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            return pool.symbolAt(this.descriptorIndex);
        }

        @Override
        public Resolved resolve(RuntimeConstantPool pool, int index, Klass accessingKlass) {
            Symbol<Symbol.Signature> sig = this.getSignature(pool);
            Meta meta = accessingKlass.getContext().getMeta();
            return new Resolved(MethodTypeConstant.signatureToMethodType(meta.getSignatures().parsed(sig), accessingKlass, false, meta));
        }

        @Override
        public void validate(ConstantPool pool) {
            pool.utf8At(this.descriptorIndex).validateSignature();
        }

        @Override
        public void dump(ByteBuffer buf) {
            buf.putChar(this.descriptorIndex);
        }
    }

    public static final class Resolved
    implements MethodTypeConstant,
    Resolvable.ResolvedConstant {
        private final StaticObject resolved;

        Resolved(StaticObject resolved) {
            this.resolved = resolved;
        }

        @Override
        public Symbol<Symbol.Signature> getSignature(ConstantPool pool) {
            throw EspressoError.shouldNotReachHere("Method type already resolved !");
        }

        @Override
        public Object value() {
            return this.resolved;
        }
    }
}

