/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile.attributes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.attributes.Local;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.jdwp.api.LocalVariableTableRef;
import com.oracle.truffle.espresso.runtime.Attribute;
import java.util.ArrayList;

public final class LocalVariableTable
extends Attribute
implements LocalVariableTableRef {
    public static final LocalVariableTable EMPTY_LVT = new LocalVariableTable(Symbol.Name.LocalVariableTable, Local.EMPTY_ARRAY);
    public static final LocalVariableTable EMPTY_LVTT = new LocalVariableTable(Symbol.Name.LocalVariableTypeTable, Local.EMPTY_ARRAY);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Local[] locals;

    public LocalVariableTable(Symbol<Symbol.Name> name, Local[] locals) {
        super(name, null);
        this.locals = locals;
    }

    public Local getLocal(int slot, int bci) {
        Local result = null;
        for (Local local : this.locals) {
            if (local.getSlot() != slot || local.getStartBCI() > bci || local.getEndBCI() < bci) continue;
            if (result == null) {
                result = local;
                continue;
            }
            throw new IllegalStateException("Locals overlap!");
        }
        return result;
    }

    public Local[] getLocals() {
        return (Local[])this.locals.clone();
    }

    public Local[] getLocalsAt(int bci) {
        ArrayList<Local> result = new ArrayList<Local>();
        for (Local l : this.locals) {
            if (l.getStartBCI() > bci || bci > l.getEndBCI()) continue;
            result.add(l);
        }
        return result.toArray(Local.EMPTY_ARRAY);
    }
}

