/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ConstantPool;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.NeedsFreshResolutionException;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Resolvable;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

public final class RuntimeConstantPool
extends ConstantPool {
    private final EspressoContext context;
    private final ConstantPool pool;
    private final StaticObject classLoader;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Resolvable.ResolvedConstant[] constants;

    public RuntimeConstantPool(EspressoContext context, ConstantPool pool, StaticObject classLoader) {
        this.context = context;
        this.pool = pool;
        this.constants = RuntimeConstantPool.copyResolvedConstant(pool);
        this.classLoader = classLoader;
    }

    private static Resolvable.ResolvedConstant[] copyResolvedConstant(ConstantPool pool) {
        return new Resolvable.ResolvedConstant[pool.length()];
    }

    @Override
    public int length() {
        return this.pool.length();
    }

    @Override
    public byte[] getRawBytes() {
        return this.pool.getRawBytes();
    }

    @Override
    public PoolConstant at(int index, String description) {
        return this.pool.at(index, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolvable.ResolvedConstant outOfLockResolvedAt(Klass accessingKlass, int index, String description) {
        Resolvable.ResolvedConstant c = this.constants[index];
        if (c == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            c = this.constants[index];
            if (c == null) {
                Resolvable.ResolvedConstant locallyResolved = ((Resolvable)this.pool.at(index, description)).resolve(this, index, accessingKlass);
                RuntimeConstantPool runtimeConstantPool = this;
                synchronized (runtimeConstantPool) {
                    c = this.constants[index];
                    if (c == null) {
                        this.constants[index] = c = locallyResolved;
                    }
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolvable.ResolvedConstant resolvedAt(Klass accessingKlass, int index, String description) {
        Resolvable.ResolvedConstant c = this.constants[index];
        if (c == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                c = this.constants[index];
                if (c == null) {
                    this.constants[index] = c = ((Resolvable)this.pool.at(index, description)).resolve(this, index, accessingKlass);
                }
            }
        }
        return c;
    }

    private Resolvable.ResolvedConstant resolvedAtNoCache(Klass accessingKlass, int index, String description) {
        CompilerAsserts.neverPartOfCompilation();
        return ((Resolvable)this.pool.at(index, description)).resolve(this, index, accessingKlass);
    }

    public StaticObject resolvedStringAt(int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(null, index, "string");
        return (StaticObject)resolved.value();
    }

    public Klass resolvedKlassAt(Klass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "klass");
        return (Klass)resolved.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field resolvedFieldAt(Klass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "field");
        try {
            return (Field)resolved.value();
        }
        catch (NeedsFreshResolutionException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                this.constants[index] = null;
            }
            return this.resolvedFieldAt(accessingKlass, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field resolveFieldAndUpdate(Klass accessingKlass, int index, Field field) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Resolvable.ResolvedConstant resolved = this.resolvedAtNoCache(accessingKlass, index, "field");
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                this.constants[index] = resolved;
            }
            return (Field)resolved.value();
        }
        catch (EspressoException e) {
            Field realField = field;
            if (realField.hasCompatibleField()) {
                realField = realField.getCompatibleField();
            }
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                Resolvable.ResolvedConstant resolved;
                Field delegationField = this.context.getClassRedefinition().createDelegationFrom(realField);
                this.constants[index] = resolved = FieldRefConstant.fromPreResolved(delegationField);
                return delegationField;
            }
        }
    }

    public boolean isResolutionSuccessAt(int index) {
        Resolvable.ResolvedConstant constant = this.constants[index];
        return constant != null && constant.isSuccess();
    }

    public Method resolvedMethodAt(Klass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method");
        return (Method)resolved.value();
    }

    public Method resolvedMethodAtNoCache(Klass accessingKlass, int index) {
        CompilerAsserts.neverPartOfCompilation();
        Resolvable.ResolvedConstant resolved = this.resolvedAtNoCache(accessingKlass, index, "method");
        return (Method)resolved.value();
    }

    public StaticObject resolvedMethodHandleAt(Klass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method handle");
        return (StaticObject)resolved.value();
    }

    public StaticObject resolvedMethodTypeAt(Klass accessingKlass, int index) {
        Resolvable.ResolvedConstant resolved = this.resolvedAt(accessingKlass, index, "method type");
        return (StaticObject)resolved.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokeDynamicConstant.CallSiteLink linkInvokeDynamic(Klass accessingKlass, int index) {
        InvokeDynamicConstant indy = (InvokeDynamicConstant)((Object)this.resolvedAt(accessingKlass, index, "indy"));
        try {
            return indy.link(this, accessingKlass, index);
        }
        catch (InvokeDynamicConstant.CallSiteLinkingFailure failure) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RuntimeConstantPool runtimeConstantPool = this;
            synchronized (runtimeConstantPool) {
                this.constants[index] = failure.failConstant();
            }
            throw failure.cause;
        }
    }

    public DynamicConstant.Resolved resolvedDynamicConstantAt(Klass accessingKlass, int index) {
        DynamicConstant.Resolved dynamicConstant = (DynamicConstant.Resolved)this.outOfLockResolvedAt(accessingKlass, index, "dynamic constant");
        dynamicConstant.checkFail();
        return dynamicConstant;
    }

    public StaticObject getClassLoader() {
        return this.classLoader;
    }

    public EspressoContext getContext() {
        return this.context;
    }

    public void setKlassAt(int index, ObjectKlass klass) {
        this.constants[index] = ClassConstant.resolved(klass);
    }

    @Override
    public int getMajorVersion() {
        return this.pool.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.pool.getMinorVersion();
    }
}

