/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.classfile;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.classfile.ClassfileParser;
import com.oracle.truffle.espresso.classfile.ClassfileStream;
import com.oracle.truffle.espresso.classfile.ConstantPoolImpl;
import com.oracle.truffle.espresso.classfile.constantpool.ClassConstant;
import com.oracle.truffle.espresso.classfile.constantpool.ClassMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DoubleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.DynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FieldRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.FloatConstant;
import com.oracle.truffle.espresso.classfile.constantpool.IntegerConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InterfaceMethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvalidConstant;
import com.oracle.truffle.espresso.classfile.constantpool.InvokeDynamicConstant;
import com.oracle.truffle.espresso.classfile.constantpool.LongConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MemberRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodHandleConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodRefConstant;
import com.oracle.truffle.espresso.classfile.constantpool.MethodTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.NameAndTypeConstant;
import com.oracle.truffle.espresso.classfile.constantpool.PoolConstant;
import com.oracle.truffle.espresso.classfile.constantpool.StringConstant;
import com.oracle.truffle.espresso.classfile.constantpool.Utf8Constant;
import com.oracle.truffle.espresso.descriptors.ByteSequence;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ClassLoadingEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

public abstract class ConstantPool {
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_Dynamic = 17;
    public static final byte CONSTANT_InvokeDynamic = 18;
    public static final byte CONSTANT_Module = 19;
    public static final byte CONSTANT_Package = 20;
    private static final DebugCounter UTF8_ENTRY_COUNT = DebugCounter.create("UTF8 Constant Pool entries");

    public abstract int getMajorVersion();

    public abstract int getMinorVersion();

    public abstract int length();

    public abstract PoolConstant at(int var1, String var2);

    public final PoolConstant at(int index) {
        return this.at(index, null);
    }

    public abstract byte[] getRawBytes();

    static @JavaType(value=ClassFormatError.class) EspressoException unexpectedEntry(int index, Tag tag, String description, Tag ... expected) {
        CompilerDirectives.transferToInterpreter();
        throw ConstantPool.classFormatError("Constant pool entry" + (String)(description == null ? "" : " for " + description) + " at " + index + " is a " + String.valueOf((Object)tag) + ", expected " + Arrays.toString((Object[])expected));
    }

    final @JavaType(value=ClassFormatError.class) EspressoException unexpectedEntry(int index, String description, Tag ... expected) {
        CompilerDirectives.transferToInterpreter();
        throw ConstantPool.unexpectedEntry(index, this.tagAt(index), description, expected);
    }

    static @JavaType(value=VerifyError.class) EspressoException verifyError(String message) {
        CompilerDirectives.transferToInterpreter();
        Meta meta = EspressoContext.get(null).getMeta();
        if (meta.java_lang_VerifyError == null) {
            throw EspressoError.fatal("VerifyError during early startup: ", message);
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_VerifyError, message);
    }

    public static @JavaType(value=ClassFormatError.class) EspressoException classFormatError(String message) {
        CompilerDirectives.transferToInterpreter();
        Meta meta = EspressoContext.get(null).getMeta();
        if (meta.java_lang_ClassFormatError == null) {
            throw EspressoError.fatal("ClassFormatError during early startup: ", message);
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_ClassFormatError, message);
    }

    static @JavaType(value=NoClassDefFoundError.class) EspressoException noClassDefFoundError(String message) {
        CompilerDirectives.transferToInterpreter();
        Meta meta = EspressoContext.get(null).getMeta();
        if (meta.java_lang_NoClassDefFoundError == null) {
            throw EspressoError.fatal("NoClassDefFoundError during early startup: ", message);
        }
        throw meta.throwExceptionWithMessage(meta.java_lang_NoClassDefFoundError, message);
    }

    public final Tag tagAt(int index) {
        return this.at(index).tag();
    }

    public final int intAt(int index) {
        return this.intAt(index, null);
    }

    public final int intAt(int index, String description) {
        try {
            IntegerConstant constant = (IntegerConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.INTEGER);
        }
    }

    public final long longAt(int index) {
        return this.longAt(index, null);
    }

    public final long longAt(int index, String description) {
        try {
            LongConstant constant = (LongConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.LONG);
        }
    }

    public final float floatAt(int index) {
        return this.floatAt(index, null);
    }

    public final float floatAt(int index, String description) {
        try {
            FloatConstant constant = (FloatConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.FLOAT);
        }
    }

    public final double doubleAt(int index) {
        return this.doubleAt(index, null);
    }

    public final double doubleAt(int index, String description) {
        try {
            DoubleConstant constant = (DoubleConstant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.DOUBLE);
        }
    }

    public final <T> Symbol<T> symbolAt(int index) {
        return this.symbolAt(index, null);
    }

    public final <T> Symbol<T> symbolAt(int index, String description) {
        try {
            Utf8Constant constant = (Utf8Constant)this.at(index);
            return constant.value();
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.UTF8);
        }
    }

    public final Utf8Constant utf8At(int index) {
        return this.utf8At(index, null);
    }

    public final Utf8Constant utf8At(int index, String description) {
        try {
            return (Utf8Constant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.UTF8);
        }
    }

    public final Symbol<Symbol.ModifiedUTF8> stringAt(int index) {
        return this.stringAt(index, null);
    }

    public final Symbol<Symbol.ModifiedUTF8> stringAt(int index, String description) {
        try {
            StringConstant constant = (StringConstant)this.at(index);
            return constant.getSymbol(this);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.STRING);
        }
    }

    public final NameAndTypeConstant nameAndTypeAt(int index) {
        return this.nameAndTypeAt(index, null);
    }

    public final NameAndTypeConstant nameAndTypeAt(int index, String description) {
        try {
            return (NameAndTypeConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.NAME_AND_TYPE);
        }
    }

    public final ClassConstant classAt(int index) {
        return this.classAt(index, null);
    }

    public final ClassConstant classAt(int index, String description) {
        try {
            return (ClassConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.CLASS);
        }
    }

    public final MemberRefConstant memberAt(int index) {
        return this.memberAt(index, null);
    }

    public final MemberRefConstant memberAt(int index, String description) {
        try {
            return (MemberRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, description, Tag.METHOD_REF, Tag.INTERFACE_METHOD_REF, Tag.FIELD_REF);
        }
    }

    public final MethodRefConstant methodAt(int index) {
        try {
            return (MethodRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.METHOD_REF, Tag.INTERFACE_METHOD_REF);
        }
    }

    public final ClassMethodRefConstant classMethodAt(int index) {
        try {
            return (ClassMethodRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.METHOD_REF);
        }
    }

    public final InterfaceMethodRefConstant interfaceMethodAt(int index) {
        try {
            return (InterfaceMethodRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.INTERFACE_METHOD_REF);
        }
    }

    public final FieldRefConstant fieldAt(int index) {
        try {
            return (FieldRefConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.FIELD_REF);
        }
    }

    public final StringConstant stringConstantAt(int index) {
        try {
            return (StringConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.STRING);
        }
    }

    public final InvokeDynamicConstant indyAt(int index) {
        try {
            return (InvokeDynamicConstant)this.at(index);
        }
        catch (ClassCastException e) {
            throw this.unexpectedEntry(index, null, Tag.INVOKEDYNAMIC);
        }
    }

    public String toString() {
        Formatter buf = new Formatter();
        for (int i = 0; i < this.length(); ++i) {
            PoolConstant c = this.at(i);
            buf.format("#%d = %-15s // %s%n", new Object[]{i, c.tag(), c.toString(this)});
        }
        return buf.toString();
    }

    public static ConstantPool parse(ClassLoadingEnv env, ClassfileStream stream, ClassfileParser parser, int majorVersion, int minorVersion) {
        return ConstantPool.parse(env, stream, parser, null, majorVersion, minorVersion);
    }

    public static ConstantPool parse(ClassLoadingEnv env, ClassfileStream stream, ClassfileParser parser, StaticObject[] patches, int majorVersion, int minorVersion) {
        int length = stream.readU2();
        if (length < 1) {
            throw stream.classFormatError("Invalid constant pool size (" + length + ")", new Object[0]);
        }
        int rawPoolStartPosition = stream.getPosition();
        PoolConstant[] entries = new PoolConstant[length];
        entries[0] = InvalidConstant.VALUE;
        block21: for (int i = 1; i < length; ++i) {
            int tagByte = stream.readU1();
            Tag tag = Tag.fromValue(tagByte);
            if (tag == null) {
                throw ConstantPool.classFormatError("Invalid constant pool entry type at index " + i);
            }
            if (!tag.isValidForVersion(parser.getMajorVersion()) && tag != Tag.MODULE && tag != Tag.PACKAGE) {
                throw ConstantPool.classFormatError("Class file version does not support constant tag " + tagByte + " in class file");
            }
            switch (tag.ordinal()) {
                case 6: {
                    if (ConstantPool.existsAt(patches, i)) {
                        StaticObject classSpecifier = patches[i];
                        int index = stream.readU2();
                        if (index == 0 || index >= length) {
                            throw ConstantPool.classFormatError("Invalid Class constant index " + (i - 1));
                        }
                        if (classSpecifier.getKlass().getType() == Symbol.Type.java_lang_Class) {
                            entries[i] = ClassConstant.preResolved(classSpecifier.getMirrorKlass());
                            continue block21;
                        }
                        entries[i] = ClassConstant.withString(env.getNames().lookup(env.getMeta().toHostString(patches[i])));
                        continue block21;
                    }
                    int classNameIndex = stream.readU2();
                    entries[i] = ClassConstant.create(classNameIndex);
                    continue block21;
                }
                case 7: {
                    int index = stream.readU2();
                    if (index == 0 || index >= length) {
                        throw ConstantPool.classFormatError("Invalid String constant index " + (i - 1));
                    }
                    if (ConstantPool.existsAt(patches, i)) {
                        entries[i] = StringConstant.preResolved(patches[i]);
                        continue block21;
                    }
                    entries[i] = StringConstant.create(index);
                    continue block21;
                }
                case 8: {
                    int classIndex = stream.readU2();
                    int nameAndTypeIndex = stream.readU2();
                    entries[i] = FieldRefConstant.create(classIndex, nameAndTypeIndex);
                    continue block21;
                }
                case 9: {
                    int classIndex = stream.readU2();
                    int nameAndTypeIndex = stream.readU2();
                    entries[i] = ClassMethodRefConstant.create(classIndex, nameAndTypeIndex);
                    continue block21;
                }
                case 10: {
                    int classIndex = stream.readU2();
                    int nameAndTypeIndex = stream.readU2();
                    entries[i] = InterfaceMethodRefConstant.create(classIndex, nameAndTypeIndex);
                    continue block21;
                }
                case 11: {
                    int nameIndex = stream.readU2();
                    int typeIndex = stream.readU2();
                    entries[i] = NameAndTypeConstant.create(nameIndex, typeIndex);
                    continue block21;
                }
                case 2: {
                    if (ConstantPool.existsAt(patches, i)) {
                        entries[i] = IntegerConstant.create(env.getMeta().unboxInteger(patches[i]));
                        stream.readS4();
                        continue block21;
                    }
                    entries[i] = IntegerConstant.create(stream.readS4());
                    continue block21;
                }
                case 3: {
                    if (ConstantPool.existsAt(patches, i)) {
                        entries[i] = FloatConstant.create(env.getMeta().unboxFloat(patches[i]));
                        stream.readFloat();
                        continue block21;
                    }
                    entries[i] = FloatConstant.create(stream.readFloat());
                    continue block21;
                }
                case 4: {
                    if (ConstantPool.existsAt(patches, i)) {
                        entries[i] = LongConstant.create(env.getMeta().unboxLong(patches[i]));
                        stream.readS8();
                    } else {
                        entries[i] = LongConstant.create(stream.readS8());
                    }
                    ++i;
                    try {
                        entries[i] = InvalidConstant.VALUE;
                        continue block21;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ConstantPool.classFormatError("Invalid long constant index " + (i - 1));
                    }
                }
                case 5: {
                    if (ConstantPool.existsAt(patches, i)) {
                        entries[i] = DoubleConstant.create(env.getMeta().unboxDouble(patches[i]));
                        stream.readDouble();
                    } else {
                        entries[i] = DoubleConstant.create(stream.readDouble());
                    }
                    ++i;
                    try {
                        entries[i] = InvalidConstant.VALUE;
                        continue block21;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ConstantPool.classFormatError("Invalid double constant index " + (i - 1));
                    }
                }
                case 1: {
                    UTF8_ENTRY_COUNT.inc();
                    ByteSequence bytes = stream.readByteSequenceUTF();
                    entries[i] = env.getLanguage().getUtf8ConstantTable().getOrCreate(bytes);
                    continue block21;
                }
                case 12: {
                    parser.checkInvokeDynamicSupport(tag);
                    int refKind = stream.readU1();
                    int refIndex = stream.readU2();
                    entries[i] = MethodHandleConstant.create(refKind, refIndex);
                    continue block21;
                }
                case 13: {
                    parser.checkInvokeDynamicSupport(tag);
                    entries[i] = MethodTypeConstant.create(stream.readU2());
                    continue block21;
                }
                case 14: {
                    parser.checkDynamicConstantSupport(tag);
                    int bootstrapMethodAttrIndex = stream.readU2();
                    int nameAndTypeIndex = stream.readU2();
                    entries[i] = DynamicConstant.create(bootstrapMethodAttrIndex, nameAndTypeIndex);
                    parser.updateMaxBootstrapMethodAttrIndex(bootstrapMethodAttrIndex);
                    continue block21;
                }
                case 15: {
                    parser.checkInvokeDynamicSupport(tag);
                    int bootstrapMethodAttrIndex = stream.readU2();
                    int nameAndTypeIndex = stream.readU2();
                    entries[i] = InvokeDynamicConstant.create(bootstrapMethodAttrIndex, nameAndTypeIndex);
                    parser.updateMaxBootstrapMethodAttrIndex(bootstrapMethodAttrIndex);
                    continue block21;
                }
                default: {
                    parser.handleBadConstant(tag, stream);
                }
            }
        }
        int rawPoolLength = stream.getPosition() - rawPoolStartPosition;
        ConstantPoolImpl constantPool = new ConstantPoolImpl(entries, majorVersion, minorVersion, rawPoolLength);
        if (parser.hasSeenBadConstant()) {
            return constantPool;
        }
        assert (patches != null || ConstantPool.sameRawPool(constantPool, stream, rawPoolStartPosition, rawPoolLength));
        for (int j = 1; j < ((ConstantPool)constantPool).length(); ++j) {
            entries[j].validate(constantPool);
        }
        return constantPool;
    }

    private static boolean sameRawPool(ConstantPool constantPool, ClassfileStream stream, int rawPoolStartPosition, int rawPoolLength) {
        return Arrays.equals(constantPool.getRawBytes(), stream.getByteRange(rawPoolStartPosition, rawPoolLength));
    }

    private static boolean existsAt(StaticObject[] patches, int index) {
        return patches != null && 0 <= index && index < patches.length && StaticObject.notNull(patches[index]);
    }

    ConstantPool patchForHiddenClass(int thisKlassIndex, Symbol<?> newName) {
        return this;
    }

    public static final class Tag
    extends Enum<Tag> {
        public static final /* enum */ Tag INVALID = new Tag(0);
        public static final /* enum */ Tag UTF8 = new Tag(1);
        public static final /* enum */ Tag INTEGER = new Tag(3, true);
        public static final /* enum */ Tag FLOAT = new Tag(4, true);
        public static final /* enum */ Tag LONG = new Tag(5, true);
        public static final /* enum */ Tag DOUBLE = new Tag(6, true);
        public static final /* enum */ Tag CLASS = new Tag(7, true);
        public static final /* enum */ Tag STRING = new Tag(8, true);
        public static final /* enum */ Tag FIELD_REF = new Tag(9);
        public static final /* enum */ Tag METHOD_REF = new Tag(10);
        public static final /* enum */ Tag INTERFACE_METHOD_REF = new Tag(11);
        public static final /* enum */ Tag NAME_AND_TYPE = new Tag(12);
        public static final /* enum */ Tag METHODHANDLE = new Tag(15, true);
        public static final /* enum */ Tag METHODTYPE = new Tag(16, true);
        public static final /* enum */ Tag DYNAMIC = new Tag(17, true);
        public static final /* enum */ Tag INVOKEDYNAMIC = new Tag(18);
        public static final /* enum */ Tag MODULE = new Tag(19);
        public static final /* enum */ Tag PACKAGE = new Tag(20);
        private final byte value;
        private final boolean loadable;
        public static final List<Tag> VALUES;
        private static final /* synthetic */ Tag[] $VALUES;

        public static Tag[] values() {
            return (Tag[])$VALUES.clone();
        }

        public static Tag valueOf(String name) {
            return Enum.valueOf(Tag.class, name);
        }

        private Tag(int value) {
            this(value, false);
        }

        private Tag(int value, boolean isLoadable) {
            assert ((byte)value == value);
            this.value = (byte)value;
            this.loadable = isLoadable;
        }

        public final int getValue() {
            return this.value;
        }

        public final boolean isLoadable() {
            return this.loadable;
        }

        public static Tag fromValue(int value) {
            switch (value) {
                case 1: {
                    return UTF8;
                }
                case 3: {
                    return INTEGER;
                }
                case 4: {
                    return FLOAT;
                }
                case 5: {
                    return LONG;
                }
                case 6: {
                    return DOUBLE;
                }
                case 7: {
                    return CLASS;
                }
                case 8: {
                    return STRING;
                }
                case 9: {
                    return FIELD_REF;
                }
                case 10: {
                    return METHOD_REF;
                }
                case 11: {
                    return INTERFACE_METHOD_REF;
                }
                case 12: {
                    return NAME_AND_TYPE;
                }
                case 15: {
                    return METHODHANDLE;
                }
                case 16: {
                    return METHODTYPE;
                }
                case 17: {
                    return DYNAMIC;
                }
                case 18: {
                    return INVOKEDYNAMIC;
                }
                case 19: {
                    return MODULE;
                }
                case 20: {
                    return PACKAGE;
                }
            }
            return null;
        }

        public boolean isValidForVersion(int major) {
            switch (this.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return major >= 45;
                }
                case 12: 
                case 13: 
                case 15: {
                    return major >= 51;
                }
                case 14: {
                    return major >= 55;
                }
                case 16: 
                case 17: {
                    return major >= 53;
                }
            }
            throw EspressoError.shouldNotReachHere("Cannot validate tag version for" + String.valueOf((Object)this));
        }

        private static /* synthetic */ Tag[] $values() {
            return new Tag[]{INVALID, UTF8, INTEGER, FLOAT, LONG, DOUBLE, CLASS, STRING, FIELD_REF, METHOD_REF, INTERFACE_METHOD_REF, NAME_AND_TYPE, METHODHANDLE, METHODTYPE, DYNAMIC, INVOKEDYNAMIC, MODULE, PACKAGE};
        }

        static {
            $VALUES = Tag.$values();
            VALUES = Collections.unmodifiableList(Arrays.asList(Tag.values()));
        }
    }
}

