/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.blocking;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.blocking.BlockingSupport;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.invoke.VarHandle;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class EspressoLockImpl
extends ReentrantLock
implements EspressoLock {
    private static final Node dummy = new Node(){

        public boolean isAdoptable() {
            return false;
        }
    };
    private final BlockingSupport<?> blockingSupport;
    private ReentrantLock waitLock;
    private Condition waitCondition;
    private int waiters = 0;
    private int signals = 0;

    EspressoLockImpl(BlockingSupport<?> blockingSupport) {
        assert (blockingSupport != null);
        this.blockingSupport = blockingSupport;
    }

    private void ensureWaitLockInitialized() {
        assert (this.isHeldByCurrentThread());
        if (this.waitLock == null) {
            ReentrantLock lock = new ReentrantLock();
            Condition cond = lock.newCondition();
            VarHandle.storeStoreFence();
            this.waitLock = lock;
            this.waitCondition = cond;
        } else assert (this.waitCondition != null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void lock() {
        if (this.tryLock()) {
            return;
        }
        TruffleSafepoint.setBlockedThreadInterruptible((Node)dummy, EspressoLockImpl::doLock, (Object)this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void unlock() {
        super.unlock();
    }

    @Override
    public void lockInterruptible() throws GuestInterruptedException {
        if (this.tryLock()) {
            return;
        }
        this.blockingSupport.enterBlockingRegion(EspressoLockImpl::doLock, dummy, this);
    }

    @Override
    @Deprecated
    public void lockInterruptibly() {
        throw new UnsupportedOperationException("lockInterruptibly unsupported for EspressoLock. Use lockInterruptible instead.");
    }

    @Override
    public boolean await(long timeout, TimeUnit unit, StaticObject thread, StaticObject obj) throws GuestInterruptedException {
        assert (thread == null == (obj == null));
        assert (thread == null || StaticObject.notNull(thread));
        assert (obj == null || StaticObject.notNull(obj));
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitInterruptible interruptible = new WaitInterruptible(timeout, unit, thread, obj);
        this.enterWaitInterruptible(interruptible);
        return interruptible.getResult();
    }

    @Override
    public boolean awaitUntil(Date deadline) throws GuestInterruptedException {
        if (!this.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitUntilInterruptible interruptible = new WaitUntilInterruptible(deadline);
        this.enterWaitInterruptible(interruptible);
        return interruptible.getResult();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void signal() {
        if (!this.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Cannot signal lock that is not held");
        }
        this.ensureWaitLockInitialized();
        this.waitLock.lock();
        try {
            this.signals = Math.min(this.signals + 1, this.waiters);
            this.waitCondition.signal();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void signalAll() {
        if (!this.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Cannot signal lock that is not held");
        }
        this.ensureWaitLockInitialized();
        this.waitLock.lock();
        try {
            this.signals = this.waiters;
            this.waitCondition.signalAll();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    @Override
    public Thread getOwnerThread() {
        return this.getOwner();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEntryCount() {
        return this.getHoldCount();
    }

    @CompilerDirectives.TruffleBoundary
    private void doLock() throws InterruptedException {
        if (!this.tryLock()) {
            super.lockInterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK"}, justification="this lock is released at the start of the method and re-acquired at the end")
    private void enterWaitInterruptible(InterruptibleWithBooleanResult<EspressoLockImpl> interruptible) throws GuestInterruptedException {
        boolean enableManagement;
        Meta meta;
        this.ensureWaitLockInitialized();
        if (interruptible.thread != null) {
            meta = interruptible.thread.getKlass().getMeta();
            enableManagement = interruptible.thread.getKlass().getContext().getEspressoEnv().EnableManagement;
        } else {
            meta = null;
            enableManagement = false;
        }
        this.waitLock.lock();
        ++this.waiters;
        int holdCount = 0;
        try {
            if (enableManagement) {
                meta.HIDDEN_THREAD_WAITING_MONITOR.setHiddenObject(interruptible.thread, interruptible.obj);
            }
            while (this.isHeldByCurrentThread()) {
                this.unlock();
                ++holdCount;
            }
            this.blockingSupport.enterBlockingRegion(interruptible, dummy, this, this.waitLock::unlock, this::afterSafepointForWait);
        }
        catch (Signaled e) {
            e.maybeRethrow();
        }
        catch (Throwable e) {
            this.consumeSignal();
            throw e;
        }
        finally {
            if (enableManagement) {
                meta.HIDDEN_THREAD_WAITING_MONITOR.setHiddenObject(interruptible.thread, StaticObject.NULL);
            }
            this.waitLock.unlock();
            if (!this.tryLock()) {
                if (enableManagement) {
                    meta.HIDDEN_THREAD_PENDING_MONITOR.setHiddenObject(interruptible.thread, interruptible.obj);
                }
                try {
                    this.lock();
                }
                finally {
                    if (enableManagement) {
                        meta.HIDDEN_THREAD_PENDING_MONITOR.setHiddenObject(interruptible.thread, null);
                    }
                }
            }
            for (int i = 1; i < holdCount; ++i) {
                this.lock();
            }
            --this.waiters;
        }
    }

    private boolean consumeSignal() {
        assert (this.waitLock.isHeldByCurrentThread());
        if (this.signals > 0) {
            --this.signals;
            return true;
        }
        return false;
    }

    private void afterSafepointForWait(Throwable t) {
        this.waitLock.lock();
        if (this.consumeSignal()) {
            throw new Signaled(t);
        }
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
        throw ex;
    }

    private static final class WaitInterruptible
    extends InterruptibleWithBooleanResult<EspressoLockImpl> {
        private final long nanoTimeout;
        private final long start;

        WaitInterruptible(long timeout, TimeUnit unit, StaticObject thread, StaticObject obj) {
            super(thread, obj);
            this.nanoTimeout = unit.toNanos(timeout);
            this.start = System.nanoTime();
            this.setResult(true);
        }

        @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="Espresso lock runtime method.")
        public void apply(EspressoLockImpl lock) throws InterruptedException {
            if (this.nanoTimeout == 0L) {
                lock.waitCondition.await();
            } else {
                long left = this.nanoTimeout - (System.nanoTime() - this.start);
                if (left <= 0L) {
                    return;
                }
                this.setResult(lock.waitCondition.await(left, TimeUnit.NANOSECONDS));
            }
        }
    }

    private static abstract class InterruptibleWithBooleanResult<T>
    implements TruffleSafepoint.Interruptible<T> {
        private final StaticObject thread;
        private final StaticObject obj;
        private boolean result;

        InterruptibleWithBooleanResult(StaticObject thread, StaticObject obj) {
            this.thread = thread;
            this.obj = obj;
        }

        public final boolean getResult() {
            return this.result;
        }

        public final void setResult(boolean result) {
            this.result = result;
        }
    }

    private static final class WaitUntilInterruptible
    extends InterruptibleWithBooleanResult<EspressoLockImpl> {
        private final Date date;

        WaitUntilInterruptible(Date date) {
            super(null, null);
            this.date = date;
            this.setResult(true);
        }

        @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="Espresso lock runtime method.")
        public void apply(EspressoLockImpl lock) throws InterruptedException {
            this.setResult(lock.waitCondition.awaitUntil(this.date));
        }
    }

    private static final class Signaled
    extends RuntimeException {
        private static final long serialVersionUID = 8504030520147416891L;
        private final Throwable safepointThrown;

        Signaled(Throwable t) {
            this.safepointThrown = t;
        }

        void maybeRethrow() {
            if (this.safepointThrown != null) {
                throw EspressoLockImpl.sneakyThrow(this.safepointThrown);
            }
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

