/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis;

import com.oracle.truffle.espresso.analysis.AnalysisProcessor;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class Util {
    private Util() {
    }

    public static int[] toIntArray(List<Integer> targets) {
        int[] result = new int[targets.size()];
        int pos = 0;
        for (int i : targets) {
            result[pos++] = i;
        }
        return result;
    }

    public static BitSet mergeBitSets(BitSet[] lives, int size) {
        BitSet merges = new BitSet(size);
        for (BitSet live : lives) {
            merges.or(live);
        }
        return merges;
    }

    public static BitSet mergeBitSets(Iterable<BitSet> lives, int size) {
        BitSet merges = new BitSet(size);
        for (BitSet live : lives) {
            merges.or(live);
        }
        return merges;
    }

    public static boolean successorsAreDoneOrLoops(AnalysisProcessor processor, LinkedBlock b) {
        for (int succ : b.successorsID()) {
            if (processor.isDone(succ) || processor.isInProcess(succ)) continue;
            return false;
        }
        return true;
    }

    public static Iterable<Integer> bitSetSetIterator(BitSet bs) {
        return new BitSetSetIterator(bs);
    }

    public static Iterable<Integer> bitSetUnsetIterator(BitSet bs, int maxLocal) {
        return new BitSetUnsetIterator(bs, maxLocal);
    }

    public static boolean assertNoDupe(int[] array) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : array) {
            if (set.contains(i)) {
                return false;
            }
            set.add(i);
        }
        return true;
    }

    private static final class BitSetSetIterator
    extends BitSetIterator {
        BitSetSetIterator(BitSet bs) {
            super(bs);
        }

        @Override
        protected boolean nextIsValid(int next) {
            return next >= 0;
        }

        @Override
        protected Integer nextBit(BitSet set, int from) {
            return set.nextSetBit(from + 1);
        }
    }

    private static final class BitSetUnsetIterator
    extends BitSetIterator {
        private final int maxLocal;

        BitSetUnsetIterator(BitSet bs, int maxLocal) {
            super(bs);
            this.maxLocal = maxLocal;
        }

        @Override
        protected boolean nextIsValid(int next) {
            return next < this.maxLocal;
        }

        @Override
        protected Integer nextBit(BitSet set, int from) {
            return set.nextClearBit(from + 1);
        }
    }

    private static abstract class BitSetIterator
    implements Iterable<Integer>,
    Iterator<Integer> {
        private final BitSet bs;
        private int pos = -1;
        private int nextPos = -1;
        private boolean nextAvailable = false;

        private BitSetIterator(BitSet bs) {
            this.bs = bs;
        }

        @Override
        public final Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public final boolean hasNext() {
            if (!this.nextAvailable) {
                this.nextAvailable = true;
                this.nextPos = this.nextBit(this.bs, this.pos);
                return this.nextIsValid(this.nextPos);
            }
            return this.nextIsValid(this.nextPos);
        }

        @Override
        public final Integer next() {
            if (!this.nextAvailable) {
                this.nextPos = this.nextBit(this.bs, this.pos);
                assert (this.nextIsValid(this.nextPos)) : "No hasNext() called.";
            }
            this.pos = this.nextPos;
            this.nextAvailable = false;
            return this.pos;
        }

        protected abstract boolean nextIsValid(int var1);

        protected abstract Integer nextBit(BitSet var1, int var2);
    }
}

