/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis;

import com.oracle.truffle.espresso.analysis.Util;
import com.oracle.truffle.espresso.analysis.graph.Block;
import com.oracle.truffle.espresso.analysis.graph.EspressoBlock;
import com.oracle.truffle.espresso.analysis.graph.EspressoBlockWithHandlers;
import com.oracle.truffle.espresso.analysis.graph.EspressoExecutionGraph;
import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.bytecode.BytecodeLookupSwitch;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.bytecode.BytecodeSwitch;
import com.oracle.truffle.espresso.bytecode.BytecodeTableSwitch;
import com.oracle.truffle.espresso.bytecode.Bytecodes;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.ExceptionHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class GraphBuilder {
    private static final long BLOCK_START = Long.MIN_VALUE;
    private static final long ONLY_TARGET = 0x4000000000000000L;
    private static final long SWITCH = 0x2000000000000000L;
    private static final long HAS_TARGET = 0x1000000000000000L;
    private static final long HAS_BLOCK = 0x800000000000000L;
    private static final long IS_CONTROL_SINK = 0x400000000000000L;
    private static final long IS_JSR = 0x200000000000000L;
    private static final long IS_RET = 0x100000000000000L;
    private static final long TRAPS = 0x80000000000000L;
    private static final int BLOCK_ID_SHIFT = 16;
    private static final long BLOCK_ID_MASK = 0xFFFF0000L;
    private static final long TARGET_MASK = 65535L;
    private final long[] status;
    private static final int[] EMPTY_SUCCESSORS = new int[0];
    private final BytecodeStream bs;
    private final ExceptionHandler[] handlers;
    private final List<int[]> switchTable = new ArrayList<int[]>();
    private final List<JsrMarker> jsrTable = new ArrayList<JsrMarker>();
    private int[] returnTable;
    private int[] handlerToBlock;
    private TemporaryBlock[] temporaryBlocks;
    private int nBlocks;

    public static Graph<? extends LinkedBlock> build(Method method) {
        return new GraphBuilder(method).build();
    }

    private GraphBuilder(Method method) {
        this.bs = new BytecodeStream(method.getOriginalCode());
        this.status = new long[this.bs.endBCI()];
        this.handlers = method.getExceptionHandlers();
    }

    private EspressoExecutionGraph build() {
        this.identifyBlock();
        this.assignIds();
        this.freezeReturnTable();
        this.spawnBlocks();
        this.registerHandlers();
        this.registerPredecessors();
        return this.promote();
    }

    private void identifyBlock() {
        int bci = 0;
        this.status[bci] = Long.MIN_VALUE;
        while (bci < this.bs.endBCI()) {
            int curOpcode = this.bs.currentBC(bci);
            if (Bytecodes.isBlockEnd(curOpcode)) {
                this.markBlock(bci, curOpcode);
            }
            bci = this.bs.nextBCI(bci);
        }
        for (ExceptionHandler handler : this.handlers) {
            this.markHandler(handler);
        }
    }

    private void assignIds() {
        int id = 0;
        for (int bci = 0; bci < this.status.length; ++bci) {
            if (!this.isStatus(bci, Long.MIN_VALUE)) continue;
            this.setBlockID(bci, id++);
        }
        this.nBlocks = id;
    }

    private void spawnBlocks() {
        TemporaryBlock[] temp = new TemporaryBlock[this.nBlocks];
        int id = 0;
        int start = 0;
        int[] successors = null;
        boolean isRet = false;
        boolean traps = false;
        int bci = 0;
        int last = 0;
        while (bci < this.status.length) {
            if (bci != 0 && this.isStatus(bci, Long.MIN_VALUE)) {
                assert (temp[id] == null);
                assert (id == this.readBlockID(start));
                temp[id] = GraphBuilder.createTempBlock(id, start, successors, isRet, bci, last, traps);
                start = bci;
                ++id;
                successors = null;
                isRet = false;
                traps = false;
            }
            if (this.isStatus(bci, 0x100000000000000L)) {
                assert (successors == null);
                isRet = true;
                successors = this.returnTable;
            }
            if (this.isStatus(bci, 0x80000000000000L)) {
                traps = true;
            }
            if (this.isStatus(bci, 0x1000000000000000L)) {
                assert (successors == null);
                successors = this.findSuccessors(bci, id);
            }
            if (this.isStatus(bci, 0x400000000000000L)) {
                assert (successors == null);
                successors = EMPTY_SUCCESSORS;
            }
            last = bci;
            if ((bci = this.bs.nextBCI(bci)) < this.status.length || successors != null) continue;
            successors = EMPTY_SUCCESSORS;
        }
        temp[id] = GraphBuilder.createTempBlock(id, start, successors, isRet, this.status.length, last, traps);
        this.temporaryBlocks = temp;
        int[] handlerBlocks = new int[this.handlers.length];
        int pos = 0;
        for (ExceptionHandler handler : this.handlers) {
            handlerBlocks[pos++] = this.readBlockID(handler.getHandlerBCI());
        }
        this.handlerToBlock = handlerBlocks;
    }

    private static TemporaryBlock createTempBlock(int id, int start, int[] successors, boolean isRet, int bci, int last, boolean traps) {
        return new TemporaryBlock(id, start, bci - 1, last, successors, isRet, traps);
    }

    private void registerHandlers() {
        for (int hPos = 0; hPos < this.handlers.length; ++hPos) {
            ExceptionHandler handler = this.handlers[hPos];
            int currentBlock = this.readBlockID(handler.getStartBCI());
            do {
                this.temporaryBlocks[currentBlock].registerHandler(hPos, this);
            } while (++currentBlock < this.nBlocks && this.temporaryBlocks[currentBlock].end() < handler.getEndBCI());
        }
    }

    private void freezeReturnTable() {
        if (!this.jsrTable.isEmpty()) {
            this.returnTable = new int[this.jsrTable.size()];
            int pos = 0;
            for (JsrMarker marker : this.jsrTable) {
                int id = this.readBlockID(marker.returnAddress);
                this.returnTable[pos++] = id;
            }
        }
    }

    private void registerPredecessors() {
        for (int id = 0; id < this.temporaryBlocks.length; ++id) {
            TemporaryBlock b = this.temporaryBlocks[id];
            for (int successor : b.successors(this)) {
                this.temporaryBlocks[successor].registerPredecessor(id);
            }
        }
    }

    private EspressoExecutionGraph promote() {
        EspressoBlock[] blocks = new EspressoBlock[this.temporaryBlocks.length];
        EspressoExecutionGraph graph = new EspressoExecutionGraph(this.handlers, this.handlerToBlock, blocks);
        for (int i = 0; i < this.temporaryBlocks.length; ++i) {
            blocks[i] = this.temporaryBlocks[i].promote(this, graph);
        }
        return graph;
    }

    private int[] findSuccessors(int bci, int id) {
        assert (this.isStatus(bci, 0x1000000000000000L));
        if (this.isStatus(bci, 0x2000000000000000L)) {
            int switchHandler = this.readTarget(bci);
            int[] targets = this.switchTable.get(switchHandler);
            int[] result = new int[targets.length];
            int pos = 0;
            for (int target : targets) {
                result[pos++] = this.readBlockID(target);
            }
            return result;
        }
        int branchID = this.readBlockID(this.readTarget(bci));
        if (this.isStatus(bci, 0x4000000000000000L) || id + 1 >= this.nBlocks) {
            return new int[]{branchID};
        }
        int nextId = id + 1;
        if (branchID == nextId) {
            return new int[]{branchID};
        }
        return new int[]{nextId, branchID};
    }

    private void markBlock(int bci, int opcode) {
        if (Bytecodes.isReturn((byte)opcode) || opcode == 191) {
            this.markSink(bci);
        } else if (Bytecodes.isBranch(opcode)) {
            this.markBranch(bci);
            if (GraphBuilder.isJSR(opcode)) {
                this.markJsr(bci);
            }
            if (Bytecodes.isStop(opcode)) {
                this.markGoto(bci);
            }
        } else if (GraphBuilder.isSwitch(opcode)) {
            this.markSwitch(bci, opcode);
        } else if (GraphBuilder.isRet(opcode)) {
            this.markRet(bci);
        }
    }

    private void markSink(int bci) {
        this.mark(bci, 0x400000000000000L);
        int next = this.bs.nextBCI(bci);
        if (next < this.bs.endBCI()) {
            this.mark(next, Long.MIN_VALUE);
        }
    }

    private void markBranch(int bci) {
        int target = this.bs.readBranchDest(bci);
        this.mark(target, Long.MIN_VALUE);
        this.markTarget(bci, target);
        int next = this.bs.nextBCI(bci);
        if (next < this.bs.endBCI()) {
            this.mark(next, Long.MIN_VALUE);
        }
    }

    private void markSwitch(int bci, int opcode) {
        BytecodeSwitch helper;
        if (opcode == 170) {
            helper = BytecodeTableSwitch.INSTANCE;
        } else {
            assert (opcode == 171);
            helper = BytecodeLookupSwitch.INSTANCE;
        }
        ArrayList<Integer> targets = new ArrayList<Integer>();
        this.mark(bci, 0x2000000000000000L);
        this.markTarget(bci, this.switchTable.size());
        BitSet present = new BitSet();
        for (int i = 0; i < helper.numberOfCases(this.bs, bci); ++i) {
            int target = helper.targetAt(this.bs, bci, i);
            if (!present.get(target)) {
                targets.add(target);
                present.set(target);
            }
            this.mark(target, Long.MIN_VALUE);
        }
        int defaultTarget = helper.defaultTarget(this.bs, bci);
        if (!present.get(defaultTarget)) {
            targets.add(defaultTarget);
        }
        this.mark(defaultTarget, Long.MIN_VALUE);
        this.switchTable.add(Util.toIntArray(targets));
        int next = this.bs.nextBCI(bci);
        if (next < this.bs.endBCI()) {
            this.mark(next, Long.MIN_VALUE);
        }
    }

    private void markJsr(int bci) {
        this.mark(bci, 0x200000000000000L);
        int target = this.bs.readBranchDest(bci);
        int returnAddress = this.bs.nextBCI(bci);
        this.jsrTable.add(new JsrMarker(target, returnAddress));
    }

    private void markRet(int bci) {
        this.mark(bci, 0x100000000000000L);
        int next = this.bs.nextBCI(bci);
        if (next < this.bs.endBCI()) {
            this.mark(next, Long.MIN_VALUE);
        }
    }

    private void markGoto(int bci) {
        this.mark(bci, 0x4000000000000000L);
    }

    private void markHandler(ExceptionHandler handler) {
        this.mark(handler.getStartBCI(), Long.MIN_VALUE);
        int afterEnd = handler.getEndBCI();
        if (afterEnd < this.bs.endBCI()) {
            this.mark(afterEnd, Long.MIN_VALUE);
        }
        int bci = handler.getStartBCI();
        while (bci < handler.getEndBCI()) {
            int nextBCI = this.bs.nextBCI(bci);
            if (Bytecodes.canTrap(this.bs.currentBC(bci))) {
                this.mark(bci, Long.MIN_VALUE);
                this.mark(bci, 0x80000000000000L);
                if (nextBCI < this.bs.endBCI()) {
                    this.mark(nextBCI, Long.MIN_VALUE);
                }
            }
            bci = nextBCI;
        }
        this.mark(handler.getHandlerBCI(), Long.MIN_VALUE);
    }

    private void mark(int bci, long state) {
        int n = bci;
        this.status[n] = this.status[n] | state;
    }

    private void markTarget(int bci, int targetBCI) {
        this.mark(bci, 0x1000000000000000L | (long)targetBCI & 0xFFFFL);
    }

    private void setBlockID(int bci, int id) {
        this.mark(bci, (long)(id << 16) & 0xFFFF0000L | 0x800000000000000L);
    }

    private boolean isStatus(int bci, long state) {
        return (this.status[bci] & state) != 0L;
    }

    private int readTarget(int bci) {
        assert (this.isStatus(bci, 0x1000000000000000L));
        return (int)(this.status[bci] & 0xFFFFL);
    }

    private int readBlockID(int bci) {
        assert (this.isStatus(bci, 0x800000000000000L));
        return (int)((this.status[bci] & 0xFFFF0000L) >> 16);
    }

    private static boolean isSwitch(int opcode) {
        return opcode == 171 || opcode == 170;
    }

    private static boolean isJSR(int opcode) {
        return opcode == 168 || opcode == 201;
    }

    private static boolean isRet(int opcode) {
        return opcode == 169;
    }

    private static int[] merge(int totalBlocks, int[] successors, List<Integer> list) {
        ArrayList<Integer> fullyLinkedSuccessors = new ArrayList<Integer>();
        BitSet present = new BitSet(totalBlocks);
        for (int i = 0; i < successors.length; ++i) {
            int id = successors[i];
            present.set(id);
            fullyLinkedSuccessors.add(id);
        }
        for (int i : list) {
            if (present.get(i)) continue;
            fullyLinkedSuccessors.add(i);
            present.set(i);
        }
        return Util.toIntArray(fullyLinkedSuccessors);
    }

    private static final class TemporaryBlock
    implements Block {
        private final int id;
        private final int start;
        private final int end;
        private final int last;
        private final int[] successors;
        private final boolean isRet;
        private final boolean traps;
        private final ArrayList<Integer> handlers = new ArrayList();
        private final ArrayList<Integer> handlerBlocks = new ArrayList();
        private final ArrayList<Integer> predecessors = new ArrayList();
        private int[] fullyLinkedSuccessors = null;

        TemporaryBlock(int id, int start, int end, int last, int[] successors, boolean isRet, boolean traps) {
            this.id = id;
            this.start = start;
            this.end = end;
            this.last = last;
            this.successors = successors != null ? successors : new int[]{id + 1};
            this.isRet = isRet;
            this.traps = traps;
            assert (Util.assertNoDupe(this.successors));
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public int lastBCI() {
            return this.last;
        }

        @Override
        public int id() {
            return this.id;
        }

        void registerHandler(int handlerPos, GraphBuilder builder) {
            if (this.traps) {
                this.handlers.add(handlerPos);
                this.handlerBlocks.add(builder.handlerToBlock[handlerPos]);
            }
        }

        void registerPredecessor(int predecessor) {
            this.predecessors.add(predecessor);
        }

        EspressoBlock promote(GraphBuilder builder, EspressoExecutionGraph graph) {
            if (this.successors.length == 0 && this.handlers.isEmpty() && !this.isRet) {
                return new EspressoBlock(graph, this.id, this.start, this.end, this.last, EspressoBlock.EMPTY_ID_ARRAY, Util.toIntArray(this.predecessors));
            }
            if (this.handlers.isEmpty()) {
                return new EspressoBlock(graph, this.id, this.start, this.end, this.last, this.successors(builder), Util.toIntArray(this.predecessors));
            }
            return new EspressoBlockWithHandlers(graph, this.id, this.start, this.end, this.last, this.successors(builder), Util.toIntArray(this.handlers), Util.toIntArray(this.predecessors));
        }

        private int[] successors(GraphBuilder builder) {
            if (this.fullyLinkedSuccessors == null) {
                this.fullyLinkedSuccessors = this.successors.length == 0 && this.handlers.isEmpty() ? EspressoBlock.EMPTY_ID_ARRAY : (this.handlers.isEmpty() ? this.successors : GraphBuilder.merge(builder.nBlocks, this.successors, this.handlerBlocks));
            }
            return this.fullyLinkedSuccessors;
        }
    }

    private static final class JsrMarker {
        private final int target;
        private final int returnAddress;

        private JsrMarker(int target, int returnAddress) {
            this.target = target;
            this.returnAddress = returnAddress;
        }
    }
}

