/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.analysis;

import com.oracle.truffle.espresso.analysis.AnalysisProcessor;
import com.oracle.truffle.espresso.analysis.BlockIteratorClosure;
import com.oracle.truffle.espresso.analysis.BlockStack;
import com.oracle.truffle.espresso.analysis.GraphBuilder;
import com.oracle.truffle.espresso.analysis.graph.Graph;
import com.oracle.truffle.espresso.analysis.graph.LinkedBlock;
import com.oracle.truffle.espresso.bytecode.BytecodeStream;
import com.oracle.truffle.espresso.impl.Method;
import java.util.BitSet;

public class BlockIterator
implements AnalysisProcessor {
    private final BytecodeStream bs;
    protected final Graph<? extends LinkedBlock> graph;
    private final BitSet enqueued;
    protected final BitSet done;
    protected final BlockStack stack = new BlockStack();
    protected final BlockIteratorClosure closure;

    public static void analyze(Method method, Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        new BlockIterator(method, graph, closure).analyze();
    }

    public static void analyze(Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        new BlockIterator(graph, closure).analyze();
    }

    protected BlockIterator(Method m, Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        assert (m.getCodeAttribute() != null);
        this.bs = new BytecodeStream(m.getOriginalCode());
        this.graph = graph == null ? GraphBuilder.build(m) : graph;
        this.enqueued = new BitSet(this.graph.totalBlocks());
        this.done = new BitSet(this.graph.totalBlocks());
        this.closure = closure;
    }

    protected BlockIterator(Graph<? extends LinkedBlock> graph, BlockIteratorClosure closure) {
        assert (graph != null);
        this.bs = null;
        this.graph = graph;
        this.enqueued = new BitSet(graph.totalBlocks());
        this.done = new BitSet(graph.totalBlocks());
        this.closure = closure;
    }

    protected final void analyze() {
        this.push(this.closure.getEntry(this.graph));
        while (!this.stack.isEmpty()) {
            LinkedBlock b = this.peek();
            BlockProcessResult result = this.closure.processBlock(b, this.bs, this);
            this.processResult(b, result);
        }
    }

    protected void processResult(LinkedBlock b, BlockProcessResult result) {
        if (result == BlockProcessResult.DONE) {
            this.done.set(b.id());
            this.pop();
        }
        for (int id : this.closure.getSuccessors(b)) {
            this.push(this.graph.get(id));
        }
    }

    protected final boolean push(LinkedBlock block) {
        if (this.isEnqueued(block) || this.isDone(block)) {
            return false;
        }
        this.enqueued.set(block.id());
        this.stack.push(block);
        return true;
    }

    protected final LinkedBlock pop() {
        LinkedBlock res = this.stack.pop();
        assert (this.isEnqueued(res));
        this.enqueued.clear(res.id());
        return res;
    }

    protected final LinkedBlock peek() {
        return this.stack.peek();
    }

    private boolean isDone(LinkedBlock block) {
        return this.isDone(block.id());
    }

    @Override
    public final boolean isDone(int blockID) {
        return this.done.get(blockID);
    }

    @Override
    public final boolean isInProcess(int blockID) {
        return this.enqueued.get(blockID);
    }

    @Override
    public final LinkedBlock idToBlock(int id) {
        return this.graph.get(id);
    }

    private boolean isEnqueued(LinkedBlock block) {
        return this.enqueued.get(block.id());
    }

    public static enum BlockProcessResult {
        SKIP,
        DONE;

    }
}

