/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.espresso.jdwp.api.JDWPOptions;
import com.oracle.truffle.espresso.runtime.JavaVersion;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionMap;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;

@Option.Group(value={"java"})
public final class EspressoOptions {
    public static final boolean RUNNING_ON_SVM = ImageInfo.inImageCode();
    private static final Path EMPTY = Paths.get("", new String[0]);
    private static final String PATH_SEPARATOR_INSERT = "\" + java.io.File.pathSeparator + \"";
    private static final String SEMI_COLON = ";";
    private static final OptionType<List<Path>> PATHS_OPTION_TYPE = new OptionType("Paths", (Function)new Function<String, List<Path>>(){

        @Override
        public List<Path> apply(String paths) {
            try {
                return Collections.unmodifiableList(EspressoOptions.parsePaths(paths));
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final OptionType<List<String>> STRINGS_OPTION_TYPE = new OptionType("Strings", (Function)new Function<String, List<String>>(){

        @Override
        public List<String> apply(String strings) {
            try {
                return Collections.unmodifiableList(EspressoOptions.splitByFileSeparator(strings));
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final OptionType<Path> PATH_OPTION_TYPE = new OptionType("Path", (Function)new Function<String, Path>(){

        @Override
        public Path apply(String path) {
            try {
                return Paths.get(path, new String[0]);
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final OptionType<List<String>> STRINGS_OPTION_TYPE_SEPARATED_BY_SEMI_COLON = new OptionType("Strings", (Function)new Function<String, List<String>>(){

        @Override
        public List<String> apply(String strings) {
            try {
                return Collections.unmodifiableList(EspressoOptions.splitBySemiColon(strings));
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    @Option(help="User-defined system properties.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<value>")
    public static final OptionKey<OptionMap<String>> Properties = OptionKey.mapOf(String.class);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories, JAR archives, and ZIP archives to search for class files.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> Classpath = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="Specifies in which module the main class is located. Can also specify the main class name by appending it after a \\\"/\\\"", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<module>[/<mainclass>]")
    public static final OptionKey<String> Module = new OptionKey((Object)"");
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories to search for modules.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> ModulePath = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of root modules beyond the initial module.\\nEquivalent to '--add-modules=<module>'", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<module>\" + java.io.File.pathSeparator + \"<module>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<String>> AddModules = new OptionKey(Collections.emptyList(), STRINGS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"'separated list of root modules beyond the initial module.\\nEquivalent to '--add-reads=<module>'", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<module>\" + java.io.File.pathSeparator + \"<module>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<String>> AddReads = new OptionKey(Collections.emptyList(), STRINGS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of root modules beyond the initial module.\\nEquivalent to '--add-exports=<module>'", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<module>\" + java.io.File.pathSeparator + \"<module>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<String>> AddExports = new OptionKey(Collections.emptyList(), STRINGS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of root modules beyond the initial module.\\nEquivalent to '--add-opens=<module>'", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<module>\" + java.io.File.pathSeparator + \"<module>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<String>> AddOpens = new OptionKey(Collections.emptyList(), STRINGS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of modules that are permitted to perform restricted native operations.\\nEquivalent to '--enable-native-access=<module>'", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<module>\" + java.io.File.pathSeparator + \"<module>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<String>> EnableNativeAccess = new OptionKey(Collections.emptyList(), STRINGS_OPTION_TYPE);
    @Option(help="Installation directory for Java Runtime Environment (JRE).", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="<path>")
    public static final OptionKey<Path> JavaHome = new OptionKey((Object)EMPTY, PATH_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories to search for Espresso's (lib)?jvm.(so|dll|dylib).", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> JVMLibraryPath = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories, JAR files, and ZIP archives to search for boot class files. These are used in place of the boot class files included in the JDK.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> BootClasspath = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories, JAR files, and ZIP archives to append to the front of the default bootstrap class path.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> BootClasspathAppend = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories, JAR files, and ZIP archives to prepend to the end of the default bootstrap class path.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> BootClasspathPrepend = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories to search for user libraries.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> JavaLibraryPath = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories to search for system libraries.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> BootLibraryPath = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A '\" + java.io.File.pathSeparator + \"' separated list of directories to search for extensions.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="<path>\" + java.io.File.pathSeparator + \"<path>\" + java.io.File.pathSeparator + \"...")
    public static final OptionKey<List<Path>> ExtDirs = new OptionKey(Collections.emptyList(), PATHS_OPTION_TYPE);
    @Option(help="A ';' separated list of fully qualified interface names that enables interface type mapping in polyglot usage.", category=OptionCategory.USER, stability=OptionStability.EXPERIMENTAL, usageSyntax="my.first.MyInterface;my.second.MySecondInterface;...")
    public static final OptionKey<List<String>> PolyglotInterfaceMappings = new OptionKey(Collections.emptyList(), STRINGS_OPTION_TYPE_SEPARATED_BY_SEMI_COLON);
    @Option(help="Option to enable target type conversion by specifying a conversion class.", category=OptionCategory.USER, stability=OptionStability.EXPERIMENTAL, usageSyntax="java.PolyglotTypeConverters.java.lang.Optional=my.type.conversion.Implementation")
    public static final OptionKey<OptionMap<String>> PolyglotTypeConverters = OptionKey.mapOf(String.class);
    @Option(help="Enable assertions.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="false|true")
    public static final OptionKey<Boolean> EnableAssertions = new OptionKey((Object)false);
    @Option(help="Enable system assertions.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="false|true")
    public static final OptionKey<Boolean> EnableSystemAssertions = new OptionKey((Object)false);
    @Option(help="Enable extended NullPointerException message.", category=OptionCategory.USER, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> ShowCodeDetailsInExceptionMessages = new OptionKey((Object)true);
    private static final OptionType<SpecComplianceMode> SPEC_COMPLIANCE_OPTION_TYPE = new OptionType("SpecCompliance", (Function)new Function<String, SpecComplianceMode>(){

        @Override
        public SpecComplianceMode apply(String s) {
            try {
                return SpecComplianceMode.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("--java.SpecCompliance: Mode can be 'strict' or 'hotspot'.");
            }
        }
    });
    @Option(help="Force mimicking of hotspot behavior on unrespected specs points", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="hotspot|strict")
    public static final OptionKey<SpecComplianceMode> SpecCompliance = new OptionKey((Object)SpecComplianceMode.HOTSPOT, SPEC_COMPLIANCE_OPTION_TYPE);
    private static final OptionType<VerifyMode> VERIFY_MODE_OPTION_TYPE = new OptionType("VerifyMode", (Function)new Function<String, VerifyMode>(){

        @Override
        public VerifyMode apply(String s) {
            try {
                return VerifyMode.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("-Xverify: Mode can be 'none', 'remote' or 'all'.");
            }
        }
    });
    @Option(help="Sets the mode of the bytecode verifier.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="remote|none|all")
    public static final OptionKey<VerifyMode> Verify = new OptionKey((Object)VerifyMode.REMOTE, VERIFY_MODE_OPTION_TYPE);
    @Option(help="Speculatively inline field accessors.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> BytecodeLevelInlining = new OptionKey((Object)true);
    @Option(help="Enable inlining through method handle calls.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> InlineMethodHandle = new OptionKey((Object)true);
    @Option(help="All method handle call site have a different inline cache.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> SplitMethodHandles = new OptionKey((Object)false);
    @Option(help="Enable string representation sharing between host and guest (If both have the same string representation). When enabled, reflective modifications to the underlying array of guest strings may reflect on host strings, and vice-versa. ", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> StringSharing = new OptionKey((Object)true);
    private static final OptionType<LivenessAnalysisMode> LIVENESS_ANALYSIS_MODE_OPTION_TYPE = new OptionType("LivenessAnalysisMode", (Function)new Function<String, LivenessAnalysisMode>(){

        @Override
        public LivenessAnalysisMode apply(String s) {
            if ("true".equalsIgnoreCase(s)) {
                return LivenessAnalysisMode.ALL;
            }
            if ("false".equalsIgnoreCase(s)) {
                return LivenessAnalysisMode.NONE;
            }
            try {
                return LivenessAnalysisMode.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("--java.LivenessAnalysis can only be 'none'|'false', 'auto' or 'all'|'true'.");
            }
        }
    });
    @Option(help="Controls static liveness analysis of bytecodes, allowing to clear local variables during execution if they become stale.\\nLiveness analysis, if enabled, only affects compiled code.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="auto|true|all|false|none")
    public static final OptionKey<LivenessAnalysisMode> LivenessAnalysis = new OptionKey((Object)LivenessAnalysisMode.AUTO, LIVENESS_ANALYSIS_MODE_OPTION_TYPE);
    @Option(help="Minimum number of locals to run liveness analysis.\\nLiveness analysis, if enabled, only affects compiled code.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="[0, 65535]")
    public static final OptionKey<Integer> LivenessAnalysisMinimumLocals = new OptionKey((Object)8);
    @Option(help="Enable Class Hierarchy Analysis, which optimizes instanceof checks and virtual method calls by keeping track of descendants of a given class or interface.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> CHA = new OptionKey((Object)true);
    private static final OptionType<JDWPOptions> JDWP_OPTIONS_OPTION_TYPE = new OptionType("JDWPOptions", (Function)new Function<String, JDWPOptions>(){

        private boolean yesOrNo(String key, String value) {
            if (!"y".equals(value) && !"n".equals(value)) {
                throw new IllegalArgumentException("Invalid JDWP option value: " + key + " can be only 'y' or 'n'.");
            }
            return "y".equals(value);
        }

        @Override
        public JDWPOptions apply(String s) {
            String[] options = s.split(",");
            String transport = null;
            String host = null;
            String port = null;
            boolean server = false;
            boolean suspend = true;
            block14: for (String keyValue : options) {
                String[] parts = keyValue.split("=");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("JDWP options must be a comma separated list of key=value pairs.");
                }
                String key = parts[0];
                String value = parts[1];
                switch (key) {
                    case "address": {
                        String inputPort;
                        parts = value.split(":");
                        String inputHost = null;
                        if (parts.length == 1) {
                            inputPort = parts[0];
                        } else if (parts.length == 2) {
                            inputHost = parts[0];
                            inputPort = parts[1];
                        } else {
                            throw new IllegalArgumentException("Invalid JDWP option, address: " + value + ". Not a 'host:port' pair.");
                        }
                        try {
                            long realValue = Long.valueOf(inputPort);
                            if (realValue < 0L || realValue > 65535L) {
                                throw new IllegalArgumentException("Invalid JDWP option, address: " + value + ". Must be in the 0 - 65535 range.");
                            }
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalArgumentException("Invalid JDWP option, address is not a number. Must be a number in the 0 - 65535 range.");
                        }
                        host = inputHost;
                        port = inputPort;
                        continue block14;
                    }
                    case "transport": {
                        if (!"dt_socket".equals(value)) {
                            throw new IllegalArgumentException("Invalid transport " + value + ". Espresso only supports dt_socket currently.");
                        }
                        transport = value;
                        continue block14;
                    }
                    case "server": {
                        server = this.yesOrNo(key, value);
                        continue block14;
                    }
                    case "suspend": {
                        suspend = this.yesOrNo(key, value);
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid JDWP option: " + key + ". Supported options: 'transport', 'address', 'server' and 'suspend'.");
                    }
                }
            }
            return new JDWPOptions(transport, host, port, server, suspend);
        }
    });
    @Option(help="JDWP agent Options. e.g. -agentlib:jdwp=transport=dt_socket,server=y,address=localhost:8000,suspend=y", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="[transport=dt_socket],[server=y|n],[address=[<host>:]<port>,[suspend=y|n]]")
    public static final OptionKey<JDWPOptions> JDWPOptions = new OptionKey(null, JDWP_OPTIONS_OPTION_TYPE);
    @Option(help="Enable experimental java.lang.management APIs. Incur a bookkeeping overhead.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> EnableManagement = new OptionKey((Object)true);
    @Option(help="Enable support for threads. In single-threaded mode, Thread.start is disabled, weak references and finalizers won't be processed. Lock operations may be optimized away.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="true|false")
    public static final OptionKey<Boolean> MultiThreaded = new OptionKey((Object)true);
    @Option(help="Enables graceful teardown of the VM on exit. Rather than abruptly terminating execution, gives all leftover non-daemon thread some leeway to finish executing in guest.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> SoftExit = new OptionKey((Object)false);
    @Option(help="Allows Espresso to use host System.exit() on context exit when there are unresponsive threads. This should not be used in most cases as it will take down the whole host VM abruptly, possibly preventing other languages from performing their own exit sequence.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> ExitHost = new OptionKey((Object)false);
    @Option(help="Enables espresso runtime timers.", category=OptionCategory.INTERNAL, stability=OptionStability.STABLE, usageSyntax="false|true")
    public static final OptionKey<Boolean> EnableTimers = new OptionKey((Object)false);
    @Option(help="Enable polyglot support in Espresso.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> Polyglot = new OptionKey((Object)false);
    @Option(help="Enable built in polyglot collection support in Espresso.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> BuiltInPolyglotCollections = new OptionKey((Object)false);
    @Option(help="Enable hotspot extension API.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> HotSwapAPI = new OptionKey((Object)false);
    @Option(help="Use Custom ClassLoader for Bindings, allowing the addition of new locations for loading.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> UseBindingsLoader = new OptionKey((Object)false);
    @Option(help="Expose the <JavaVM> binding.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> ExposeNativeJavaVM = new OptionKey((Object)false);
    @Option(help="User-specified classlist used to warmup Espresso during context pre-initialization. The file should contain one class per line (see lib/classlist for an example).", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL)
    public static final OptionKey<Path> PreInitializationClasslist = new OptionKey((Object)EMPTY, PATH_OPTION_TYPE);
    private static final OptionType<Long> SIZE_OPTION_TYPE = new OptionType("Size", (Function)new Function<String, Long>(){
        private static final int K = 1024;

        @Override
        public Long apply(String size) {
            int idx = 0;
            int len = size.length();
            for (int i = 0; i < len && Character.isDigit(size.charAt(i)); ++i) {
                ++idx;
            }
            if (idx == 0) {
                throw new IllegalArgumentException("Not starting with digits: " + size);
            }
            if (len - idx > 1) {
                throw new IllegalArgumentException("Unit prefix can be at most one character: " + size);
            }
            long result = Long.parseLong(size.substring(0, idx));
            if (idx < len) {
                switch (size.charAt(idx)) {
                    case 'T': 
                    case 't': {
                        return result * 1024L * 1024L * 1024L * 1024L;
                    }
                    case 'G': 
                    case 'g': {
                        return result * 1024L * 1024L * 1024L;
                    }
                    case 'M': 
                    case 'm': {
                        return result * 1024L * 1024L;
                    }
                    case 'K': 
                    case 'k': {
                        return result * 1024L;
                    }
                }
                throw new IllegalArgumentException("Unrecognized unit prefix: " + size + " use `T`, `G`, `M`, or `k`.");
            }
            return result;
        }
    });
    @Option(help="Maximum total size of NIO direct-buffer allocations.", category=OptionCategory.EXPERT, stability=OptionStability.STABLE, usageSyntax="<size>[<unit>]")
    public static final OptionKey<Long> MaxDirectMemorySize = new OptionKey((Object)-1L, SIZE_OPTION_TYPE);
    @Option(help="Load native agents from standard library paths. \\nKeys represent the agent library name, values are the corresponding agent options.\\nAgents are not fully implemented yet.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="<agentOptions>")
    public static final OptionKey<OptionMap<String>> AgentLib = OptionKey.mapOf(String.class);
    @Option(help="Load native agents from an absolute path. \\nKeys represent the agent library full absolute path, values are the corresponding agent options.\\nAgents are not fully implemented yet.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="<librarypath>=<agentOptions>")
    public static final OptionKey<OptionMap<String>> AgentPath = OptionKey.mapOf(String.class);
    @Option(help="Load a Java programming language agent for the given jar file. \\nKeys represent the jar path, values are the corresponding agent options.\\nAgents are not fully implemented yet.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="<agent>")
    public static final OptionKey<String> JavaAgent = new OptionKey((Object)"");
    @Option(help="Used internally to keep track of the command line arguments given to the vm in order to support VM.getRuntimeArguments().\\nSetting this option is the responsibility of the context creator if such support is required.\\nUsage:\\nFor each argument [arg<i>] passed to the context (excluding the main class args):\\n    builder.option(java.VMArguments.<i>, [arg<i>]);", category=OptionCategory.INTERNAL, stability=OptionStability.STABLE, usageSyntax="<argument>")
    public static final OptionKey<OptionMap<String>> VMArguments = OptionKey.mapOf(String.class);
    @Option(help="Native backend used by Espresso, if not specified, Espresso will pick one depending on the environment.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="<nativeBackend>")
    public static final OptionKey<String> NativeBackend = new OptionKey((Object)"");
    @Option(help="Enables the signal API (sun.misc.Signal or jdk.internal.misc.Signal).", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> EnableSignals = new OptionKey((Object)false);
    @Option(help="Enables java agents. Support is currently very limited.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> EnableAgents = new OptionKey((Object)false);
    @Option(help="Maximum bytecode size (in bytes) for a method to be considered trivial.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="[0, 65535]")
    public static final OptionKey<Integer> TrivialMethodSize = new OptionKey((Object)18);
    @Option(help="Use the host FinalReference to implement guest finalizers. If set to false, FinalReference will fallback to WeakReference semantics.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> UseHostFinalReference = new OptionKey((Object)true);
    private static final OptionType<JImageMode> JIMAGE_MODE_OPTION_TYPE = new OptionType("JImageMode", (Function)new Function<String, JImageMode>(){

        @Override
        public JImageMode apply(String s) {
            try {
                return JImageMode.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("JImage: Mode can be 'native', 'java'.");
            }
        }
    });
    @Option(help="Selects the jimage reader.", category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL)
    public static final OptionKey<JImageMode> JImage = new OptionKey((Object)JImageMode.JAVA, JIMAGE_MODE_OPTION_TYPE);
    @Option(help="Enables preview features.", category=OptionCategory.USER, stability=OptionStability.STABLE, usageSyntax="false|true")
    public static final OptionKey<Boolean> EnablePreview = new OptionKey((Object)false);
    @Option(help="Enables the WhiteBox API.", category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, usageSyntax="false|true")
    public static final OptionKey<Boolean> WhiteBoxAPI = new OptionKey((Object)false);
    public static final boolean DebugCounters = EspressoOptions.booleanProperty("espresso.DebugCounters", false);
    public static final boolean DumpDebugCounters = EspressoOptions.booleanProperty("espresso.DumpDebugCounters", true);
    public static final boolean UnsafeOverride = EspressoOptions.booleanProperty("espresso.finalization.UnsafeOverride", true);
    public static final boolean InjectClasses = EspressoOptions.booleanProperty("espresso.finalization.InjectClasses", !JavaVersion.HOST_VERSION.java19OrLater());

    public static List<Path> parsePaths(String paths) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (String path : EspressoOptions.splitByFileSeparator(paths)) {
            list.add(Paths.get(path, new String[0]));
        }
        return list;
    }

    private static List<String> splitByFileSeparator(String strings) {
        return new ArrayList<String>(Arrays.asList(strings.split(File.pathSeparator)));
    }

    private static List<String> splitBySemiColon(String strings) {
        return new ArrayList<String>(Arrays.asList(strings.split(SEMI_COLON)));
    }

    private static boolean booleanProperty(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        return value == null ? defaultValue : value.equalsIgnoreCase("true");
    }

    public static enum SpecComplianceMode {
        STRICT,
        HOTSPOT;

    }

    public static enum VerifyMode {
        NONE,
        REMOTE,
        ALL;

    }

    public static enum LivenessAnalysisMode {
        NONE,
        ALL,
        AUTO;

    }

    public static enum JImageMode {
        NATIVE,
        JAVA;

    }
}

