/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.verifier.StackMapFrame;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;
import java.io.PrintStream;

final class FullFrame
extends StackMapFrame {
    private final int offsetDelta;
    private final VerificationTypeInfo[] locals;
    private final VerificationTypeInfo[] stack;

    FullFrame(int frameType, int offsetDelta, VerificationTypeInfo[] locals, VerificationTypeInfo[] stack) {
        super(frameType);
        this.offsetDelta = offsetDelta;
        this.locals = locals;
        this.stack = stack;
    }

    @Override
    public int getOffset() {
        return this.offsetDelta;
    }

    @Override
    public VerificationTypeInfo[] getLocals() {
        return this.locals;
    }

    @Override
    public VerificationTypeInfo[] getStack() {
        return this.stack;
    }

    @Override
    public void print(Klass klass, PrintStream out) {
        super.print(klass, out);
        out.println("            Locals: [");
        for (VerificationTypeInfo vti : this.locals) {
            out.println("                " + vti.toString(klass));
        }
        out.println("            ]");
        out.println("            Stack: [");
        for (VerificationTypeInfo vti : this.stack) {
            out.println("                " + vti.toString(klass));
        }
        out.println("            ]");
        out.println("        }");
    }
}

