/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.verifier;

import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.verifier.StackMapFrame;
import com.oracle.truffle.espresso.verifier.VerificationTypeInfo;
import java.io.PrintStream;

final class AppendFrame
extends StackMapFrame {
    private final int offsetDelta;
    private final VerificationTypeInfo[] newLocals;

    AppendFrame(int frameType, int offsetDelta, VerificationTypeInfo[] newLocals) {
        super(frameType);
        this.offsetDelta = offsetDelta;
        this.newLocals = newLocals;
    }

    @Override
    public int getOffset() {
        return this.offsetDelta;
    }

    @Override
    public VerificationTypeInfo[] getLocals() {
        return this.newLocals;
    }

    @Override
    public void print(Klass klass, PrintStream out) {
        super.print(klass, out);
        out.println("            Add Locals: [");
        for (VerificationTypeInfo vti : this.newLocals) {
            out.println("                " + vti.toString(klass));
        }
        out.println("            ]");
        out.println("        }");
    }
}

