/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.blocking.GuestInterruptedException;
import com.oracle.truffle.espresso.ffi.Buffer;
import com.oracle.truffle.espresso.ffi.RawPointer;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.ClassRegistry;
import com.oracle.truffle.espresso.impl.EspressoClassLoadingException;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.jni.JniEnv;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.JavaKind;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.meta.MetaUtil;
import com.oracle.truffle.espresso.nodes.EspressoNode;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.InlineInBytecode;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNamesProvider;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.substitutions.Target_sun_misc_UnsafeFactory;
import com.oracle.truffle.espresso.substitutions.UnsafeSupport;
import com.oracle.truffle.espresso.threads.State;
import com.oracle.truffle.espresso.threads.Transition;
import com.oracle.truffle.espresso.vm.InterpreterToVM;
import com.oracle.truffle.espresso.vm.UnsafeAccess;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;

@EspressoSubstitutions(nameProvider=SharedUnsafe.class)
public final class Target_sun_misc_Unsafe {
    public static final int ADDRESS_SIZE;
    private static final int SAFETY_FIELD_OFFSET = 123456789;
    private static final int SAFETY_STATIC_FIELD_OFFSET = 3456789;
    private static final int ALLOWED_HIDDEN_FIELDS = 4096;
    private static final String TARGET_JDK_INTERNAL_MISC_UNSAFE = "Target_jdk_internal_misc_Unsafe";
    private static final String TARGET_SUN_MISC_UNSAFE = "Target_sun_misc_Unsafe";

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static @JavaType(value=Class.class) StaticObject defineAnonymousClass(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject hostClass, @JavaType(value=byte[].class) StaticObject data, @JavaType(value=Object[].class) StaticObject constantPoolPatches, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (StaticObject.isNull(hostClass) || StaticObject.isNull(data)) {
            throw meta.throwNullPointerException();
        }
        if (hostClass.getMirrorKlass(meta).isArray() || hostClass.getMirrorKlass(meta).isPrimitive()) {
            throw meta.throwException(meta.java_lang_IllegalArgumentException);
        }
        byte[] bytes = (byte[])data.unwrap(language);
        ObjectKlass hostKlass = (ObjectKlass)hostClass.getMirrorKlass(meta);
        StaticObject pd = (StaticObject)meta.HIDDEN_PROTECTION_DOMAIN.getHiddenObject(hostClass);
        StaticObject[] patches = StaticObject.isNull(constantPoolPatches) ? null : (StaticObject[])constantPoolPatches.unwrap(language);
        ClassRegistry.ClassDefinitionInfo info = new ClassRegistry.ClassDefinitionInfo(pd, hostKlass, patches);
        EspressoContext context = meta.getContext();
        ObjectKlass k = null;
        try {
            k = context.getRegistries().defineKlass(null, bytes, hostKlass.getDefiningClassLoader(), info);
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(meta);
        }
        k.safeInitialize();
        return k.mirror();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static int arrayBaseOffset(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        Unsafe unsafe = UnsafeAccess.getIfAllowed(meta);
        Klass klass = clazz.getMirrorKlass(meta);
        assert (klass.isArray());
        if (((ArrayKlass)klass).getComponentType().isPrimitive()) {
            Class<?> hostPrimitive = ((ArrayKlass)klass).getComponentType().getJavaKind().toJavaClass();
            return unsafe.arrayBaseOffset(Array.newInstance(hostPrimitive, 0).getClass());
        }
        return unsafe.arrayBaseOffset(Object[].class);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static int arrayIndexScale(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        Unsafe unsafe = UnsafeAccess.getIfAllowed(meta);
        Klass klass = clazz.getMirrorKlass(meta);
        assert (klass.isArray());
        if (((ArrayKlass)klass).getComponentType().isPrimitive()) {
            Class<?> hostPrimitive = ((ArrayKlass)klass).getComponentType().getJavaKind().toJavaClass();
            return unsafe.arrayIndexScale(Array.newInstance(hostPrimitive, 0).getClass());
        }
        return unsafe.arrayIndexScale(Object[].class);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class, isTrivial=true)
    public static int addressSize(@JavaType(value=Unsafe.class) StaticObject self) {
        return ADDRESS_SIZE;
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long objectFieldOffset(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Field.class) StaticObject field, @Inject Meta meta) {
        com.oracle.truffle.espresso.impl.Field target = com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(field, meta);
        return (target.isStatic() ? 3456789 : 123456789) + target.getSlot();
    }

    static int safetyOffsetToSlot(long safetyOffset) {
        int offset = Math.toIntExact(safetyOffset);
        if (offset >= 123452693) {
            return offset - 123456789;
        }
        assert (offset >= 3452693) : "offset: " + offset;
        return offset - 3456789;
    }

    static long slotToSafetyOffset(int slot, boolean isStatic) {
        return (long)(isStatic ? 3456789 : 123456789) + (long)slot;
    }

    private static com.oracle.truffle.espresso.impl.Field resolveUnsafeAccessField(StaticObject holder, long offset, Meta meta) {
        int slot;
        int safetyOffset = Math.toIntExact(offset);
        boolean isStatic = false;
        if (safetyOffset >= 123452693) {
            slot = safetyOffset - 123456789;
        } else {
            assert (safetyOffset >= 3452693) : "safetyOffset: " + safetyOffset;
            slot = safetyOffset - 3456789;
            isStatic = true;
        }
        assert (!StaticObject.isNull(holder));
        if (slot >= 65536 || slot < -4096) {
            return null;
        }
        com.oracle.truffle.espresso.impl.Field field = null;
        try {
            if (isStatic) {
                if (holder.isMirrorKlass()) {
                    field = holder.getMirrorKlass(meta).lookupStaticFieldTable(slot);
                } else {
                    assert (holder.isStaticStorage());
                    field = holder.getKlass().lookupStaticFieldTable(slot);
                }
            } else {
                field = holder.getKlass().lookupFieldTable(slot);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
        assert (field != null);
        return field;
    }

    private static StaticObject resolveUnsafeAccessHolder(com.oracle.truffle.espresso.impl.Field f, StaticObject advertisedHolder, Meta meta) {
        if (f.isStatic() && advertisedHolder.isMirrorKlass()) {
            return advertisedHolder.getMirrorKlass(meta).getStatics();
        }
        return advertisedHolder;
    }

    static EspressoException throwUnsupported(Meta meta, String message) {
        throw meta.throwExceptionWithMessage(meta.java_lang_UnsupportedOperationException, message);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static @JavaType(value=Class.class) StaticObject defineClass(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=String.class) StaticObject name, @JavaType(value=byte[].class) StaticObject guestBuf, int offset, int len, @JavaType(value=ClassLoader.class) StaticObject loader, @JavaType(value=ProtectionDomain.class) StaticObject pd, @Inject EspressoLanguage language, @Inject Meta meta) {
        ObjectKlass klass;
        byte[] buf = (byte[])guestBuf.unwrap(language);
        byte[] bytes = Arrays.copyOfRange(buf, offset, len);
        EspressoContext context = meta.getContext();
        try {
            klass = context.getRegistries().defineKlass(meta.getTypes().fromClassGetName(meta.toHostString(name)), bytes, loader, new ClassRegistry.ClassDefinitionInfo(pd));
        }
        catch (EspressoClassLoadingException e) {
            throw e.asGuestException(meta);
        }
        return klass.mirror();
    }

    @Substitution
    public static void registerNatives() {
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long allocateMemory(@JavaType(value=Unsafe.class) StaticObject self, long length, @Inject Meta meta) {
        JniEnv jni = meta.getContext().getJNI();
        if (length < 0L || length > jni.sizeMax()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "requested size doesn't fit in the size_t native type");
        }
        @Buffer TruffleObject buffer = meta.getNativeAccess().allocateMemory(length);
        if (buffer == null && length > 0L) {
            throw meta.throwExceptionWithMessage(meta.java_lang_OutOfMemoryError, "malloc returned NULL");
        }
        long ptr = 0L;
        try {
            ptr = InteropLibrary.getUncached().asPointer((Object)buffer);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
        return ptr;
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long reallocateMemory(@JavaType(value=Unsafe.class) StaticObject self, long address, long newSize, @Inject Meta meta) {
        JniEnv jni = meta.getContext().getJNI();
        if (newSize < 0L || newSize > jni.sizeMax()) {
            throw meta.throwExceptionWithMessage(meta.java_lang_IllegalArgumentException, "requested size doesn't fit in the size_t native type");
        }
        @Buffer TruffleObject result = meta.getNativeAccess().reallocateMemory(RawPointer.create(address), newSize);
        if (result == null) {
            throw meta.throwExceptionWithMessage(meta.java_lang_OutOfMemoryError, "realloc couldn't reallocate " + newSize + " bytes");
        }
        long newAddress = 0L;
        try {
            newAddress = InteropLibrary.getUncached().asPointer((Object)result);
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw EspressoError.shouldNotReachHere(e);
        }
        return newAddress;
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void freeMemory(@JavaType(value=Unsafe.class) StaticObject self, long address, @Inject Meta meta) {
        meta.getNativeAccess().freeMemory(RawPointer.create(address));
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static boolean shouldBeInitialized(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(clazz)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        Klass klass = clazz.getMirrorKlass(meta);
        return !klass.isInitialized();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void ensureClassInitialized(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        clazz.getMirrorKlass(meta).safeInitialize();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void copyMemory(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject srcBase, long srcOffset, @JavaType(value=Object.class) StaticObject destBase, long destOffset, long bytes, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (bytes == 0L) {
            return;
        }
        UnsafeAccess.getIfAllowed(meta).copyMemory(MetaUtil.unwrapArrayOrNull(language, srcBase), srcOffset, MetaUtil.unwrapArrayOrNull(language, destBase), destOffset, bytes);
    }

    @Substitution(hasReceiver=true)
    public static void copySwapMemory0(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject srcBase, long srcOffset, @JavaType(value=Object.class) StaticObject destBase, long destOffset, long bytes, long elemSize, @Inject EspressoLanguage language, @Inject Meta meta) {
        if (bytes == 0L) {
            return;
        }
        UnsafeAccess.checkAllowed(meta);
        UnsafeSupport.copySwapMemory(MetaUtil.unwrapArrayOrNull(language, srcBase), srcOffset, MetaUtil.unwrapArrayOrNull(language, destBase), destOffset, bytes, elemSize);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static @JavaType(value=Object.class) StaticObject allocateInstance(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject clazz, @Inject Meta meta) {
        Klass mirrorKlass = clazz.getMirrorKlass(meta);
        GuestAllocator.AllocationChecks.checkCanAllocateNewReference(meta, mirrorKlass, false);
        return meta.getAllocator().createNew((ObjectKlass)mirrorKlass);
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static void setMemory(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject o, long offset, long bytes, byte value, @Inject Meta meta, @Inject EspressoLanguage language) {
        Object hostObject;
        if (StaticObject.isNull(o)) {
            hostObject = null;
        } else if (o.getKlass().isArray()) {
            hostObject = o.unwrap(language);
        } else {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
        UnsafeAccess.getIfAllowed(meta).setMemory(hostObject, offset, bytes, value);
    }

    @Substitution(hasReceiver=true)
    public static int pageSize(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        return UnsafeAccess.getIfAllowed(meta).pageSize();
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static long staticFieldOffset(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Field.class) StaticObject field, @Inject Meta meta) {
        return com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(field, meta).getSlot() + 3456789;
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static @JavaType(value=Object.class) StaticObject staticFieldBase(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Field.class) StaticObject field, @Inject Meta meta) {
        com.oracle.truffle.espresso.impl.Field target = com.oracle.truffle.espresso.impl.Field.getReflectiveFieldRoot(field, meta);
        return target.getDeclaringKlass().getStatics();
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    public static void monitorEnter(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject object, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(object)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        InterpreterToVM.monitorUnsafeEnter(object.getLock(meta.getContext()));
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    public static void monitorExit(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject object, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (StaticObject.isNull(object)) {
            profiler.profile(0);
            throw meta.throwNullPointerException();
        }
        InterpreterToVM.monitorUnsafeExit(object.getLock(meta.getContext()));
    }

    @Substitution(hasReceiver=true, isTrivial=true)
    public static void throwException(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Throwable.class) StaticObject ee, @Inject Meta meta) {
        throw meta.throwException(ee);
    }

    @CompilerDirectives.TruffleBoundary
    @Substitution(hasReceiver=true)
    public static void park(@JavaType(value=Unsafe.class) StaticObject self, boolean isAbsolute, long time, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        if (time < 0L || isAbsolute && time == 0L) {
            return;
        }
        EspressoContext context = meta.getContext();
        StaticObject thread = context.getCurrentPlatformThread();
        if (Target_sun_misc_Unsafe.parkReturnCondition(thread, meta)) {
            return;
        }
        State state = time > 0L ? State.TIMED_WAITING : State.WAITING;
        try (Transition transition = Transition.transition(context, state);){
            Target_sun_misc_Unsafe.parkImpl(isAbsolute, time, thread, meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parkImpl(boolean isAbsolute, long time, StaticObject thread, Meta meta) {
        EspressoLock parkLock = Target_sun_misc_Unsafe.getParkLock(thread, meta);
        parkLock.lock();
        try {
            while (true) {
                boolean elapsed;
                if (Target_sun_misc_Unsafe.parkReturnCondition(thread, meta)) {
                    return;
                }
                if (isAbsolute) {
                    elapsed = !parkLock.awaitUntil(new Date(time));
                } else {
                    boolean bl = elapsed = !parkLock.await(time, TimeUnit.NANOSECONDS);
                }
                if (elapsed) {
                    return;
                }
                continue;
                break;
            }
        }
        catch (GuestInterruptedException e) {
            return;
        }
        finally {
            parkLock.unlock();
        }
    }

    private static EspressoLock getParkLock(StaticObject thread, Meta meta) {
        return (EspressoLock)meta.HIDDEN_THREAD_PARK_LOCK.getHiddenObject(thread);
    }

    private static boolean parkReturnCondition(StaticObject thread, Meta meta) {
        return Target_sun_misc_Unsafe.consumeUnparkSignal(thread, meta) || meta.getThreadAccess().isInterrupted(thread, false);
    }

    private static boolean consumeUnparkSignal(StaticObject self, Meta meta) {
        com.oracle.truffle.espresso.impl.Field signals = meta.HIDDEN_THREAD_UNPARK_SIGNALS;
        return signals.getAndSetInt(self, 0) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @Substitution(hasReceiver=true)
    public static void unpark(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject thread, @Inject Meta meta) {
        EspressoLock parkLock = Target_sun_misc_Unsafe.getParkLock(thread, meta);
        parkLock.lock();
        try {
            meta.HIDDEN_THREAD_UNPARK_SIGNALS.setInt(thread, 1, true);
            parkLock.signal();
        }
        finally {
            parkLock.unlock();
        }
    }

    @Substitution(hasReceiver=true)
    public static long getAddress(@JavaType(value=Unsafe.class) StaticObject self, long address, @Inject Meta meta) {
        return UnsafeAccess.getIfAllowed(meta).getAddress(address);
    }

    @Substitution(hasReceiver=true)
    public static void putAddress(@JavaType(value=Unsafe.class) StaticObject self, long address, long x, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).putAddress(address, x);
    }

    @Substitution(hasReceiver=true)
    public static void loadFence(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).loadFence();
    }

    @Substitution(hasReceiver=true)
    public static void storeFence(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).storeFence();
    }

    @Substitution(hasReceiver=true)
    public static void fullFence(@JavaType(value=Unsafe.class) StaticObject self, @Inject Meta meta) {
        UnsafeAccess.getIfAllowed(meta).fullFence();
    }

    @Substitution(hasReceiver=true)
    public static boolean tryMonitorEnter(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject object, @Inject Meta meta) {
        if (StaticObject.isNull(object)) {
            throw meta.throwNullPointerException();
        }
        return InterpreterToVM.monitorTryLock(object.getLock(meta.getContext()));
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeAppend0.class)
    public static int getLoadAverage(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=double[].class) StaticObject loadavg, int nelems) {
        return -1;
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static boolean isBigEndian0(@JavaType(value=Unsafe.class) StaticObject self) {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static boolean unalignedAccess0(@JavaType(value=Unsafe.class) StaticObject self) {
        return false;
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static long objectFieldOffset1(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Class.class) StaticObject cl, @JavaType(value=String.class) StaticObject guestName, @Inject Meta meta) {
        Klass k = cl.getMirrorKlass(meta);
        String hostName = meta.toHostString(guestName);
        if (k instanceof ObjectKlass) {
            ObjectKlass kl = (ObjectKlass)k;
            for (com.oracle.truffle.espresso.impl.Field f : kl.getFieldTable()) {
                if (f.isRemoved() || !f.getNameAsString().equals(hostName)) continue;
                return 123456789 + f.getSlot();
            }
            for (com.oracle.truffle.espresso.impl.Field f : kl.getStaticFieldTable()) {
                if (f.isRemoved() || !f.getNameAsString().equals(hostName)) continue;
                return 3456789 + f.getSlot();
            }
        }
        throw meta.throwException(meta.java_lang_InternalError);
    }

    static {
        Unsafe unsafe = UnsafeAccess.get();
        ADDRESS_SIZE = unsafe.addressSize();
    }

    public static class Unsafe11
    extends SubstitutionNamesProvider {
        private static String[] NAMES = new String[]{"Target_jdk_internal_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new Unsafe11();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    public static class Unsafe8
    extends SubstitutionNamesProvider {
        private static String[] NAMES = new String[]{"Target_sun_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new Unsafe8();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    public static class SharedUnsafeObjectAccessToReference
    extends SubstitutionNamesProvider {
        private static String[] NAMES = new String[]{"Target_sun_misc_Unsafe", "Target_jdk_internal_misc_Unsafe", "Target_jdk_internal_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new SharedUnsafeObjectAccessToReference();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }

        @Override
        public String[] getMethodNames(String name) {
            String[] names = new String[]{name, name, name.replace("Object", "Reference")};
            return names;
        }
    }

    public static class SharedUnsafeAppend0
    extends SharedUnsafe {
        public static SubstitutionNamesProvider INSTANCE = new SharedUnsafeAppend0();

        @Override
        public String[] getMethodNames(String name) {
            return SharedUnsafeAppend0.append0(this, name);
        }
    }

    public static class SharedUnsafe
    extends SubstitutionNamesProvider {
        private static String[] NAMES = new String[]{"Target_sun_misc_Unsafe", "Target_jdk_internal_misc_Unsafe"};
        public static SubstitutionNamesProvider INSTANCE = new SharedUnsafe();

        @Override
        public String[] substitutionClassNames() {
            return NAMES;
        }
    }

    @Substitution(hasReceiver=true)
    @InlineInBytecode
    static abstract class CompareAndSetLong
    extends UnsafeAccessNode {
        CompareAndSetLong() {
        }

        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5, long var7);

        @Specialization
        protected boolean doCached(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after, @Cached CompareAndSwapLong cas) {
            return cas.execute(self, holder, offset, before, after);
        }
    }

    @Substitution(hasReceiver=true)
    @InlineInBytecode
    static abstract class CompareAndSetInt
    extends UnsafeAccessNode {
        CompareAndSetInt() {
        }

        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5, int var6);

        @Specialization
        protected boolean doCached(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after, @Cached CompareAndSwapInt cas) {
            return cas.execute(self, holder, offset, before, after);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class)
    @InlineInBytecode
    static abstract class CompareAndSetObject
    extends UnsafeAccessNode {
        CompareAndSetObject() {
        }

        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5, @JavaType(value=Object.class) StaticObject var6);

        @Specialization
        protected boolean doCached(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after, @Cached CompareAndSwapObject cas) {
            return cas.execute(self, holder, offset, before, after);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class GetAndSetObject
    extends UnsafeAccessNode {
        abstract @JavaType(value=Unsafe.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected @JavaType(value=Unsafe.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            return (StaticObject)UnsafeAccess.getIfAllowed(this.getMeta()).getAndSetObject(GetAndSetObject.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected @JavaType(value=Unsafe.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            return f.getAndSetObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    public static abstract class CompareAndExchangeLong
    extends UnsafeAccessNode {
        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5, long var7);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected long doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeLong(CompareAndExchangeLong.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected long doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            switch (f.getKind()) {
                case Long: {
                    return f.compareAndExchangeLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
                }
                case Double: {
                    return Double.doubleToRawLongBits(f.compareAndExchangeDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), Double.longBitsToDouble(before), Double.longBitsToDouble(after)));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @Substitution(hasReceiver=true)
    public static abstract class CompareAndExchangeShort
    extends UnsafeAccessNode {
        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, short var5, short var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected short doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short before, short after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeShort(CompareAndExchangeShort.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected short doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short before, short after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            switch (f.getKind()) {
                case Short: {
                    return f.compareAndExchangeShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
                }
                case Char: {
                    return (short)f.compareAndExchangeChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), (char)before, (char)after);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @Substitution(hasReceiver=true)
    public static abstract class CompareAndExchangeByte
    extends UnsafeAccessNode {
        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, byte var5, byte var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected byte doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte before, byte after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeByte(CompareAndExchangeByte.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected byte doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte before, byte after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            switch (f.getKind()) {
                case Boolean: {
                    return f.compareAndExchangeBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before != 0, after != 0) ? (byte)1 : 0;
                }
                case Byte: {
                    return f.compareAndExchangeByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe11.class)
    @InlineInBytecode
    public static abstract class CompareAndExchangeInt
    extends UnsafeAccessNode {
        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5, int var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected int doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return UnsafeSupport.compareAndExchangeInt(CompareAndExchangeInt.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected int doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            switch (f.getKind()) {
                case Int: {
                    return f.compareAndExchangeInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
                }
                case Float: {
                    return Float.floatToRawIntBits(f.compareAndExchangeFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), Float.intBitsToFloat(before), Float.intBitsToFloat(after)));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class)
    @InlineInBytecode
    public static abstract class CompareAndExchangeObject
    extends UnsafeAccessNode {
        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5, @JavaType(value=Object.class) StaticObject var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected @JavaType(value=Object.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after) {
            UnsafeAccess.checkAllowed(this.getMeta());
            return (StaticObject)UnsafeSupport.compareAndExchangeObject(CompareAndExchangeObject.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() != JavaKind.Object) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw EspressoError.shouldNotReachHere();
            }
            return f.compareAndExchangeObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class CompareAndSwapLong
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5, long var7);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).compareAndSwapLong(CompareAndSwapLong.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long before, long after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            switch (f.getKind()) {
                case Long: {
                    return f.compareAndSwapLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
                }
                case Double: {
                    return f.compareAndSwapDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), Double.longBitsToDouble(before), Double.longBitsToDouble(after));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class CompareAndSwapInt
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5, int var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).compareAndSwapInt(CompareAndSwapInt.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int before, int after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            switch (f.getKind()) {
                case Int: {
                    return f.compareAndSwapInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
                }
                case Float: {
                    return f.compareAndSwapFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), Float.intBitsToFloat(before), Float.intBitsToFloat(after));
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }

    @Substitution(hasReceiver=true, nameProvider=Unsafe8.class)
    @InlineInBytecode
    public static abstract class CompareAndSwapObject
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5, @JavaType(value=Object.class) StaticObject var6);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).compareAndSwapObject(CompareAndSwapObject.unwrapNullOrArray(this.getLanguage(), holder), offset, before, after);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject before, @JavaType(value=Object.class) StaticObject after, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            return f.compareAndSwapObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), before, after);
        }
    }

    @Substitution(hasReceiver=true, methodName="putLongVolatile")
    @InlineInBytecode
    public static abstract class PutLongVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putLongVolatile(PutLongVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putDoubleVolatile")
    @InlineInBytecode
    public static abstract class PutDoubleVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, double var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putDoubleVolatile(PutDoubleVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putFloatVolatile")
    @InlineInBytecode
    public static abstract class PutFloatVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, float var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putFloatVolatile(PutFloatVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putIntVolatile")
    @InlineInBytecode
    public static abstract class PutIntVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putIntVolatile(PutIntVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putShortVolatile")
    @InlineInBytecode
    public static abstract class PutShortVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, short var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putShortVolatile(PutShortVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putCharVolatile")
    @InlineInBytecode
    public static abstract class PutCharVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, char var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putCharVolatile(PutCharVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putBooleanVolatile")
    @InlineInBytecode
    public static abstract class PutBooleanVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, boolean var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putBooleanVolatile(PutBooleanVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="putObjectVolatile")
    @InlineInBytecode
    public static abstract class PutObjectVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putObjectVolatile(PutObjectVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putByteVolatile")
    @InlineInBytecode
    public static abstract class PutByteVolatileWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, byte var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putByteVolatile(PutByteVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetLong
    extends UnsafeAccessNode {
        GetLong() {
        }

        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        long doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getLong(address);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetDouble
    extends UnsafeAccessNode {
        GetDouble() {
        }

        abstract double execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        double doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getDouble(address);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetFloat
    extends UnsafeAccessNode {
        GetFloat() {
        }

        abstract float execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        float doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getFloat(address);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetInt
    extends UnsafeAccessNode {
        GetInt() {
        }

        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        int doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getInt(address);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetShort
    extends UnsafeAccessNode {
        GetShort() {
        }

        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        short doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getShort(address);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetChar
    extends UnsafeAccessNode {
        GetChar() {
        }

        abstract char execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        char doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getChar(address);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class GetByte
    extends UnsafeAccessNode {
        GetByte() {
        }

        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2);

        @Specialization
        byte doCached(@JavaType(value=Unsafe.class) StaticObject self, long address) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getByte(address);
        }
    }

    @Substitution(hasReceiver=true, methodName="getLongVolatile")
    @InlineInBytecode
    public static abstract class GetLongVolatileWithBase
    extends UnsafeAccessNode {
        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected long doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getLongVolatile(GetLongVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected long doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Long) {
                return f.getLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsLong(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getDoubleVolatile")
    @InlineInBytecode
    public static abstract class GetDoubleVolatileWithBase
    extends UnsafeAccessNode {
        abstract double execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected double doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getDoubleVolatile(GetDoubleVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected double doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Double) {
                return f.getDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsDouble(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getFloatVolatile")
    @InlineInBytecode
    public static abstract class GetFloatVolatileWithBase
    extends UnsafeAccessNode {
        abstract float execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected float doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getFloatVolatile(GetFloatVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected float doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Float) {
                return f.getFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsFloat(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getIntVolatile")
    @InlineInBytecode
    public static abstract class GetIntVolatileWithBase
    extends UnsafeAccessNode {
        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected int doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getIntVolatile(GetIntVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected int doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Int) {
                return f.getInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsInt(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getShortVolatile")
    @InlineInBytecode
    public static abstract class GetShortVolatileWithBase
    extends UnsafeAccessNode {
        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected short doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getShortVolatile(GetShortVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected short doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Short) {
                return f.getShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsShort(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getCharVolatile")
    @InlineInBytecode
    public static abstract class GetCharVolatileWithBase
    extends UnsafeAccessNode {
        abstract char execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected char doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getCharVolatile(GetCharVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected char doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Char) {
                return f.getChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsChar(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getBooleanVolatile")
    @InlineInBytecode
    public static abstract class GetBooleanVolatileWithBase
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getBooleanVolatile(GetBooleanVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Boolean) {
                return f.getBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsBoolean(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="getObjectVolatile")
    @InlineInBytecode
    public static abstract class GetObjectVolatileWithBase
    extends UnsafeAccessNode {
        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected @JavaType(value=Object.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return (StaticObject)UnsafeAccess.getIfAllowed(this.getMeta()).getObjectVolatile(GetObjectVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Object) {
                return f.getObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsObject(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getByteVolatile")
    @InlineInBytecode
    public static abstract class GetByteVolatileWithBase
    extends UnsafeAccessNode {
        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected byte doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getByteVolatile(GetByteVolatileWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected byte doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Byte) {
                return f.getByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), true);
            }
            return f.getAsByte(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="getLong")
    @InlineInBytecode
    public static abstract class GetLongWithBase
    extends UnsafeAccessNode {
        abstract long execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected long doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getLong(GetLongWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected long doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Long) {
                return f.getLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsLong(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, methodName="getDouble")
    @InlineInBytecode
    public static abstract class GetDoubleWithBase
    extends UnsafeAccessNode {
        abstract double execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected double doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getDouble(GetDoubleWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected double doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Double) {
                return f.getDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsDouble(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, methodName="getFloat")
    @InlineInBytecode
    public static abstract class GetFloatWithBase
    extends UnsafeAccessNode {
        abstract float execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected float doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getFloat(GetFloatWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected float doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Float) {
                return f.getFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsFloat(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, methodName="getInt")
    @InlineInBytecode
    public static abstract class GetIntWithBase
    extends UnsafeAccessNode {
        abstract int execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected int doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getInt(GetIntWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected int doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Int) {
                return f.getInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsInt(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, methodName="getShort")
    @InlineInBytecode
    public static abstract class GetShortWithBase
    extends UnsafeAccessNode {
        abstract short execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected short doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getShort(GetShortWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected short doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Short) {
                return f.getShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsShort(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, methodName="getChar")
    @InlineInBytecode
    public static abstract class GetCharWithBase
    extends UnsafeAccessNode {
        abstract char execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected char doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getChar(GetCharWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected char doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Char) {
                return f.getChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsChar(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, methodName="getBoolean")
    @InlineInBytecode
    public static abstract class GetBooleanWithBase
    extends UnsafeAccessNode {
        abstract boolean execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected boolean doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getBoolean(GetBooleanWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected boolean doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Boolean) {
                return f.getBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsBoolean(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="getObject")
    @InlineInBytecode
    public static abstract class GetObjectWithBase
    extends UnsafeAccessNode {
        abstract @JavaType(value=Object.class) StaticObject execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected @JavaType(value=Object.class) StaticObject doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return (StaticObject)UnsafeAccess.getIfAllowed(this.getMeta()).getObject(GetObjectWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected @JavaType(value=Object.class) StaticObject doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Object) {
                return f.getObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsObject(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
        }
    }

    @Substitution(hasReceiver=true, methodName="getByte")
    @InlineInBytecode
    public static abstract class GetByteWithBase
    extends UnsafeAccessNode {
        abstract byte execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected byte doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset) {
            return UnsafeAccess.getIfAllowed(this.getMeta()).getByte(GetByteWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected byte doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            if (f.getKind() == JavaKind.Byte) {
                return f.getByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()));
            }
            return f.getAsByte(this.getMeta(), Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), false);
        }
    }

    @Substitution(hasReceiver=true)
    @InlineInBytecode
    public static abstract class PutOrderedObject
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putOrderedObject(PutOrderedObject.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true)
    @InlineInBytecode
    public static abstract class PutOrderedLong
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putOrderedLong(PutOrderedLong.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true)
    @InlineInBytecode
    public static abstract class PutOrderedInt
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putOrderedInt(PutOrderedInt.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value, true);
        }
    }

    @Substitution(hasReceiver=true, methodName="putLong")
    @InlineInBytecode
    public static abstract class PutLongWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, long var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putLong(PutLongWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, long value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setLong(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putDouble")
    @InlineInBytecode
    public static abstract class PutDoubleWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, double var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putDouble(PutDoubleWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, double value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setDouble(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putFloat")
    @InlineInBytecode
    public static abstract class PutFloatWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, float var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putFloat(PutFloatWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, float value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setFloat(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putInt")
    @InlineInBytecode
    public static abstract class PutIntWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, int var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putInt(PutIntWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, int value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setInt(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putShort")
    @InlineInBytecode
    public static abstract class PutShortWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, short var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putShort(PutShortWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, short value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setShort(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putChar")
    @InlineInBytecode
    public static abstract class PutCharWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, char var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putChar(PutCharWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, char value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setChar(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putBoolean")
    @InlineInBytecode
    public static abstract class PutBooleanWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, boolean var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putBoolean(PutBooleanWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, boolean value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setBoolean(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, nameProvider=SharedUnsafeObjectAccessToReference.class, methodName="putObject")
    @InlineInBytecode
    public static abstract class PutObjectWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, @JavaType(value=Object.class) StaticObject var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putObject(PutObjectWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, @JavaType(value=Object.class) StaticObject value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setObject(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true, methodName="putByte")
    @InlineInBytecode
    public static abstract class PutByteWithBase
    extends UnsafeAccessNode {
        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2, long var3, byte var5);

        @Specialization(guards={"isNullOrArray(holder)"})
        protected void doNullOrArray(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putByte(PutByteWithBase.unwrapNullOrArray(this.getLanguage(), holder), offset, value);
        }

        @Specialization(guards={"!isNullOrArray(holder)"})
        protected void doGeneric(@JavaType(value=Unsafe.class) StaticObject self, @JavaType(value=Object.class) StaticObject holder, long offset, byte value, @Cached GetFieldFromIndexNode getField) {
            com.oracle.truffle.espresso.impl.Field f = getField.execute(holder, offset);
            if (f == null) {
                Target_sun_misc_Unsafe.throwUnsupported(this.getMeta(), "Raw unaligned unsafe access.");
            }
            f.setByte(Target_sun_misc_Unsafe.resolveUnsafeAccessHolder(f, holder, this.getMeta()), value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutLong
    extends UnsafeAccessNode {
        PutLong() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, long var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, long value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putLong(address, value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutDouble
    extends UnsafeAccessNode {
        PutDouble() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, double var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, double value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putDouble(address, value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutFloat
    extends UnsafeAccessNode {
        PutFloat() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, float var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, float value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putFloat(address, value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutInt
    extends UnsafeAccessNode {
        PutInt() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, int var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, int value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putInt(address, value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutShort
    extends UnsafeAccessNode {
        PutShort() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, short var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, short value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putShort(address, value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutChar
    extends UnsafeAccessNode {
        PutChar() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, char var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, char value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putChar(address, value);
        }
    }

    @Substitution(hasReceiver=true)
    static abstract class PutByte
    extends UnsafeAccessNode {
        PutByte() {
        }

        abstract void execute(@JavaType(value=Unsafe.class) StaticObject var1, long var2, byte var4);

        @Specialization
        void doCached(@JavaType(value=Unsafe.class) StaticObject self, long address, byte value) {
            UnsafeAccess.getIfAllowed(this.getMeta()).putByte(address, value);
        }
    }

    static abstract class UnsafeAccessNode
    extends SubstitutionNode {
        UnsafeAccessNode() {
        }

        protected static boolean isNullOrArray(StaticObject object) {
            return StaticObject.isNull(object) || object.isArray();
        }

        protected static Object unwrapNullOrArray(EspressoLanguage language, StaticObject object) {
            assert (UnsafeAccessNode.isNullOrArray(object));
            if (StaticObject.isNull(object)) {
                return null;
            }
            return object.unwrap(language);
        }
    }

    static abstract class GetFieldFromIndexNode
    extends EspressoNode {
        static final int LIMIT = 3;

        GetFieldFromIndexNode() {
        }

        abstract com.oracle.truffle.espresso.impl.Field execute(StaticObject var1, long var2);

        @Specialization(guards={"slot == cachedSlot", "holder.isStaticStorage() == cachedIsStaticStorage", "holder.getKlass() == cachedKlass"}, limit="LIMIT")
        protected com.oracle.truffle.espresso.impl.Field doCached(StaticObject holder, long slot, @Cached(value="slot") long cachedSlot, @Cached(value="holder.getKlass()") Klass cachedKlass, @Cached(value="holder.isStaticStorage()") boolean cachedIsStaticStorage, @Cached(value="doGeneric(holder, slot)") com.oracle.truffle.espresso.impl.Field cachedField) {
            return cachedField;
        }

        @Specialization(replaces={"doCached"})
        protected com.oracle.truffle.espresso.impl.Field doGeneric(StaticObject holder, long slot) {
            return Target_sun_misc_Unsafe.resolveUnsafeAccessField(holder, slot, this.getMeta());
        }

        public static GetFieldFromIndexNode create() {
            return Target_sun_misc_UnsafeFactory.GetFieldFromIndexNodeGen.create();
        }
    }
}

