/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.ModuleExtension;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import java.nio.file.Path;
import java.util.ArrayList;

@EspressoSubstitutions
final class Target_jdk_internal_module_SystemModuleFinders {
    Target_jdk_internal_module_SystemModuleFinders() {
    }

    @CompilerDirectives.TruffleBoundary
    private static StaticObject getEspressoExtensionPaths(EspressoContext context) {
        ArrayList<StaticObject> extensionPaths = new ArrayList<StaticObject>(2);
        for (ModuleExtension me : ModuleExtension.get(context)) {
            extensionPaths.add(Target_jdk_internal_module_SystemModuleFinders.getEspressoModulePath(context, me.jarName()));
        }
        if (extensionPaths.isEmpty()) {
            return StaticObject.NULL;
        }
        return context.getMeta().java_nio_file_Path.allocateReferenceArray(extensionPaths.size(), extensionPaths::get);
    }

    @CompilerDirectives.TruffleBoundary
    private static StaticObject extendModuleFinders(EspressoLanguage language, Meta meta, StaticObject moduleFinder, StaticObject pathArray) {
        StaticObject extension = (StaticObject)meta.jdk_internal_module_ModulePath_of.invokeDirect(StaticObject.NULL, pathArray);
        StaticObject moduleFinderArray = meta.java_lang_module_ModuleFinder.allocateReferenceArray(2);
        StaticObject[] unwrapped = (StaticObject[])moduleFinderArray.unwrap(language);
        unwrapped[0] = extension;
        unwrapped[1] = moduleFinder;
        return (StaticObject)meta.java_lang_module_ModuleFinder_compose.invokeDirect(StaticObject.NULL, moduleFinderArray);
    }

    @CompilerDirectives.TruffleBoundary
    private static StaticObject getEspressoModulePath(EspressoContext context, String jarName) {
        Path jar = context.getEspressoLibs().resolve(jarName);
        Meta meta = context.getMeta();
        StaticObject guestPath = meta.toGuestString(jar.toFile().getAbsolutePath());
        StaticObject emptyArray = meta.java_nio_file_Path.allocateReferenceArray(0);
        return (StaticObject)meta.java_nio_file_Paths_get.invokeDirect(StaticObject.NULL, guestPath, emptyArray);
    }

    @Substitution
    static abstract class OfSystem
    extends SubstitutionNode {
        OfSystem() {
        }

        abstract @JavaType(internalName="Ljava/lang/module/ModuleFinder;") StaticObject execute();

        @Specialization
        @JavaType(internalName="Ljava/lang/module/ModuleFinder;") StaticObject doDefault(@Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.jdk_internal_module_SystemModuleFinders_ofSystem.getCallTargetNoSubstitution())") DirectCallNode original) {
            StaticObject moduleFinder = (StaticObject)original.call(new Object[0]);
            StaticObject extensionPathArray = Target_jdk_internal_module_SystemModuleFinders.getEspressoExtensionPaths(this.getContext());
            if (extensionPathArray != StaticObject.NULL) {
                moduleFinder = Target_jdk_internal_module_SystemModuleFinders.extendModuleFinders(this.getLanguage(), meta, moduleFinder, extensionPathArray);
            }
            return moduleFinder;
        }
    }

    @Substitution
    static abstract class Of
    extends SubstitutionNode {
        Of() {
        }

        abstract @JavaType(internalName="Ljava/lang/module/ModuleFinder;") StaticObject execute(@JavaType(internalName="Ljdk/internal/module/SystemModules;") StaticObject var1);

        @Specialization
        @JavaType(internalName="Ljava/lang/module/ModuleFinder;") StaticObject doDefault(@JavaType(internalName="Ljdk/internal/module/SystemModules;") StaticObject systemModules, @Bind(value="getMeta()") Meta meta, @Cached(value="create(meta.jdk_internal_module_SystemModuleFinders_of.getCallTargetNoSubstitution())") DirectCallNode original) {
            StaticObject moduleFinder = (StaticObject)original.call(new Object[]{systemModules});
            StaticObject extensionPathArray = Target_jdk_internal_module_SystemModuleFinders.getEspressoExtensionPaths(this.getContext());
            if (extensionPathArray != StaticObject.NULL) {
                moduleFinder = Target_jdk_internal_module_SystemModuleFinders.extendModuleFinders(this.getLanguage(), meta, moduleFinder, extensionPathArray);
            }
            return moduleFinder;
        }
    }
}

