/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.helper.TypeCheckNode;
import com.oracle.truffle.espresso.nodes.helper.TypeCheckNodeGen;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNode;
import com.oracle.truffle.espresso.nodes.interop.ToEspressoNodeFactory;
import com.oracle.truffle.espresso.perf.DebugCounter;
import com.oracle.truffle.espresso.runtime.EspressoException;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;
import com.oracle.truffle.espresso.substitutions.SubstitutionProfiler;
import com.oracle.truffle.espresso.vm.VM;

@EspressoSubstitutions
public final class Target_java_lang_System {
    private static final DebugCounter SYSTEM_ARRAYCOPY_COUNT = DebugCounter.create("System.arraycopy call count");
    private static final DebugCounter SYSTEM_IDENTITY_HASH_CODE_COUNT = DebugCounter.create("System.identityHashCode call count");
    private static final int ZERO_LENGTH_PROFILE = 0;
    private static final int FOREIGN_PROFILE = 1;
    private static final int GUEST_PROFILE = 2;
    private static final int SAME_ARRAY_PROFILE = 3;
    private static final int DIFF_ARRAY_PROFILE = 4;
    private static final int DIFF_PRIMITIVE_ARRAYS_PROFILE = 5;
    private static final int DIFF_REFERENCE_ARRAYS_PROFILE = 6;
    private static final int SUBTYPE_ARRAYS_PROFILE = 7;
    private static final int UNRELATED_TYPE_ARRAYS_PROFILE = 8;
    private static final int ARRAYSTORE_PROFILE = 13;
    private static final int INDEXOUTOFBOUNDS_PROFILE = 14;
    private static final int NULLPOINTER_PROFILE = 15;

    @Substitution(isTrivial=true)
    public static int identityHashCode(@JavaType(value=Object.class) StaticObject self, @Inject EspressoLanguage lang) {
        SYSTEM_IDENTITY_HASH_CODE_COUNT.inc();
        return VM.JVM_IHashCode(self, lang);
    }

    public static void arraycopy(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
        SYSTEM_ARRAYCOPY_COUNT.inc();
        try {
            Target_java_lang_System.doArrayCopy(src, srcPos, dest, destPos, length, language, meta, profiler);
        }
        catch (NullPointerException e) {
            throw Target_java_lang_System.throwNullPointerEx(meta, profiler);
        }
        catch (ArrayStoreException e) {
            throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
        }
    }

    private static void doArrayCopy(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, EspressoLanguage language, Meta meta, SubstitutionProfiler profiler) {
        if (StaticObject.isNull(src) || StaticObject.isNull(dest)) {
            throw Target_java_lang_System.throwNullPointerEx(meta, profiler);
        }
        if (src.isForeignObject() || dest.isForeignObject()) {
            profiler.profile(1);
            Target_java_lang_System.handleForeignArray(src.isForeignObject() ? src.rawForeignObject(language) : src, srcPos, dest.isForeignObject() ? dest.rawForeignObject(language) : dest, destPos, length, ((ArrayKlass)dest.getKlass()).getComponentType(), meta, profiler);
            return;
        }
        profiler.profile(2);
        if (!src.isArray() || !dest.isArray()) {
            throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
        }
        if (src == dest) {
            profiler.profile(3);
            System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            return;
        }
        profiler.profile(4);
        Klass destType = ((ArrayKlass)dest.getKlass()).getComponentType();
        Klass srcType = ((ArrayKlass)src.getKlass()).getComponentType();
        if (destType.isPrimitive() || srcType.isPrimitive()) {
            profiler.profile(5);
            if (srcType != destType) {
                throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
            }
            System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            return;
        }
        profiler.profile(6);
        Target_java_lang_System.boundsCheck(meta, src.length(language), srcPos, dest.length(language), destPos, length, profiler);
        if (length == 0) {
            profiler.profile(0);
            return;
        }
        if (destType.isAssignableFrom(srcType)) {
            profiler.profile(7);
            System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            return;
        }
        profiler.profile(8);
        StaticObject[] s = (StaticObject[])src.unwrap(language);
        StaticObject[] d = (StaticObject[])dest.unwrap(language);
        for (int i = 0; i < length; ++i) {
            StaticObject cpy = s[i + srcPos];
            if (!StaticObject.isNull(cpy) && !destType.isAssignableFrom(cpy.getKlass())) {
                throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
            }
            d[destPos + i] = cpy;
        }
    }

    public static EspressoException throwNullPointerEx(Meta meta, SubstitutionProfiler profiler) {
        profiler.profile(15);
        throw Target_java_lang_System.throwException(meta, meta.java_lang_NullPointerException);
    }

    private static EspressoException throwOutOfBoundsEx(Meta meta, SubstitutionProfiler profiler) {
        profiler.profile(14);
        throw Target_java_lang_System.throwException(meta, meta.java_lang_ArrayIndexOutOfBoundsException);
    }

    private static EspressoException throwArrayStoreEx(Meta meta, SubstitutionProfiler profiler) {
        profiler.profile(13);
        throw Target_java_lang_System.throwException(meta, meta.java_lang_ArrayStoreException);
    }

    @CompilerDirectives.TruffleBoundary
    private static EspressoException throwException(Meta meta, ObjectKlass exceptionKlass) {
        throw meta.throwException(exceptionKlass);
    }

    @CompilerDirectives.TruffleBoundary
    private static void handleForeignArray(Object src, int srcPos, Object dest, int destPos, int length, Klass destType, Meta meta, SubstitutionProfiler profiler) {
        InteropLibrary library = InteropLibrary.getUncached();
        ToEspressoNode.DynamicToEspresso toEspressoNode = ToEspressoNodeFactory.DynamicToEspressoNodeGen.getUncached();
        if (library.isNull(src) || library.isNull(dest)) {
            throw Target_java_lang_System.throwNullPointerEx(meta, profiler);
        }
        if (!library.hasArrayElements(src) || !library.hasArrayElements(dest)) {
            throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
        }
        try {
            int srclen = (int)library.getArraySize(src);
            int destlen = (int)library.getArraySize(dest);
            Target_java_lang_System.boundsCheck(meta, srclen, srcPos, destlen, destPos, length, profiler);
            for (int i = 0; i < length; ++i) {
                Object cpy = toEspressoNode.execute(library.readArrayElement(src, (long)(i + srcPos)), destType);
                library.writeArrayElement(dest, (long)(destPos + i), cpy);
            }
        }
        catch (UnsupportedMessageException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
        catch (InvalidArrayIndexException e) {
            throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
        }
    }

    private static void boundsCheck(Meta meta, int srcLen, int srcPos, int dstLen, int destPos, int length, SubstitutionProfiler profiler) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos > srcLen - length || destPos > dstLen - length) {
            throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @Substitution(isTrivial=true)
    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @Substitution(isTrivial=true)
    public static long nanoTime() {
        return System.nanoTime();
    }

    @ReportPolymorphism
    @Substitution
    static abstract class Arraycopy
    extends SubstitutionNode {
        @Node.Child
        TypeCheckNode compatibleReferenceArrayTypeCheck = (TypeCheckNode)this.insert(TypeCheckNodeGen.create());

        Arraycopy() {
        }

        abstract void execute(@JavaType(value=Object.class) StaticObject var1, int var2, @JavaType(value=Object.class) StaticObject var3, int var4, int var5, @Inject EspressoLanguage var6, @Inject Meta var7, @Inject SubstitutionProfiler var8);

        static boolean isNull(StaticObject obj) {
            return StaticObject.isNull(obj);
        }

        static boolean nullOrNotArray(StaticObject src, StaticObject dest) {
            return StaticObject.isNull(src) || StaticObject.isNull(dest) || !src.isArray() || !dest.isArray();
        }

        static boolean foreignArgument(StaticObject src, StaticObject dest) {
            return src.isForeignObject() || dest.isForeignObject();
        }

        static boolean isPrimitiveArray(StaticObject maybeArray) {
            return ((ArrayKlass)maybeArray.getKlass()).getComponentType().isPrimitive();
        }

        static boolean hasDifferentPrimitiveArrayInput(StaticObject src, StaticObject dest) {
            return src.getKlass() != dest.getKlass() && (Arraycopy.isPrimitiveArray(src) || Arraycopy.isPrimitiveArray(dest));
        }

        static boolean areCompatiblePrimitiveArrays(StaticObject src, StaticObject dest, ArrayKlass arrayKlass) {
            return src.getKlass() == arrayKlass && dest.getKlass() == src.getKlass();
        }

        final boolean areCompatibleReferenceArrays(StaticObject src, StaticObject dest) {
            return this.compatibleReferenceArrayTypeCheck.executeTypeCheck(Arraycopy.getComponentType(dest), Arraycopy.getComponentType(src));
        }

        static Klass getComponentType(StaticObject array) {
            assert (array.isArray());
            return ((ArrayKlass)array.getKlass()).getComponentType();
        }

        @Specialization(guards={"nullOrNotArray(src, dest)"})
        void doEarlyError(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            if (StaticObject.isNull(src) || StaticObject.isNull(dest)) {
                throw meta.throwNullPointerException();
            }
            if (!src.isArray() || !dest.isArray()) {
                throw meta.throwException(meta.java_lang_ArrayStoreException);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("expected null or non-array input");
        }

        @Specialization(guards={"foreignArgument(src, dest)"})
        void doForeign(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            Target_java_lang_System.handleForeignArray(src.isForeignObject() ? src.rawForeignObject(language) : src, srcPos, dest.isForeignObject() ? dest.rawForeignObject(language) : dest, destPos, length, ((ArrayKlass)dest.getKlass()).getComponentType(), meta, profiler);
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._byte_array) || areCompatiblePrimitiveArrays(src, dest, meta._boolean_array)", "!foreignArgument(src, dest)"})
        void doByteArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._int_array)", "!foreignArgument(src, dest)"})
        void doIntArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._double_array)", "!foreignArgument(src, dest)"})
        void doDoubleArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._long_array)", "!foreignArgument(src, dest)"})
        void doLongArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._char_array)", "!foreignArgument(src, dest)"})
        void doCharArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._short_array)", "!foreignArgument(src, dest)"})
        void doShortArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"areCompatiblePrimitiveArrays(src, dest, meta._float_array)", "!foreignArgument(src, dest)"})
        void doFloatArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"!isNull(src)", "!isNull(dest)", "!foreignArgument(src, dest)", "hasDifferentPrimitiveArrayInput(src, dest)"})
        void doPrimitiveArrayMismatch(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
        }

        @Specialization(guards={"src == dest", "!isPrimitiveArray(src)", "!src.isForeignObject()"})
        void doSameArray(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"length == 0", "!nullOrNotArray(src, dest)", "!isPrimitiveArray(src)", "!isPrimitiveArray(dest)", "!foreignArgument(src, dest)"})
        void doZeroLen(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            Target_java_lang_System.boundsCheck(meta, src.length(language), srcPos, dest.length(language), destPos, length, profiler);
        }

        @Specialization(guards={"!nullOrNotArray(src, dest)", "!foreignArgument(src, dest)", "!isPrimitiveArray(src)", "!isPrimitiveArray(dest)", "areCompatibleReferenceArrays(src, dest)"})
        void doCompatibleReferenceArrays(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            try {
                System.arraycopy(src.unwrap(language), srcPos, dest.unwrap(language), destPos, length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw Target_java_lang_System.throwOutOfBoundsEx(meta, profiler);
            }
        }

        @Specialization(guards={"!nullOrNotArray(src, dest)", "!foreignArgument(src, dest)", "!isPrimitiveArray(src)", "!isPrimitiveArray(dest)", "!areCompatibleReferenceArrays(src, dest)"})
        void doIncompatibleReferenceArrays(@JavaType(value=Object.class) StaticObject src, int srcPos, @JavaType(value=Object.class) StaticObject dest, int destPos, int length, @Inject EspressoLanguage language, @Inject Meta meta, @Inject SubstitutionProfiler profiler, @Cached TypeCheckNode copyTypeCheck) {
            SYSTEM_ARRAYCOPY_COUNT.inc();
            Target_java_lang_System.boundsCheck(meta, src.length(language), srcPos, dest.length(language), destPos, length, profiler);
            Klass destType = ((ArrayKlass)dest.getKlass()).getComponentType();
            StaticObject[] s = (StaticObject[])src.unwrap(language);
            StaticObject[] d = (StaticObject[])dest.unwrap(language);
            for (int i = 0; i < length; ++i) {
                StaticObject cpy = s[i + srcPos];
                if (!StaticObject.isNull(cpy) && !copyTypeCheck.executeTypeCheck(destType, cpy.getKlass())) {
                    throw Target_java_lang_System.throwArrayStoreEx(meta, profiler);
                }
                d[destPos + i] = cpy;
            }
        }
    }
}

