/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.helper.TypeCheckNode;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.EspressoSubstitutions;
import com.oracle.truffle.espresso.substitutions.Inject;
import com.oracle.truffle.espresso.substitutions.JavaType;
import com.oracle.truffle.espresso.substitutions.Substitution;
import com.oracle.truffle.espresso.substitutions.SubstitutionNode;

@EspressoSubstitutions
public final class Target_java_lang_Class {
    @Substitution(hasReceiver=true)
    public static boolean isInterface(@JavaType(value=Class.class) StaticObject self, @Inject Meta meta) {
        return meta.getVM().JVM_IsInterface(self);
    }

    @Substitution(hasReceiver=true)
    public static boolean isPrimitive(@JavaType(value=Class.class) StaticObject self, @Inject Meta meta) {
        return meta.getVM().JVM_IsPrimitiveClass(self);
    }

    @Substitution(hasReceiver=true)
    public static boolean isArray(@JavaType(value=Class.class) StaticObject self, @Inject Meta meta) {
        return meta.getVM().JVM_IsArrayClass(self);
    }

    @Substitution(hasReceiver=true)
    public static boolean isHidden(@JavaType(value=Class.class) StaticObject self, @Inject Meta meta) {
        return meta.getVM().JVM_IsHiddenClass(self);
    }

    @Substitution(hasReceiver=true)
    public static @JavaType(value=Class.class) StaticObject getSuperclass(@JavaType(value=Class.class) StaticObject self, @Inject Meta meta) {
        Klass k = self.getMirrorKlass(meta);
        if (k.isInterface()) {
            return StaticObject.NULL;
        }
        ObjectKlass superclass = k.getSuperKlass();
        if (superclass == null) {
            return StaticObject.NULL;
        }
        return superclass.mirror();
    }

    @Substitution(hasReceiver=true)
    public static int getModifiers(@JavaType(value=Class.class) StaticObject self, @Inject Meta meta) {
        return meta.getVM().JVM_GetClassModifiers(self);
    }

    @Substitution(hasReceiver=true, methodName="isAssignableFrom")
    static abstract class IsAssignableFrom
    extends SubstitutionNode {
        IsAssignableFrom() {
        }

        public abstract boolean execute(@JavaType(value=Class.class) StaticObject var1, @JavaType(value=Class.class) StaticObject var2);

        @Specialization(guards={"isNull(cls)"})
        public boolean nullCase(@JavaType(value=Class.class) StaticObject self, @JavaType(value=Object.class) StaticObject cls) {
            throw this.getMeta().throwNullPointerException();
        }

        @Specialization(guards={"!isNull(cls)"})
        public boolean doInstanceOf(@JavaType(value=Class.class) StaticObject self, @JavaType(value=Object.class) StaticObject cls, @Cached TypeCheckNode typeCheckNode) {
            Meta meta = this.getMeta();
            return typeCheckNode.executeTypeCheck(self.getMirrorKlass(meta), cls.getMirrorKlass(meta));
        }

        protected static boolean isNull(StaticObject obj) {
            return StaticObject.isNull(obj);
        }
    }

    @Substitution(hasReceiver=true, methodName="isInstance")
    static abstract class IsInstance
    extends SubstitutionNode {
        IsInstance() {
        }

        public abstract boolean execute(@JavaType(value=Class.class) StaticObject var1, @JavaType(value=Object.class) StaticObject var2);

        @Specialization(guards={"isNull(obj)"})
        public boolean nullCase(@JavaType(value=Class.class) StaticObject self, @JavaType(value=Object.class) StaticObject obj) {
            return false;
        }

        @Specialization(guards={"!isNull(obj)"})
        public boolean doInstanceOf(@JavaType(value=Class.class) StaticObject self, @JavaType(value=Object.class) StaticObject obj, @Cached TypeCheckNode typeCheckNode) {
            return typeCheckNode.executeTypeCheck(self.getMirrorKlass(this.getMeta()), obj.getKlass());
        }

        protected static boolean isNull(StaticObject obj) {
            return StaticObject.isNull(obj);
        }
    }
}

