/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import java.util.ArrayList;
import java.util.function.Function;

public final class ModuleExtension {
    private static final ModuleExtension[] ESPRESSO_EXTENSION_MODULES = new ModuleExtension[]{new ModuleExtension("espresso.hotswap", "hotswap.jar", context -> context.getEspressoEnv().JDWPOptions != null), new ModuleExtension("espresso.polyglot", "espresso-polyglot.jar", context -> context.getEspressoEnv().Polyglot)};
    private static final ModuleExtension[] EMPTY_MODULE_EXTENSION_ARRAY = new ModuleExtension[0];
    private final String moduleName;
    private final String jarName;
    private final Function<EspressoContext, Boolean> isEnabled;

    private ModuleExtension(String moduleName, String jarName, Function<EspressoContext, Boolean> isEnabled) {
        this.moduleName = moduleName;
        this.jarName = jarName;
        this.isEnabled = isEnabled;
    }

    @CompilerDirectives.TruffleBoundary
    public static ModuleExtension[] get(EspressoContext context) {
        ArrayList<ModuleExtension> modules = new ArrayList<ModuleExtension>(ESPRESSO_EXTENSION_MODULES.length);
        for (ModuleExtension me : ESPRESSO_EXTENSION_MODULES) {
            if (!me.isEnabled.apply(context).booleanValue()) continue;
            modules.add(me);
        }
        return modules.toArray(EMPTY_MODULE_EXTENSION_ARRAY);
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String jarName() {
        return this.jarName;
    }
}

