/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.blocking.BlockingSupport;
import com.oracle.truffle.espresso.blocking.EspressoLock;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Field;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.SuppressFBWarnings;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.GuestAllocator;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.SharedInterop;
import java.lang.reflect.Array;

@ExportLibrary(value=DynamicDispatchLibrary.class)
public class StaticObject
implements TruffleObject,
Cloneable {
    public static final StaticObject[] EMPTY_ARRAY = new StaticObject[0];
    public static final StaticObject NULL = new StaticObject(null);
    public static final String CLASS_TO_STATIC = "static";
    private static final EspressoLock FOREIGN_MARKER = EspressoLock.create(BlockingSupport.UNINTERRUPTIBLE);
    private final Klass klass;
    private EspressoLock lockOrForeignMarker;

    protected StaticObject(Klass klass) {
        this(klass, false);
    }

    protected StaticObject(Klass klass, boolean isForeign) {
        if (isForeign) {
            this.lockOrForeignMarker = FOREIGN_MARKER;
        }
        this.klass = klass;
    }

    @CompilerDirectives.TruffleBoundary
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final boolean isString() {
        return StaticObject.notNull(this) && this.getKlass() == this.getKlass().getMeta().java_lang_String;
    }

    public static boolean isNull(StaticObject object) {
        assert (object != null);
        assert (object.getKlass() != null || object == NULL || object.isForeignObject() && InteropLibrary.getUncached().isNull(object.rawForeignObject(EspressoLanguage.get(null)))) : "klass can only be null for Espresso null (NULL) and interop nulls";
        return object.getKlass() == null;
    }

    @ExportMessage
    public final Class<?> dispatch() {
        if (StaticObject.isNull(this) || this.isForeignObject()) {
            return BaseInterop.class;
        }
        if (this.getKlass().getContext().getLanguage().isShared()) {
            return SharedInterop.class;
        }
        return this.getKlass().getDispatch();
    }

    public final Klass getKlass() {
        return this.klass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DC"}, justification="Implementations of EspressoLock have only final and volatile fields")
    public final EspressoLock getLock(EspressoContext context) {
        this.checkNotForeign();
        if (StaticObject.isNull(this)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("StaticObject.NULL.getLock()");
        }
        EspressoLock l = this.lockOrForeignMarker;
        if (l == null) {
            StaticObject staticObject = this;
            synchronized (staticObject) {
                l = this.lockOrForeignMarker;
                if (l == null) {
                    this.lockOrForeignMarker = l = EspressoLock.create(context.getBlockingSupport());
                }
            }
        }
        return l;
    }

    public static boolean notNull(StaticObject object) {
        return !StaticObject.isNull(object);
    }

    public final void checkNotForeign() {
        assert (this.checkNotForeignImpl());
    }

    private boolean checkNotForeignImpl() {
        if (this.isForeignObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Unexpected foreign object");
        }
        return true;
    }

    public final boolean isForeignObject() {
        return this.lockOrForeignMarker == FOREIGN_MARKER;
    }

    public final boolean isEspressoObject() {
        return !this.isForeignObject();
    }

    public final Object rawForeignObject(EspressoLanguage language) {
        assert (this.isForeignObject());
        return language.getForeignProperty().getObject((Object)this);
    }

    public final boolean isStaticStorage() {
        return this == this.getKlass().getStatics();
    }

    public final Klass getMirrorKlass() {
        return this.getMirrorKlass(this.getKlass().getMeta());
    }

    public final boolean isMirrorKlass() {
        return this.getKlass().getType() == Symbol.Type.java_lang_Class && !this.isStaticStorage();
    }

    public final Klass getMirrorKlass(Meta meta) {
        assert (this.isMirrorKlass());
        this.checkNotForeign();
        Klass result = (Klass)meta.HIDDEN_MIRROR_KLASS.getHiddenObject(this);
        assert (result != null) : "Uninitialized mirror class";
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public final String toString() {
        if (this == NULL) {
            return "null";
        }
        if (this.isForeignObject()) {
            return "foreign object: " + this.getKlass().getTypeAsString();
        }
        Meta meta = this.getKlass().getMeta();
        if (this.getKlass() == meta.java_lang_String) {
            StaticObject value = meta.java_lang_String_value.getObject(this);
            if (value == null || StaticObject.isNull(value)) {
                return "<UNINITIALIZED>";
            }
            return Meta.toHostStringStatic(this);
        }
        if (this.isArray()) {
            return this.unwrap(meta.getLanguage()).toString();
        }
        if (this.isStaticStorage()) {
            return "statics: " + this.getKlass().getType();
        }
        if (this.isMirrorKlass()) {
            return "mirror: " + this.getMirrorKlass().getType();
        }
        return this.getKlass().getType().toString();
    }

    @CompilerDirectives.TruffleBoundary
    public final String toVerboseString() {
        if (this == NULL) {
            return "null";
        }
        if (this.getKlass() == null) {
            return "foreign object: null";
        }
        if (this.isForeignObject()) {
            return String.format("foreign object: %s\n%s", this.getKlass().getTypeAsString(), InteropLibrary.getUncached().toDisplayString(this.rawForeignObject(this.getKlass().getContext().getLanguage())));
        }
        Meta meta = this.getKlass().getMeta();
        if (this.getKlass() == meta.java_lang_String) {
            StaticObject value = meta.java_lang_String_value.getObject(this);
            if (value == null || StaticObject.isNull(value)) {
                return "<UNINITIALIZED>";
            }
            return Meta.toHostStringStatic(this);
        }
        if (this.isArray()) {
            return this.unwrap(meta.getLanguage()).toString();
        }
        if (this.getKlass() == meta.java_lang_Class) {
            return "mirror: " + this.getMirrorKlass().toString();
        }
        StringBuilder str = new StringBuilder(this.getKlass().getType().toString());
        for (Field f : ((ObjectKlass)this.getKlass()).getFieldTable()) {
            if (f.isRemoved()) continue;
            str.append("\n    ").append(f.getName()).append(": ").append(f.get(this).toString());
        }
        return str.toString();
    }

    private Object getArray(EspressoLanguage language) {
        return language.getArrayProperty().getObject((Object)this);
    }

    public final <T> T unwrap(EspressoLanguage language) {
        this.checkNotForeign();
        assert (this.isArray());
        return (T)this.getArray(language);
    }

    public final <T> T get(EspressoLanguage language, int index) {
        this.checkNotForeign();
        assert (this.isArray());
        return (T)((Object[])this.unwrap(language))[index];
    }

    public final int length(EspressoLanguage language) {
        this.checkNotForeign();
        assert (this.isArray());
        return Array.getLength(this.getArray(language));
    }

    public final Object cloneWrappedArray(EspressoLanguage language) {
        this.checkNotForeign();
        assert (this.isArray());
        Object array = this.getArray(language);
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        return ((Object[])array).clone();
    }

    public final StaticObject copy(EspressoContext context) {
        return context.getAllocator().copy(this);
    }

    public static StaticObject createForeign(EspressoLanguage language, Klass klass, Object value, InteropLibrary library) {
        return GuestAllocator.createForeign(language, klass, value, library);
    }

    public static StaticObject createForeignException(EspressoContext context, Object value, InteropLibrary library) {
        return context.getAllocator().createForeignException(context, value, library);
    }

    public static StaticObject createForeignNull(EspressoLanguage language, Object value) {
        return GuestAllocator.createForeignNull(language, value);
    }

    public static StaticObject createArray(ArrayKlass klass, Object array, EspressoContext context) {
        return context.getAllocator().wrapArrayAs(klass, array);
    }

    public static StaticObject wrap(StaticObject[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta.java_lang_Object_array, array);
    }

    public static StaticObject wrap(ArrayKlass klass, StaticObject[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(klass, array);
    }

    public static StaticObject wrap(byte[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._byte_array, array);
    }

    public static StaticObject wrap(char[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._char_array, array);
    }

    public static StaticObject wrap(short[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._short_array, array);
    }

    public static StaticObject wrap(int[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._int_array, array);
    }

    public static StaticObject wrap(float[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._float_array, array);
    }

    public static StaticObject wrap(double[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._double_array, array);
    }

    public static StaticObject wrap(long[] array, Meta meta) {
        return meta.getAllocator().wrapArrayAs(meta._long_array, array);
    }

    public static StaticObject wrapPrimitiveArray(Object array, Meta meta) {
        assert (array != null);
        assert (array.getClass().isArray() && array.getClass().getComponentType().isPrimitive());
        if (array instanceof boolean[]) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere("Cannot wrap a boolean[]. Create a byte[] and call `StaticObject.createArray(meta._boolean_array, byteArray)`.");
        }
        if (array instanceof byte[]) {
            return StaticObject.wrap((byte[])array, meta);
        }
        if (array instanceof char[]) {
            return StaticObject.wrap((char[])array, meta);
        }
        if (array instanceof short[]) {
            return StaticObject.wrap((short[])array, meta);
        }
        if (array instanceof int[]) {
            return StaticObject.wrap((int[])array, meta);
        }
        if (array instanceof float[]) {
            return StaticObject.wrap((float[])array, meta);
        }
        if (array instanceof double[]) {
            return StaticObject.wrap((double[])array, meta);
        }
        if (array instanceof long[]) {
            return StaticObject.wrap((long[])array, meta);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw EspressoError.shouldNotReachHere("Not a primitive array " + array);
    }

    public final boolean isArray() {
        return !StaticObject.isNull(this) && this.getKlass().isArray();
    }

    public static interface StaticObjectFactory {
        public StaticObject create(Klass var1);

        public StaticObject create(Klass var1, boolean var2);
    }
}

