/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama.x64;

import com.oracle.truffle.espresso.ffi.NativeType;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.panama.StorageType;

public final class X64StorageType
extends Enum<X64StorageType>
implements StorageType {
    public static final /* enum */ X64StorageType INTEGER = new X64StorageType();
    public static final /* enum */ X64StorageType VECTOR = new X64StorageType();
    public static final /* enum */ X64StorageType X87 = new X64StorageType();
    public static final /* enum */ X64StorageType STACK = new X64StorageType();
    public static final /* enum */ X64StorageType PLACEHOLDER = new X64StorageType();
    private static final int STORAGE_INTEGER = 0;
    private static final int STORAGE_VECTOR = 1;
    private static final int STORAGE_X87 = 2;
    private static final int STORAGE_STACK = 3;
    private static final int STORAGE_PLACEHOLDER = 4;
    private static final /* synthetic */ X64StorageType[] $VALUES;

    public static X64StorageType[] values() {
        return (X64StorageType[])$VALUES.clone();
    }

    public static X64StorageType valueOf(String name) {
        return Enum.valueOf(X64StorageType.class, name);
    }

    @Override
    public boolean isPlaceholder() {
        return this == PLACEHOLDER;
    }

    @Override
    public boolean isInteger() {
        return this == INTEGER;
    }

    @Override
    public boolean isStack() {
        return this == STACK;
    }

    @Override
    public boolean isVector() {
        return this == VECTOR;
    }

    @Override
    public NativeType asNativeType(short maskOrSize, Klass type) {
        return switch (this) {
            case INTEGER -> {
                if (!$assertionsDisabled && maskOrSize != 15) {
                    throw new AssertionError();
                }
                switch (type.getJavaKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Int: {
                        yield NativeType.INT;
                    }
                    case Long: {
                        yield NativeType.LONG;
                    }
                    case Char: 
                    case Short: 
                    case Byte: 
                    case Boolean: {
                        throw EspressoError.shouldNotReachHere("Unexpected sub-word in INTEGER: " + type);
                    }
                    case Double: 
                    case Float: 
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: 
                }
                throw EspressoError.shouldNotReachHere("Unexpected kind in INTEGER: " + type);
            }
            case VECTOR -> {
                if (!$assertionsDisabled && maskOrSize != 1) {
                    throw new AssertionError();
                }
                switch (type.getJavaKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Float: {
                        yield NativeType.FLOAT;
                    }
                    case Double: {
                        yield NativeType.DOUBLE;
                    }
                    case Int: 
                    case Long: 
                    case Char: 
                    case Short: 
                    case Byte: 
                    case Boolean: 
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: 
                }
                throw EspressoError.shouldNotReachHere("Unexpected kind in VECTOR: " + type);
            }
            case STACK -> {
                if (!$assertionsDisabled && maskOrSize != 8) {
                    throw new AssertionError();
                }
                switch (type.getJavaKind()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Int: {
                        yield NativeType.INT;
                    }
                    case Long: {
                        yield NativeType.LONG;
                    }
                    case Float: {
                        yield NativeType.FLOAT;
                    }
                    case Double: {
                        yield NativeType.DOUBLE;
                    }
                    case Char: 
                    case Short: 
                    case Byte: 
                    case Boolean: {
                        throw EspressoError.shouldNotReachHere("Unexpected sub-word in STACK: " + type);
                    }
                    case Object: 
                    case Void: 
                    case ReturnAddress: 
                    case Illegal: 
                }
                throw EspressoError.shouldNotReachHere("Unexpected kind in STACK: " + type);
            }
            default -> throw EspressoError.shouldNotReachHere("Unsupported " + this);
        };
    }

    public static StorageType get(byte id) {
        return switch (id) {
            case 0 -> INTEGER;
            case 1 -> VECTOR;
            case 2 -> X87;
            case 3 -> STACK;
            case 4 -> PLACEHOLDER;
            default -> throw EspressoError.shouldNotReachHere("Unknown type: " + id);
        };
    }

    public byte getId() {
        return (byte)this.ordinal();
    }

    private static /* synthetic */ X64StorageType[] $values() {
        return new X64StorageType[]{INTEGER, VECTOR, X87, STACK, PLACEHOLDER};
    }

    static {
        $VALUES = X64StorageType.$values();
    }
}

