/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama.x64;

import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import com.oracle.truffle.espresso.runtime.panama.x64.X64StorageType;

final class X64Regs {
    static final short REG64_MASK = 15;
    static final short XMM_MASK = 1;
    static final VMStorage rax = X64Regs.integerRegister(0);
    static final VMStorage rcx = X64Regs.integerRegister(1);
    static final VMStorage rdx = X64Regs.integerRegister(2);
    static final VMStorage rbx = X64Regs.integerRegister(3);
    static final VMStorage rsp = X64Regs.integerRegister(4);
    static final VMStorage rbp = X64Regs.integerRegister(5);
    static final VMStorage rsi = X64Regs.integerRegister(6);
    static final VMStorage rdi = X64Regs.integerRegister(7);
    static final VMStorage r8 = X64Regs.integerRegister(8);
    static final VMStorage r9 = X64Regs.integerRegister(9);
    static final VMStorage r10 = X64Regs.integerRegister(10);
    static final VMStorage r11 = X64Regs.integerRegister(11);
    static final VMStorage r12 = X64Regs.integerRegister(12);
    static final VMStorage r13 = X64Regs.integerRegister(13);
    static final VMStorage r14 = X64Regs.integerRegister(14);
    static final VMStorage r15 = X64Regs.integerRegister(15);
    static final VMStorage xmm0 = X64Regs.vectorRegister(0);
    static final VMStorage xmm1 = X64Regs.vectorRegister(1);
    static final VMStorage xmm2 = X64Regs.vectorRegister(2);
    static final VMStorage xmm3 = X64Regs.vectorRegister(3);
    static final VMStorage xmm4 = X64Regs.vectorRegister(4);
    static final VMStorage xmm5 = X64Regs.vectorRegister(5);
    static final VMStorage xmm6 = X64Regs.vectorRegister(6);
    static final VMStorage xmm7 = X64Regs.vectorRegister(7);
    static final VMStorage xmm8 = X64Regs.vectorRegister(8);
    static final VMStorage xmm9 = X64Regs.vectorRegister(9);
    static final VMStorage xmm10 = X64Regs.vectorRegister(10);
    static final VMStorage xmm11 = X64Regs.vectorRegister(11);
    static final VMStorage xmm12 = X64Regs.vectorRegister(12);
    static final VMStorage xmm13 = X64Regs.vectorRegister(13);
    static final VMStorage xmm14 = X64Regs.vectorRegister(14);
    static final VMStorage xmm15 = X64Regs.vectorRegister(15);
    static final VMStorage xmm16 = X64Regs.vectorRegister(16);
    static final VMStorage xmm17 = X64Regs.vectorRegister(17);
    static final VMStorage xmm18 = X64Regs.vectorRegister(18);
    static final VMStorage xmm19 = X64Regs.vectorRegister(19);
    static final VMStorage xmm20 = X64Regs.vectorRegister(20);
    static final VMStorage xmm21 = X64Regs.vectorRegister(21);
    static final VMStorage xmm22 = X64Regs.vectorRegister(22);
    static final VMStorage xmm23 = X64Regs.vectorRegister(23);
    static final VMStorage xmm24 = X64Regs.vectorRegister(24);
    static final VMStorage xmm25 = X64Regs.vectorRegister(25);
    static final VMStorage xmm26 = X64Regs.vectorRegister(26);
    static final VMStorage xmm27 = X64Regs.vectorRegister(27);
    static final VMStorage xmm28 = X64Regs.vectorRegister(28);
    static final VMStorage xmm29 = X64Regs.vectorRegister(29);
    static final VMStorage xmm30 = X64Regs.vectorRegister(30);
    static final VMStorage xmm31 = X64Regs.vectorRegister(31);

    private X64Regs() {
    }

    private static VMStorage integerRegister(int index) {
        return new VMStorage(X64StorageType.INTEGER.getId(), 15, index);
    }

    private static VMStorage vectorRegister(int index) {
        return new VMStorage(X64StorageType.VECTOR.getId(), 1, index);
    }

    public static String getIntegerRegisterName(int idx) {
        return switch (idx) {
            case 0 -> "rax";
            case 1 -> "rcx";
            case 2 -> "rdx";
            case 3 -> "rbx";
            case 4 -> "rsp";
            case 5 -> "rbp";
            case 6 -> "rsi";
            case 7 -> "rdi";
            default -> "r" + idx;
        };
    }

    public static String getVectorRegisterName(int idx) {
        return "xmm" + idx;
    }
}

