/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama.aarch64;

import com.oracle.truffle.espresso.runtime.panama.ArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.DefaultArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.StorageType;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;
import com.oracle.truffle.espresso.runtime.panama.aarch64.AArch64Regs;
import com.oracle.truffle.espresso.runtime.panama.aarch64.AArch64StorageType;

public class AAPCS64
extends Platform {
    public static final AAPCS64 INSTANCE = new AAPCS64();
    public static final VMStorage[] CALL_INT_REGS = new VMStorage[]{AArch64Regs.r0, AArch64Regs.r1, AArch64Regs.r2, AArch64Regs.r3, AArch64Regs.r4, AArch64Regs.r5, AArch64Regs.r6, AArch64Regs.r7};
    public static final VMStorage[] CALL_FLOAT_REGS = new VMStorage[]{AArch64Regs.v0, AArch64Regs.v1, AArch64Regs.v2, AArch64Regs.v3, AArch64Regs.v4, AArch64Regs.v5, AArch64Regs.v6, AArch64Regs.v7};

    AAPCS64() {
    }

    @Override
    public StorageType getStorageType(byte id) {
        return AArch64StorageType.get(id);
    }

    @Override
    public boolean ignoreDownCallArgument(VMStorage reg) {
        return false;
    }

    @Override
    public ArgumentsCalculator getArgumentsCalculator() {
        return new DefaultArgumentsCalculator(this, CALL_INT_REGS, CALL_FLOAT_REGS, AArch64Regs.r0, AArch64Regs.v0);
    }

    @Override
    protected String getIntegerRegisterName(int idx, int maskOrSize) {
        if (maskOrSize == 1) {
            return AArch64Regs.getIntegerRegisterName(idx);
        }
        return "?INT_REG?[" + idx + ", " + maskOrSize + "]";
    }

    @Override
    protected String getVectorRegisterName(int idx, int maskOrSize) {
        if (maskOrSize == 1) {
            return AArch64Regs.getVectorRegisterName(idx);
        }
        return "?VEC_REG?[" + idx + ", " + maskOrSize + "]";
    }
}

