/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.panama;

import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.runtime.panama.DefaultArgumentsCalculator;
import com.oracle.truffle.espresso.runtime.panama.Platform;
import com.oracle.truffle.espresso.runtime.panama.VMStorage;

public class DarwinAArch64ArgumentsCalculator
extends DefaultArgumentsCalculator {
    private boolean isVarArgs;
    private int varArgsStackOffset;

    public DarwinAArch64ArgumentsCalculator(Platform platform, VMStorage[] callIntRegs, VMStorage[] callFloatRegs, VMStorage intReturn, VMStorage floatReturn) {
        super(platform, callIntRegs, callFloatRegs, intReturn, floatReturn);
    }

    @Override
    public boolean isVarArg(VMStorage reg, Klass type, VMStorage nextReg, Klass nextType) {
        if (reg.type(this.platform).isStack()) {
            if (DarwinAArch64ArgumentsCalculator.isInt(type)) {
                return this.intIndex < this.callIntRegs.length;
            }
            if (DarwinAArch64ArgumentsCalculator.isFloat(type)) {
                return this.floatIndex < this.callFloatRegs.length;
            }
        }
        return super.isVarArg(reg, type, nextReg, nextType);
    }

    @Override
    public int getNextInputIndex(VMStorage reg, Klass type, VMStorage nextReg, Klass nextType) {
        if (!this.isVarArgs) {
            this.isVarArgs = this.isVarArg(reg, type, nextReg, nextType);
        }
        if (this.isVarArgs) {
            assert (reg.type(this.platform).isStack()) : this.platform.toString(reg) + ": " + type;
            assert (this.varArgsStackOffset == reg.indexOrOffset()) : this.platform.toString(reg) + ": " + type;
            this.varArgsStackOffset += 8;
            return this.globalIndex++;
        }
        return super.getNextInputIndex(reg, type, nextReg, nextType);
    }
}

