/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage.decompressor;

import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.CompressedResourceHeader;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.ResourceDecompressor;
import com.oracle.truffle.espresso.runtime.jimage.decompressor.ResourceDecompressorRepository;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public final class Decompressor {
    private final Map<Integer, ResourceDecompressor> pluginsCache = new HashMap<Integer, ResourceDecompressor>();

    public ByteBuffer decompressResource(ByteOrder order, ResourceDecompressor.StringsProvider provider, ByteBuffer content) {
        CompressedResourceHeader header;
        Objects.requireNonNull(order);
        Objects.requireNonNull(provider);
        Objects.requireNonNull(content);
        ByteBuffer currentContent = content;
        do {
            if ((header = CompressedResourceHeader.readFromResource(currentContent)) == null) continue;
            ResourceDecompressor decompressor = this.pluginsCache.get(header.getDecompressorNameOffset());
            if (decompressor == null) {
                String pluginName = provider.getString(header.getDecompressorNameOffset());
                if (pluginName == null) {
                    throw EspressoError.shouldNotReachHere("Decompressor plugin name not found");
                }
                ByteBuffer storedContent = header.getStoredContent(provider);
                Properties props = null;
                if (storedContent != null) {
                    props = new Properties();
                    try (ByteBufferInputStream stream = new ByteBufferInputStream(storedContent);){
                        props.loadFromXML(stream);
                    }
                    catch (IOException e) {
                        throw EspressoError.shouldNotReachHere("Error while loading decompressor properties", e);
                    }
                }
                if ((decompressor = ResourceDecompressorRepository.newResourceDecompressor(props, pluginName)) == null) {
                    throw EspressoError.shouldNotReachHere("Plugin not found: " + pluginName);
                }
                this.pluginsCache.put(header.getDecompressorNameOffset(), decompressor);
            }
            currentContent = decompressor.decompress(provider, currentContent, header.getUncompressedSize());
        } while (header != null);
        return currentContent;
    }

    private static final class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buffer;

        private ByteBufferInputStream(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() throws IOException {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            return this.buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            int remaining = this.buffer.remaining();
            if (remaining == 0) {
                return -1;
            }
            int availableLength = Math.min(length, remaining);
            this.buffer.get(bytes, offset, availableLength);
            return availableLength;
        }
    }
}

