/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.jimage.decompressor;

import com.oracle.truffle.espresso.runtime.jimage.decompressor.ResourceDecompressor;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class CompressedResourceHeader {
    private static final int SIZE = 29;
    public static final int MAGIC = -889259270;
    private final long uncompressedSize;
    private final long compressedSize;
    private final int decompressorNameOffset;
    private final int contentOffset;
    private final boolean isTerminal;

    public CompressedResourceHeader(long compressedSize, long uncompressedSize, int decompressorNameOffset, int contentOffset, boolean isTerminal) {
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.decompressorNameOffset = decompressorNameOffset;
        this.contentOffset = contentOffset;
        this.isTerminal = isTerminal;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public int getDecompressorNameOffset() {
        return this.decompressorNameOffset;
    }

    public ByteBuffer getStoredContent(ResourceDecompressor.StringsProvider provider) {
        Objects.requireNonNull(provider);
        if (this.contentOffset == -1) {
            return null;
        }
        return provider.getRawString(this.contentOffset);
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public long getResourceSize() {
        return this.compressedSize;
    }

    public static int getSize() {
        return 29;
    }

    public static CompressedResourceHeader readFromResource(ByteBuffer resource) {
        Objects.requireNonNull(resource);
        if (resource.remaining() < CompressedResourceHeader.getSize()) {
            return null;
        }
        int magic = resource.getInt();
        if (magic != -889259270) {
            resource.position(resource.position() - 4);
            return null;
        }
        long compressedSize = resource.getLong();
        long uncompressedSize = resource.getLong();
        int decompressorNameOffset = resource.getInt();
        int contentIndex = resource.getInt();
        byte isTerminal = resource.get();
        return new CompressedResourceHeader(compressedSize, uncompressedSize, decompressorNameOffset, contentIndex, isTerminal == 1);
    }
}

