/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.descriptors.Symbol;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
@Shareable
public class ThrowableInterop
extends EspressoInterop {
    @ExportMessage
    public static ExceptionType getExceptionType(StaticObject receiver) throws UnsupportedMessageException {
        return ExceptionType.RUNTIME_ERROR;
    }

    @ExportMessage
    public static boolean isException(StaticObject object) {
        object.checkNotForeign();
        return true;
    }

    @ExportMessage
    public static RuntimeException throwException(StaticObject object) {
        object.checkNotForeign();
        throw object.getKlass().getMeta().throwException(object);
    }

    @ExportMessage
    public static boolean hasExceptionCause(StaticObject object) {
        object.checkNotForeign();
        Meta meta = object.getKlass().getMeta();
        Method resolvedMessageMethod = object.getKlass().lookupMethod(Symbol.Name.getCause, Symbol.Signature.Throwable);
        if (resolvedMessageMethod == meta.java_lang_Throwable_getCause) {
            StaticObject guestCause = meta.java_lang_Throwable_cause.getObject(object);
            return StaticObject.notNull(guestCause) && guestCause != object;
        }
        if (resolvedMessageMethod.isInlinableGetter()) {
            StaticObject guestCause = (StaticObject)resolvedMessageMethod.invokeDirect(object, new Object[0]);
            return StaticObject.notNull(guestCause) && guestCause != object;
        }
        return true;
    }

    @ExportMessage
    public static Object getExceptionCause(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (!ThrowableInterop.hasExceptionCause(object)) {
            throw UnsupportedMessageException.create();
        }
        return object.getKlass().lookupMethod(Symbol.Name.getCause, Symbol.Signature.Throwable).invokeDirect(object, new Object[0]);
    }

    @ExportMessage
    public static boolean hasExceptionMessage(StaticObject object) {
        object.checkNotForeign();
        Meta meta = object.getKlass().getMeta();
        Method resolvedMessageMethod = object.getKlass().lookupMethod(Symbol.Name.getMessage, Symbol.Signature.String);
        if (resolvedMessageMethod == meta.java_lang_Throwable_getMessage) {
            return StaticObject.notNull(meta.java_lang_Throwable_detailMessage.getObject(object));
        }
        if (resolvedMessageMethod.isInlinableGetter()) {
            return StaticObject.notNull((StaticObject)resolvedMessageMethod.invokeDirect(object, new Object[0]));
        }
        return true;
    }

    @ExportMessage
    public static Object getExceptionMessage(StaticObject object) throws UnsupportedMessageException {
        object.checkNotForeign();
        if (!ThrowableInterop.hasExceptionMessage(object)) {
            throw UnsupportedMessageException.create();
        }
        return object.getKlass().lookupMethod(Symbol.Name.getMessage, Symbol.Signature.String).invokeDirect(object, new Object[0]);
    }
}

