/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class MapInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(MapInterop.class));
    private static final InteropNodes INSTANCE = new MapInteropInteropNodes();

    private MapInteropInteropNodes() {
        super(MapInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.HasHashEntries, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsHashEntryInsertable, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetHashSize, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadHashValue, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteHashEntry, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.RemoveHashEntry, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetHashEntriesIterator, factory, false);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case HasHashEntries: {
                    return MapInteropInteropNodesFactory.HasHashEntriesNodeGen.create();
                }
                case IsHashEntryInsertable: {
                    return MapInteropInteropNodesFactory.IsHashEntryInsertableNodeGen.create();
                }
                case GetHashSize: {
                    return MapInteropInteropNodesFactory.GetHashSizeNodeGen.create();
                }
                case ReadHashValue: {
                    return MapInteropInteropNodesFactory.ReadHashValueNodeGen.create();
                }
                case WriteHashEntry: {
                    return MapInteropInteropNodesFactory.WriteHashEntryNodeGen.create();
                }
                case RemoveHashEntry: {
                    return MapInteropInteropNodesFactory.RemoveHashEntryNodeGen.create();
                }
                case GetHashEntriesIterator: {
                    return MapInteropInteropNodesFactory.GetHashEntriesIteratorNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class GetHashEntriesIteratorNode
    extends InteropMessage.GetHashEntriesIterator {
        GetHashEntriesIteratorNode() {
        }

        @Specialization
        static Object getHashEntriesIterator(StaticObject receiver, @CachedLibrary(limit="1") InteropLibrary setLibrary, @Cached(value="create($parameters)") InvokeEspressoNode invoke) throws UnsupportedMessageException {
            return MapInterop.getHashEntriesIterator(receiver, setLibrary, invoke);
        }
    }

    static abstract class RemoveHashEntryNode
    extends InteropMessage.RemoveHashEntry {
        RemoveHashEntryNode() {
        }

        @Specialization
        static void removeHashEntry(StaticObject receiver, Object key, @Cached(value="create($parameters)") InvokeEspressoNode invoke, @Cached(value="create($parameters)") InvokeEspressoNode contains) throws UnsupportedMessageException, UnknownKeyException {
            MapInterop.removeHashEntry(receiver, key, invoke, contains);
        }
    }

    static abstract class WriteHashEntryNode
    extends InteropMessage.WriteHashEntry {
        WriteHashEntryNode() {
        }

        @Specialization
        static void writeHashEntry(StaticObject receiver, Object key, Object value, @Cached(value="create($parameters)") InvokeEspressoNode invoke) throws UnknownKeyException {
            MapInterop.writeHashEntry(receiver, key, value, invoke);
        }
    }

    static abstract class ReadHashValueNode
    extends InteropMessage.ReadHashValue {
        ReadHashValueNode() {
        }

        @Specialization
        static Object readHashValue(StaticObject receiver, Object key, @Cached(value="create($parameters)") InvokeEspressoNode invoke, @Cached(value="create($parameters)") InvokeEspressoNode contains) throws UnsupportedMessageException, UnknownKeyException {
            return MapInterop.readHashValue(receiver, key, invoke, contains);
        }
    }

    static abstract class GetHashSizeNode
    extends InteropMessage.GetHashSize {
        GetHashSizeNode() {
        }

        @Specialization
        static long getHashSize(StaticObject receiver, @Cached(value="create($parameters)") InvokeEspressoNode invoke) throws UnsupportedMessageException {
            return MapInterop.getHashSize(receiver, invoke);
        }
    }

    static abstract class IsHashEntryInsertableNode
    extends InteropMessage.IsHashEntryInsertable {
        IsHashEntryInsertableNode() {
        }

        @Specialization
        static boolean isHashEntryInsertable(StaticObject receiver, Object key, @Cached(value="create($parameters)") InvokeEspressoNode invoke) {
            return MapInterop.isHashEntryInsertable(receiver, key, invoke);
        }
    }

    static abstract class HasHashEntriesNode
    extends InteropMessage.HasHashEntries {
        HasHashEntriesNode() {
        }

        @Specialization
        static boolean hasHashEntries(StaticObject receiver) {
            return MapInterop.hasHashEntries(receiver);
        }
    }
}

