/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class MapEntryInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(MapEntryInterop.class));
    private static final InteropNodes INSTANCE = new MapEntryInteropInteropNodes();

    private MapEntryInteropInteropNodes() {
        super(MapEntryInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.HasArrayElements, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetArraySize, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementModifiable, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.IsArrayElementReadable, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.WriteArrayElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.ReadArrayElement, factory, false);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case HasArrayElements: {
                    return MapEntryInteropInteropNodesFactory.HasArrayElementsNodeGen.create();
                }
                case GetArraySize: {
                    return MapEntryInteropInteropNodesFactory.GetArraySizeNodeGen.create();
                }
                case IsArrayElementModifiable: {
                    return MapEntryInteropInteropNodesFactory.IsArrayElementModifiableNodeGen.create();
                }
                case IsArrayElementReadable: {
                    return MapEntryInteropInteropNodesFactory.IsArrayElementReadableNodeGen.create();
                }
                case WriteArrayElement: {
                    return MapEntryInteropInteropNodesFactory.WriteArrayElementNodeGen.create();
                }
                case ReadArrayElement: {
                    return MapEntryInteropInteropNodesFactory.ReadArrayElementNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class ReadArrayElementNode
    extends InteropMessage.ReadArrayElement {
        ReadArrayElementNode() {
        }

        @Specialization
        static Object readArrayElement(StaticObject receiver, long index, @Cached(value="create($parameters)") InvokeEspressoNode invoke) throws InvalidArrayIndexException {
            return MapEntryInterop.readArrayElement(receiver, index, invoke);
        }
    }

    static abstract class WriteArrayElementNode
    extends InteropMessage.WriteArrayElement {
        WriteArrayElementNode() {
        }

        @Specialization
        static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached(value="create($parameters)") InvokeEspressoNode invoke) throws InvalidArrayIndexException {
            MapEntryInterop.writeArrayElement(receiver, index, value, invoke);
        }
    }

    static abstract class IsArrayElementReadableNode
    extends InteropMessage.IsArrayElementReadable {
        IsArrayElementReadableNode() {
        }

        @Specialization
        static boolean isArrayElementReadable(StaticObject receiver, long index) {
            return MapEntryInterop.isArrayElementReadable(receiver, index);
        }
    }

    static abstract class IsArrayElementModifiableNode
    extends InteropMessage.IsArrayElementModifiable {
        IsArrayElementModifiableNode() {
        }

        @Specialization
        static boolean isArrayElementModifiable(StaticObject receiver, long index) {
            return MapEntryInterop.isArrayElementModifiable(receiver, index);
        }
    }

    static abstract class GetArraySizeNode
    extends InteropMessage.GetArraySize {
        GetArraySizeNode() {
        }

        @Specialization
        static long getArraySize(StaticObject receiver) {
            return MapEntryInterop.getArraySize(receiver);
        }
    }

    static abstract class HasArrayElementsNode
    extends InteropMessage.HasArrayElements {
        HasArrayElementsNode() {
        }

        @Specialization
        static boolean hasArrayElements(StaticObject receiver) {
            return MapEntryInterop.hasArrayElements(receiver);
        }
    }
}

