/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.GenerateInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.messages.Shareable;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInterop;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;

@ExportLibrary(value=InteropLibrary.class, receiverType=StaticObject.class)
@GenerateInteropNodes
public class MapEntryInterop
extends EspressoInterop {
    @ExportMessage
    @Shareable
    static boolean hasArrayElements(StaticObject receiver) {
        return true;
    }

    @ExportMessage
    @Shareable
    static long getArraySize(StaticObject receiver) {
        return 2L;
    }

    @ExportMessage
    @Shareable
    static boolean isArrayElementModifiable(StaticObject receiver, long index) {
        return index == 1L;
    }

    @ExportMessage
    @Shareable
    static boolean isArrayElementReadable(StaticObject receiver, long index) {
        return index == 0L || index == 1L;
    }

    @ExportMessage
    public static void writeArrayElement(StaticObject receiver, long index, Object value, @Cached.Exclusive @Cached InvokeEspressoNode invoke) throws InvalidArrayIndexException {
        if (index != 1L) {
            throw InvalidArrayIndexException.create((long)index);
        }
        Meta meta = receiver.getKlass().getMeta();
        Method m = MapEntryInterop.doLookup(receiver, meta.java_util_Map_Entry, meta.java_util_Map_Entry_setValue);
        try {
            invoke.execute(m, receiver, new Object[]{value});
        }
        catch (ArityException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    public static Object readArrayElement(StaticObject receiver, long index, @Cached.Exclusive @Cached InvokeEspressoNode invoke) throws InvalidArrayIndexException {
        Method m;
        Meta meta = receiver.getKlass().getMeta();
        if (index == 0L) {
            m = MapEntryInterop.doLookup(receiver, meta.java_util_Map_Entry, meta.java_util_Map_Entry_getKey);
        } else if (index == 1L) {
            m = MapEntryInterop.doLookup(receiver, meta.java_util_Map_Entry, meta.java_util_Map_Entry_getValue);
        } else {
            throw InvalidArrayIndexException.create((long)index);
        }
        try {
            return invoke.execute(m, receiver, StaticObject.EMPTY_ARRAY);
        }
        catch (ArityException | UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere(e);
        }
    }

    static Method doLookup(StaticObject receiver, ObjectKlass k, Method m) {
        assert (k.isInterface() && m.getDeclaringKlass() == k);
        return MapEntryInterop.getInteropKlass(receiver).itableLookup(k, m.getITableIndex());
    }
}

