/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.EspressoInteropInteropNodes;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInterop;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInteropInteropNodesFactory;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.substitutions.Collect;

@Collect(getter="getInstance", value={InteropNodes.class})
public final class IteratorInteropInteropNodes
extends InteropNodes {
    private static final Factory factory = new Factory(InteropMessageFactories.dispatchToId(IteratorInterop.class));
    private static final InteropNodes INSTANCE = new IteratorInteropInteropNodes();

    private IteratorInteropInteropNodes() {
        super(IteratorInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static InteropNodes getInstance() {
        return INSTANCE;
    }

    @Override
    protected void registerMessages(Class<?> cls) {
        InteropMessageFactories.register(cls, InteropMessage.Message.IsIterator, factory, true);
        InteropMessageFactories.register(cls, InteropMessage.Message.HasIteratorNextElement, factory, false);
        InteropMessageFactories.register(cls, InteropMessage.Message.GetIteratorNextElement, factory, false);
    }

    static final class Factory
    implements InteropMessageFactory {
        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return this.sourceDispatch;
        }

        @Override
        public final InteropMessage create(InteropMessage.Message message) {
            switch (message) {
                case IsIterator: {
                    return IteratorInteropInteropNodesFactory.IsIteratorNodeGen.create();
                }
                case HasIteratorNextElement: {
                    return IteratorInteropInteropNodesFactory.HasIteratorNextElementNodeGen.create();
                }
                case GetIteratorNextElement: {
                    return IteratorInteropInteropNodesFactory.GetIteratorNextElementNodeGen.create();
                }
            }
            return null;
        }
    }

    static abstract class GetIteratorNextElementNode
    extends InteropMessage.GetIteratorNextElement {
        GetIteratorNextElementNode() {
        }

        @Specialization
        static Object getIteratorNextElement(StaticObject receiver, @Bind(value="getMeta().java_util_Iterator_next") Method next, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookupAndInvoke) throws StopIterationException {
            return IteratorInterop.getIteratorNextElement(receiver, next, lookupAndInvoke);
        }
    }

    static abstract class HasIteratorNextElementNode
    extends InteropMessage.HasIteratorNextElement {
        HasIteratorNextElementNode() {
        }

        @Specialization
        static boolean hasIteratorNextElement(StaticObject receiver, @Bind(value="getMeta().java_util_Iterator_hasNext") Method hasNext, @Cached(value="create($parameters)") LookupAndInvokeKnownMethodNode lookupAndInvoke) {
            return IteratorInterop.hasIteratorNextElement(receiver, hasNext, lookupAndInvoke);
        }
    }

    static abstract class IsIteratorNode
    extends InteropMessage.IsIterator {
        IsIteratorNode() {
        }

        @Specialization
        static boolean isIterator(StaticObject receiver) {
            return IteratorInterop.isIterator(receiver);
        }
    }
}

