/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime.dispatch.messages;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;

public final class InteropMessageRootNode
extends RootNode {
    @Node.Child
    InteropMessage node;
    private final UncaughtExceptionHandler interopExceptionHandler;

    public InteropMessageRootNode(TruffleLanguage<?> language, InteropMessage node) {
        this(language, node, UncaughtExceptionHandler.DEFAULT);
    }

    public InteropMessageRootNode(TruffleLanguage<?> language, InteropMessage node, UncaughtExceptionHandler handler) {
        super(language);
        this.node = (InteropMessage)this.insert(node);
        this.interopExceptionHandler = handler;
    }

    public Object execute(VirtualFrame frame) {
        try {
            return this.node.execute(frame.getArguments());
        }
        catch (InteropException e) {
            this.interopExceptionHandler.doHandle(e);
            return null;
        }
    }

    public String getName() {
        return "RootNode for interop message: '" + this.node.name() + "'.";
    }

    private static <T extends Throwable> RuntimeException sneakyThrow(Throwable ex) throws T {
        throw ex;
    }

    public static abstract class UncaughtExceptionHandler {
        private static final UncaughtExceptionHandler DEFAULT = new UncaughtExceptionHandler(){

            @Override
            protected void handle(Throwable t) {
                throw InteropMessageRootNode.sneakyThrow(t);
            }
        };

        @CompilerDirectives.TruffleBoundary
        private void doHandle(Throwable t) {
            this.handle(t);
        }

        protected abstract void handle(Throwable var1);
    }
}

