/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.espresso.runtime.PlatformBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.home.HomeFinder;

final class LinuxBuilder
extends PlatformBuilder {
    private static final Path SYS_EXT_DIR = Paths.get("/usr/java/packages", new String[0]);
    private static final List<Path> DEFAULT_LIBPATH = Collections.unmodifiableList(Arrays.asList(Paths.get("/usr/lib64", new String[0]), Paths.get("/lib64", new String[0]), Paths.get("/lib", new String[0]), Paths.get("/usr/lib", new String[0])));

    LinuxBuilder(Path espressoLibs) {
        super(espressoLibs);
    }

    @Override
    List<Path> defaultJavaLibraryPath() {
        ArrayList<Path> paths = new ArrayList<Path>();
        LinuxBuilder.expandEnvToPath("LD_LIBRARY_PATH", paths);
        paths.add(SYS_EXT_DIR.resolve("lib").resolve(CPU_ARCH));
        paths.add(SYS_EXT_DIR.resolve("lib"));
        paths.addAll(DEFAULT_LIBPATH);
        return paths;
    }

    @Override
    List<Path> defaultBootLibraryPath() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.javaHome().resolve("lib").resolve(CPU_ARCH));
        paths.add(this.javaHome().resolve("lib"));
        return paths;
    }

    @Override
    List<Path> defaultJvmLibraryPath() {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path graalvmHome = HomeFinder.getInstance().getHomeFolder();
        if (graalvmHome != null && Files.isDirectory(graalvmHome, new LinkOption[0])) {
            paths.add(graalvmHome.resolve("lib").resolve(CPU_ARCH).resolve("truffle"));
            paths.add(graalvmHome.resolve("lib").resolve("truffle"));
        }
        paths.add(this.espressoLibs());
        return paths;
    }

    @Override
    List<Path> defaultExtDirs() {
        return Arrays.asList(this.javaHome().resolve(EXTENSIONS_DIR), SYS_EXT_DIR.resolve(EXTENSIONS_DIR));
    }
}

