/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.espresso.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.espresso.impl.ContextAccessImpl;
import com.oracle.truffle.espresso.meta.EspressoError;
import com.oracle.truffle.espresso.nodes.commands.AddPathToBindingsCache;
import com.oracle.truffle.espresso.nodes.commands.ReferenceProcessCache;
import com.oracle.truffle.espresso.nodes.quick.VolatileArrayAccess;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage;
import com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories;

public class LazyContextCaches
extends ContextAccessImpl {
    @CompilerDirectives.CompilationFinal
    private volatile ReferenceProcessCache referenceProcessCache = null;
    @CompilerDirectives.CompilationFinal
    private volatile AddPathToBindingsCache addPathToBindingsCache = null;
    private final CallTarget[] messages = new CallTarget[10 * InteropMessage.Message.MESSAGE_COUNT];
    private static final CallTarget NO_IMPL = new RootNode(null){

        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw EspressoError.shouldNotReachHere();
        }
    }.getCallTarget();

    public LazyContextCaches(EspressoContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceProcessCache getReferenceProcessCache() {
        ReferenceProcessCache cache = this.referenceProcessCache;
        if (cache == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            LazyContextCaches lazyContextCaches = this;
            synchronized (lazyContextCaches) {
                cache = this.referenceProcessCache;
                if (cache == null) {
                    cache = this.referenceProcessCache = new ReferenceProcessCache(this.getContext());
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddPathToBindingsCache getAddPathToBindingsCache() {
        AddPathToBindingsCache cache = this.addPathToBindingsCache;
        if (cache == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            LazyContextCaches lazyContextCaches = this;
            synchronized (lazyContextCaches) {
                cache = this.addPathToBindingsCache;
                if (cache == null) {
                    cache = this.addPathToBindingsCache = new AddPathToBindingsCache(this.getContext());
                }
            }
        }
        return cache;
    }

    public CallTarget getInteropMessage(InteropMessage.Message message, int dispatch) {
        int index = InteropMessageFactories.getIndex(dispatch, message);
        CallTarget target = this.messages[index];
        if (target == null) {
            CallTarget toRegister = InteropMessageFactories.createInteropMessageTarget(this.getContext().getLanguage(), dispatch, message);
            if (toRegister == null) {
                toRegister = NO_IMPL;
            }
            if (VolatileArrayAccess.compareAndSet(this.messages, index, null, toRegister)) {
                target = toRegister;
            } else {
                target = VolatileArrayAccess.volatileRead(this.messages, index);
                assert (target != null);
            }
        }
        return LazyContextCaches.interpretCacheTarget(target);
    }

    private static CallTarget interpretCacheTarget(CallTarget target) {
        return target == NO_IMPL ? null : target;
    }
}

